#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_mailman_checkqueue.pl,v 1.2 2004/09/22 08:11:50 yeupou Exp $
# Copyright (C) Mathieu Roy <yeupou@gnu.org>, 2004
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# Purpose: check if there are more than a given number of messages
#   in mailman qfiles, reflecting a potential load problem or bug
#   in parsing a mail.

use strict;
use Getopt::Long;
use POSIX qw(strftime);

my $script = "sv_mailman_checkqueue";

# Import
our $sys_mail_domain;
our $sys_cron_mailman;

# Preconfigure
my $getopt;
my $help;
my $limit = "80";
my $count;
my $dir = "/var/lib/mailman/qfiles";
my $cron;

eval {
    $getopt = GetOptions("dir=s" => \$dir,
			 "limit=s" => \$limit,
			 "cron" => \$cron,
			 "help" => \$help);
};

if($help || !$getopt) {
    print STDERR <<EOF;
Usage: $0 --dir --mail popol\@myserver.net

Check if there are more than a given number of messages in mailman qfiles, 
reflecting a potential load problem or bug in parsing a mail.

      --help                   Show this help and exit
      --dir=</path>            Path of the qfiles directory.
                               (Default: $dir)
      --limit=<number>         Limit of mails that should be pending normally
                               (Default: $limit)
      --cron                   Option to set when including this script
                               in a crontab

Author: yeupou\@gnu.org
EOF
 exit(1);
}

# Test if we should run, according to conffile
exit if ($cron && ! $sys_cron_mailman);

opendir(DIR, $dir)
    or die "Not able to open $dir. Exiting";

while (defined(my $file = readdir(DIR))) {
    # count only the .msg files
    next unless $file =~ /.*\.msg$/;
    $count++;
    last if $count > $limit;
}

closedir(DIR);

print "Warning:\n\nThere are more than $count messages in the mailman queue.\nIt may be a load problem or a bug in mail parsing by mailman.\n" if $count > $limit;

# END

