#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: Cvs.pm,v 1.8 2004/05/14 09:54:08 zerodeux Exp $
#
# Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

##
## Desc: any subs related to CVS.
## (Called Cvs instead of CVS to avoid confusion with /CVS)
## 
## Currently, the location of the locks is hardcoded, as the anoncvs
## group.
##

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(GetScriptCvsrootInit );
our $version = 1;


## Make a cvs area
sub CvsMakeArea {
    my ($name,$dir_cvs,$is_public) = @_;
    my $warning = "";

    # %PROJECT is not mandatory, but if it is missing, it may well be 
    # a major misconfiguration.
    # It should only happen if a directory has been set for a specific 
    # project.
    unless ($dir_cvs =~ s/\%PROJECT/$name/) {
	$warning = " (The string \%PROJECT was not found, there may be a group type serious misconfiguration)";
    }

    unless (-e $dir_cvs) {
	
	# build the directory
	my $mode = $is_public ? 2775 : 2770;
	`mkdir -p $dir_cvs`;
	`chmod $mode $dir_cvs`;
	`cd $dir_cvs && CVSROOT=$dir_cvs cvs init`;

	# configure cvs
	open(FILE, "> $dir_cvs/CVSROOT/config");
	print FILE "# Set this to \"no\" if pserver shouldn't check system users/passwords
SystemAuth=no

# Put CVS lock files in this directory rather than directly in the repository.
LockDir=/var/lock/cvs/$name

# Set TopLevelAdmin to yes to create a CVS directory at the top
# level of the new working directory when using the cvs checkout
# command.
#TopLevelAdmin=no

# Set LogHistory to AMRT
# (log only modifications)
LogHistory=AMRT
"; 
	close(FILE);
	
	open(FILE, ">> $dir_cvs/CVSROOT/checkoutlist");
	print FILE "readers         Wont be able to control read-only access.
passwd          Wont be able to add pserver accounts.
";
	close(FILE);


	open(FILE, "> $dir_cvs/CVSROOT/passwd");
	print FILE "anoncvs:02oawyZdjhhpg
anonymous:02oawyZdjhhpg
";
	close(FILE);

	open(FILE, "> $dir_cvs/CVSROOT/readers");
	print FILE "anoncvs
anonymous
";
	close(FILE);

	open(FILE, "> $dir_cvs/CVSROOT/config");
	print FILE "# Set this to \"no\" if pserver shouldn't check system users/passwords
SystemAuth=no

# Put CVS lock files in this directory rather than directly in the repository.
LockDir=/var/lock/cvs/$name

# Set TopLevelAdmin to yes to create a CVS directory at the top
# level of the new working directory when using the cvs checkout
# command.
#TopLevelAdmin=no


# Set LogHistory to AMRT
# (log only modifications)
LogHistory=AMRT
"; 
	close(FILE);

	# cp the config file to be able to do ci on 'passwd' and 'readers'
	# without being prompted
	`cp $dir_cvs/CVSROOT/config,v $dir_cvs/CVSROOT/passwd,v`;
	`cp $dir_cvs/CVSROOT/config,v $dir_cvs/CVSROOT/readers,v`;

	# ci
	`rcs -q -U $dir_cvs/CVSROOT/config $dir_cvs/CVSROOT/passwd $dir_cvs/CVSROOT/checkoutlist $dir_cvs/CVSROOT/readers`;
	`ci -q -m"added by Savannah::Pm (anoncvs LockDir + SystemAuth)" $dir_cvs/CVSROOT/config $dir_cvs/CVSROOT/passwd $dir_cvs/CVSROOT/checkoutlist $dir_cvs/CVSROOT/readers`;
	`co -q $dir_cvs/CVSROOT/config $dir_cvs/CVSROOT/passwd $dir_cvs/CVSROOT/checkoutlist $dir_cvs/CVSROOT/readers`;


	`touch $dir_cvs/CVSROOT/val-tags`;
	`mkdir $dir_cvs/$name`;    # create the default module
	`chmod 2775 $dir_cvs/$name`;
	`chgrp -R $name $dir_cvs`;
	`chown root.adm $dir_cvs/CVSROOT -R`; # make the CVSROOT ro for anybody
	                                      # doing otherwise is a major
	                                      # security hole.
	`chgrp $name $dir_cvs/CVSROOT/history`; # history must be group writable
  `chmod 664 $dir_cvs/CVSROOT/history`;
	`chgrp $name $dir_cvs/CVSROOT/val-tags`;
	`chmod 666 $dir_cvs/CVSROOT/val-tags`; # val tag go world writable
	                                       # see task #147 @gna.org

	# build the locks
	`mkdir -p /var/lock/cvs/$name`;
	`chmod 777 /var/lock/cvs/$name`;
	`chgrp $name /var/lock/cvs/$name`;

	return " ".$dir_cvs.$warning;
    } 
    return 0;
}


## Make a cvs area at gn!elsewhere.
## Ask yeupou@gna.org before modifying this function
sub CvsMakeAreaAttic {
    # Run the default sequence
    my $ret = CvsMakeArea(@_);
    
    
    if ($ret) {
	my ($name,$dir_cvs,$is_public) = @_;
	
	$dir_cvs =~ s/\%PROJECT/$name/;
	
	# hardcode cvsreport support
	open(FILE, "> $dir_cvs/CVSROOT/commitinfo");
	print FILE "ALL\tcvsreport -e 'mail text+html $name-cvs'\n";
	close(FILE);
	`rcs -q -U $dir_cvs/CVSROOT/commitinfo`;
	`ci -q -m"added by Savannah::Pm (cvsreport support)" $dir_cvs/CVSROOT/commitinfo`;
	`co -q $dir_cvs/CVSROOT/commitinfo`;
	
	return " ".$dir_cvs;
    }

    return;
}
