#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: Conf.pm,v 1.10 2004/11/22 08:25:51 yeupou Exp $
#
# Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

##
## Desc: any subs related to database access...
## Usually used in other subs.
##

use strict "vars";
require Exporter;

# Exports
our @ISA = qw(Exporter);
our @EXPORT = qw(GetConf AreWeOnSubversions );
our $version = 1;

# Imports (needed for strict)
our $conffile;
our $sys_default_domain;
our $prefix;

# Init: read configuration file
# 
# FIXME: we should have some way to select different Savannah installation
# on the same computer, for instance by saving the location of their conffiles
# in /etc/savannah.list
# Currently solution is to do what we do with Apache, we set an environment
# variable, SAVANE_CONF.

# First try to honor environment variable
if ($ENV{SAVANE_CONF}) {
    if (-e $ENV{SAVANE_CONF}."/savannah.conf.pl") {
	our $conffile = $ENV{SAVANE_CONF}."/savannah.conf.pl";	
    } else {
	print RED,"Can't honor SAVANE_CONF environment variable,",RESET," going back to default.\n";
    }
}
unless ($conffile) {
    if (-e "/etc/savane/savannah.conf.pl") {
	our $conffile = "/etc/savane/savannah.conf.pl";
    } elsif (-e "/etc/savannah/savannah.conf.pl") {
	our $conffile = "/etc/savannah/savannah.conf.pl";  
    } elsif (-e "/usr/etc/savane/savannah.conf.pl") {
	our $conffile = "/usr/etc/savane/savannah.conf.pl";    
    } elsif (-e "/usr/local/etc/savane/savannah.conf.pl") {
	our $conffile = "/usr/local/etc/savane/savannah.conf.pl";    
    } else {
	die "Unable to find any configuration file.\n\nStopped";
    }
}
do $conffile or die "Unable to run $conffile.\n", RED,"Most commonly, it's a privilege issue.",RESET,"\n\nStopped";


# Return a configuration item
sub GetConf {
    my $arg = $_[0];
    return $$arg;    
}

# Determine whether we are at sv.gnu.org or not
sub AreWeOnSubversions {
    if ($sys_default_domain eq 'savannah.gnu.org') {
	return 1;
    } else {
	return 0;
    }
}
