<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.2 2004/11/26 16:25:26 yeupou Exp $
#
#  Copyright 2004-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#                          Yves Perrin <yves.perrin--at--cern.ch>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Later, this page will provide per group and per group type statistics.

require "../include/pre.php";

site_header(array('title'=>"Statistics"));

######################## BETWEEN TWO DATES 

if (!$update)
{
  $since_month = date("m")-1;
  $since_day = date("d");
  $since_year = date("Y");

  $until_month = date("m");
  $until_day = date("d");
  $until_year = date("Y");

  $hour = date("H");
  $min = date("i");
}
else
{
  # If the user selected date, assume he speaks of completed days
  $hour = 0;
  $min = 0;
}

$since = mktime($hour,$min,0,$since_month, $since_day, $since_year);
$until = mktime($hour,$min,0,$until_month, $until_day, $until_year);

print '<p>&nbsp;&nbsp;</p>';
print '
<h3>'.html_anchor(sprintf(_("Since %s until %s"),format_date($sys_datefmt,$since),format_date($sys_datefmt,$until)),"between").'</h3>';

if ($since > $until)
{
  print '<p class="error">'._("Apparently, the period you asked for is incoherent.").'</p>';
}

print '<form action="'.$PHP_SELF.'#between" method="GET">';
print sprintf(_("Since the %s until the %s."), 
	      calendar_selectbox("day",$since_day,"since_day").calendar_selectbox("month",$since_month,"since_month").'<input type="text" value="'.addslashes($since_year).'" name="since_year" size="4" maxlength="4" />',
	      calendar_selectbox("day",$until_day,"until_day").calendar_selectbox("month",$until_month,"until_month").'<input type="text" value="'.addslashes($until_year).'" name="until_year" size="4" maxlength="4" />');
print ' <input value="'._("Apply").'" name="update" type="submit">';
print '</form>';


print '
<h4>'._("Accounts:").'</h4>
<p>';

$count_users = stats_getusers();
$count_groups = stats_getprojects();

$content = array();
$total = array();

$count = stats_getusers("add_date>='$since' AND add_date<='$until'");
$content[_("New users")] = $count;
$total[_("New users")] = $count_users;
print '&nbsp&nbsp;- '.sprintf(_("%s new user(s)"),$count).'<br />
'; 

$count = stats_getprojects("","","register_time>='$since' AND register_time<='$until'");
$content[_("New groups")] = $count;
$total[_("New groups")] = $count_groups;
print '&nbsp&nbsp;- '.sprintf(_("%s new project(s)"),$count).'<br />
';

print '</p><p>'._("New users and New Groups / Total:");
graphs_build($content,0,0,$total);
unset($content,$total);


$total_patch = stats_getitems("patch");
$total_task = stats_getitems("task");
$total_bugs = stats_getitems("bugs");
$total_support = stats_getitems("support");


print '</p>
<h4>'._("Trackers:").'</h4>
<p>';


$content = array();
$content_total = array();

if ($total_support > 0)
{
  $count = stats_getitems("support", 0, "date>='$since' AND date<='$until'");
  $total = $count;
  $total_open = 0;
  $count_open = stats_getitems("support", 3, "date>='$since' AND date<='$until'");
  $total_open += $count_open;
  print '&nbsp&nbsp;- '.sprintf(_("%s new support request(s), including %s already closed"),$count, $count_open).'<br />
';
  $content[_("Support Request(s)")] = $count;
  $content_total[_("Support Request(s)")] = $total_support;
  
}

if ($total_bugs > 0)
{
  $count = stats_getitems("bugs", 0, "date>='$since' AND date<='$until'");
  $total += $count;
  $count_open = stats_getitems("bugs", 3, "date>='$since' AND date<='$until'");
  $total_open += $count_open;
  
  print '&nbsp&nbsp;- '.sprintf(_("%s new bug(s), including %s already closed"),$count, $count_open).'<br />
';
  $content[_("Bug(s)")] = $count;
  $content_total[_("Bug(s)")] = $total_bugs;
}

if ($total_task > 0)
{
  $count = stats_getitems("task", 0, "date>='$since' AND date<='$until'");
  $total += $count;
  $count_open = stats_getitems("task", 3, "date>='$since' AND date<='$until'");
  $total_open += $count_open;
  
  print '&nbsp&nbsp;- '.sprintf(_("%s new task(s), including %s already closed"),$count, $count_open).'<br />
';
  $content[_("Task(s)")] = $count;
  $content_total[_("Task(s)")] = $total_task;
}

if ($total_patch > 0)
{
  $count = stats_getitems("patch", 0, "date>='$since' AND date<='$until'");
  $total += $count;
  $count_open = stats_getitems("patch", 3, "date>='$since' AND date<='$until'");
  $total_open += $count_open;
  print '&nbsp&nbsp;- '.sprintf(_("%s new patch(es), including %s already closed"),$count, $count_open).'<br />
';
  $content[_("Patch(es)")] = $count;
  $content_total[_("Patch(es)")] = $total_patch;
}

if ($total_patch < 1 &&  $total_task  < 1 && $total_support < 1 && $total_bugs < 1) 
{
  print _("The trackers looks unused, no items were found");
}
else
{
  print '<br />
&nbsp&nbsp;- '.sprintf(_("%s new item(s), including %s already closed"),$total, $total_open).'<br />
';
  
  print '</p><p>'._("New items per Tracker / Tracker Total:");
  graphs_build($content,0,0,$content_total);
  unset($content,$content_total);
  
}

  print '</p>
';

print '<p>&nbsp;</p>';

##################### GENERAL
print '
<h3>'.html_anchor(_("General"),"general").'</h3>';

print '
<h4>'._("Accounts:").'</h4>
<p>';

$content = array();

#print _("Are listed only active accounts.");

print '&nbsp&nbsp;- '.sprintf(_("%s users"),$count_users).'<br />
';
print '&nbsp&nbsp;- '.sprintf(_("%s projects, including %s in private state"),$count_groups,stats_getprojects("","0")).'<br />
';

$result = db_query("SELECT type_id,name FROM group_type ORDER BY type_id");
while ($eachtype = db_fetch_array($result)) 
{
  $content[$eachtype['name']] = stats_getprojects($eachtype['type_id']);
}

print '</p><p>'._("Projects per Group Type:");
graphs_build($content,0,0);
unset($content);



print '</p>
<h4>'._("Trackers:").'</h4>
<p>';

$content = array();

$count = $total_support;
$total = $count;
$total_open = 0;
if ($count > 0)
{
  $count_open = stats_getitems("support", 1);
  $total_open += $count_open;

  print '&nbsp&nbsp;- '.sprintf(_("%s support request(s), including %s open one(s)"),$count, $count_open).'<br />
';

  $content[_("Support Request(s)")] = $count;
}

$count = $total_bugs;
$total += $count;
if ($count > 0)
{
  $count_open = stats_getitems("bugs", 1);
  $total_open += $count_open;

  print '&nbsp&nbsp;- '.sprintf(_("%s bug(s), including %s open one(s)"),$count, $count_open).'<br />
';

  $content[_("Bug(s)")] = $count;
}

$count = $total_task;
$total += $count;
if ($count > 0)
{
  $count_open = stats_getitems("task", 1);
  $total_open += $count_open;

  print '&nbsp&nbsp;- '.sprintf(_("%s task(s), including %s open one(s)"),$count, $count_open).'<br />
';

  $content[_("Task(s)")] = $count;
}

$count = $total_patch;
$total += $count;
if ($count > 0)
{
  $count_open = stats_getitems("patch", 1);
  $total_open += $count_open;

  print '&nbsp&nbsp;- '.sprintf(_("%s patch(es), including %s open one(s)"),$count, $count_open).'<br />
';

  $content[_("Patch(es)")] = $count;
}
print '<br />
&nbsp&nbsp;- '.sprintf(_("%s item(s), including %s open one(s)"),$total, $total_open).'<br />
';

print '</p><p>'._("Items per Tracker:");
graphs_build($content,0,0);
unset($content);


print '</p>
';

site_footer(0);

?>