<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: confirmation.php,v 1.67 2004/11/22 09:01:40 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#                          Mathieu Roy <yeupou--at--gnu.org>
#
#  Copyright 2004      (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

define("ARTIFACT", "task");
require "../include/pre.php";
session_require(array('isloggedin'=>'1'));
require "../include/vars.php";

$project=project_get_object($group_id);
if ($show_confirm && $rand_hash)
{
  $HTML->header(array('title'=>_("Registration Complete")));
  $sql="UPDATE groups SET type='$group_type' WHERE group_id='$group_id' AND rand_hash='__$rand_hash'";
  $result=db_query($sql);

  $sql="SELECT * FROM groups WHERE group_id='$group_id' AND rand_hash='__$rand_hash'";
  $result=db_query($sql);

  print '
<h3>'._("Final Confirmation").'</h3>
<h3 align="center"><font class="warn">'._("Do not click back button after this point!!").'</font></h3>

<form action="'.$PHP_SELF.'" method="post">
<input type="hidden" name="no_redirection" value="1">
<input type="hidden" name="group_id" value="'.$group_id.'">
<input type="hidden" name="rand_hash" value="'.$rand_hash.'">

<h5>'._("Description:").'</h5>
<textarea name="form_purpose" wrap="virtual" cols="70" rows="15">'.db_result($result,0,'register_purpose').'</textarea>

<h5>'._("Other Software Required:").'</h5>
<textarea name="form_required_sw" wrap="virtual" cols="70" rows="6">'.db_result($result,0,'required_software').'</textarea>

<h5>'._("Other Comments:").'</h5>
<textarea name="form_comments" wrap="virtual" cols="70" rows="4">'.db_result($result,0,'other_comments').'</textarea>

<h5>'._("Full Name:").'</h5>
<input size="40" maxlength="40" type="text" name="form_full_name" value="'.db_result($result,0,'group_name').'">

<h5>'._("System Name:").'</h5>'
    . db_result($result,0,'unix_group_name')
    . '
<h5>'._("Project Type").':</h5>
   ';
  print show_group_type_box('group_type',$group_type);
  print '
<h5>'._("License").':</h5>
<select name="form_license">
   ';

  while (list($k,$v) = each($LICENSE))
    {
      print "<option value=\"$k\"";
      if ($k==db_result($result,0,'license'))
	{
	  print ' selected';
	}
      print ">$v</option>\n";
    }
  print '</select>';
  print '
<h5>'._("Other License:").'</h5>
<textarea name="form_license_other" wrap="virtual" cols="60" rows="10">'
    . db_result($result,0,'license_other') . '</textarea>
<p>'
    ._("If you confirm it, your project registration will be saved, waiting for a system administrator to approve it. If you reject it, this registration will be discarded.").'
</p>
<p class="center">
<input type="submit" name="i_agree" value="'
    ._("Confirm").'">
<input type="submit" name="i_disagree" value="'
    ._("Reject").'">
</p>
</form>';

  $HTML->footer(array());

}
else if ($i_agree && $group_id && $rand_hash)
{
  # complete the db entries
  $result=db_query("UPDATE groups SET status='P', "
		   .	"register_purpose='".htmlspecialchars($form_purpose)."', "
		   .	"required_software='".htmlspecialchars($form_required_sw)."', "
		   .	"other_comments='".htmlspecialchars($form_comments)."', "
		   .	"group_name='$form_full_name', license='$form_license', "
		   .	"license='".htmlspecialchars($form_license)."', "
		   .	"license_other='".htmlspecialchars($form_license_other)."', "
		   .	"type='".htmlspecialchars($group_type)."'"
		   .	"WHERE group_id='$group_id' AND rand_hash='__$rand_hash'");

  if (db_affected_rows($result) < 1)
    {
      exit_error(_("Unable to update database, please contact administrators"));
    }

  # make the current user an admin
  $result = member_add(user_getid(), $group_id, "A");

  # admin    bugs  forums
  if (!$result)
    {
      exit_error(_("Setting you as project admin failed"));
    }

  $user_realname = user_getrealname(user_getid());
  $user_email = user_getemail(user_getid());
  $unix_name = group_getunixname($group_id);
  $sql_type = db_query("SELECT name FROM group_type WHERE type_id='$group_type'");
  $type = db_result($sql_type,0,'name');
  $type_base_host = $project->getTypeBaseHost();
  $type_admin_email_address = $project->getTypeAdminEmailAddress();

  # get site-specific content. It will define confirmation_gen_email()
  utils_get_content("register/confirmation_mail");

  $message = confirmation_gen_email ($type_base_host, $user_realname, $user_email, $type_admin_email_address, $form_license, $form_license_other, $form_full_name, $unix_name, $type, $form_purpose, $form_required_sw, $form_comments);

  $message_user = "$message"
     ."\n\n\n\n"
     ."*"._("In case you have to register your project again").".\n\n"
     .sprintf(_("Please be aware that if your registration does not fulfill all the requirements, the %s administrators may ask you to register your project again."),$GLOBALS['sys_name'])
     ._("You can use the following URL to do a new registration starting with the values used in this registration process.")."\n"
     ._("Copy and paste AS ONE SINGLE URL the following content:")."\n"
     ."----RERegistration-URL-BEGIN-----\n"
     ."http://".$project->getTypeBaseHost().$GLOBALS['sys_home']."register/basicinfo.php?re_purpose=".rawurlencode($form_purpose)."&re_require_sw=".rawurlencode($form_required_sw)."&re_comments=".rawurlencode($form_comments)."&re_full_name=".rawurlencode($form_full_name)."&re_unix_name=".rawurlencode($unix_name)."\n"
     ."----RERegistration-URL-END-------\n";

  $message_admin = "
Site Admin. Approval/Edition URL:
 <".$GLOBALS['sys_https_url'].$GLOBALS['sys_home']."admin/groupedit.php?group_id=".$group_id.">


###### ORIGINAL SUBMISSION DETAILS ######

System Group Name:
-----------------
  $unix_name


Full Name:
----------
  $form_full_name
  

Type:
-----
  $type


License:
-------- 
  ".$LICENSE[$form_license]."


Other License: 
--------------
  $form_license_other


Description:
------------
  $form_purpose


Other Software Required:
------------------------
  $form_required_sw


Other Comments:
---------------
  $form_comments

#########################################
";

  # a mail for the submitter
  sendmail_mail($type_admin_email_address,
		$user_email,
		"submission of $form_full_name - $type_base_host",
		$message_user,
		0,0,0,
		$type_admin_email_address);


  # a mail for the moderators staff!
# Done automatically by the task tracker
#  sendmail_mail($user_email,
#		$type_admin_email_address,
#		"submission of $form_full_name - $type_base_host",
#		$message_admin,
#		0,0,0,
#		$user_email);

  # special case: the unix_group_name fit the sys_unix_group_name:
  #   this project must be activated.
  if ($GLOBALS['sys_group_id'] == $group_id)
    {
      db_query("UPDATE groups SET status='A' WHERE group_id='$group_id' AND rand_hash='__$rand_hash'");
      # We also add a specific field for the task tracker
      # (we need to copy the None field)
      db_query("INSERT INTO task_field_value (bug_field_id,group_id,value_id,value,description,order_id,status) VALUES (103,$group_id,100,'None','',10,'P')");
      db_query("INSERT INTO task_field_value (bug_field_id,group_id,value_id,value,description,order_id,status) VALUES (103,$group_id,1,'Project Approval','Pending project registration',11,'P')");

    }
  else
    {
      require_directory("trackers");
      trackers_init($GLOBALS['sys_group_id']);
      # Otherwise, create a new item on the admin task tracker
      $vfl = array();
      $vfl['category_id'] = '1';
      $vfl['summary'] = 'Submission of '.$form_full_name;
      $vfl['details'] = $message_admin;
      $address = "";
      $item_id = trackers_data_create_item($GLOBALS['sys_group_id'],$vfl,$address);
      # send an email to notify the admins of the ite update
      list($additional_address, $sendall) = trackers_data_get_item_notification_info($item_id, ARTIFACT, 1);
      if ((trim($address) != "") && (trim($additional_address) != "")) 
	{ $address .= ", "; }
      $address .= $additional_address;
      # exclude the submitter from the notification, he got a specific mail
      # for himself
      trackers_mail_followup($item_id, $address, false, user_getname());
      fb(sprintf(_("Task #%s opened"),$item_id));
    }

  if ($GLOBALS['sys_group_id'] != $group_id)
    {
      # get site-specific content, if it is not the localadmin project
      site_header(array('title'=>_("Registration Complete")));
      utils_get_content("register/confirmation");
      site_footer(array());
    }
  else
    {
      # redirect to the trigger page
      session_redirect($GLOBALS['sys_home']."admin/triggercreation.php?group_id=".$group_id);
    }

}
else if ($i_disagree && $group_id && $rand_hash)
{
  $HTML->header(array('title'=>_("Registration Deleted")));
  $result=db_query("DELETE FROM groups "
		   .	"WHERE group_id='$group_id' AND rand_hash='__$rand_hash'");

  print '
<h3>'._("Project Deleted").'</h3>
<p>'._("Please try again any other time.").'</p>';

  $HTML->footer(array());

}
else
{
  exit_error('Error',_("This is an invalid state.").' '
	     ._("Some form variables were missing.").' '
	     .sprintf(_("If you are certain you entered everything, %sPLEASE%s report to %s including info on your browser and platform configuration."),'<b>','</b>',$GLOBALS['sys_email_address']));
}

?>
