<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: useradmin.php,v 1.9 2004/11/23 12:11:57 yeupou Exp $
#
#  Copyright 2003-2004 (c) Frederik Orellana <frederik.orellana--cern.ch>
#                          Derek Feichtinger <derek.feichtinger--cern.ch>
#                          Mathieu Roy <yeupou--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "../../include/pre.php";

session_require(array('group'=>$group_id,'admin_flags'=>'A'));

function show_pending_users_list ($result, $group_id)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_pending_users_list ($result, $group_id) ';
  global $PHP_SELF;
  print "<h3>"._("Users Pending for Group")."</h3>
	<p>
        "._("User(s) that have requested to be member of the Group are listed here. To approve his/their request(s), select his/their name(s) and click on the button below.")."
	<form action=\"$PHP_SELF\" method=\"post\">
	<input type=\"HIDDEN\" name=\"action\" VALUE=\"approve_for_group\">
  <select name=\"user_id[]\" size=\"10\" multiple>\n";

  while ($usr = db_fetch_array($result)) {
    print "<option value=".$usr[user_id].">".$usr[realname].
      " (".$usr[user_name].")</option>\n";
    $exists=1;
  }

  if (!$exists)
    {
      # Show none if the list is empty
      print '<option>'._("None Found").'</option>';
    }

  print "</select>
	<input type=\"HIDDEN\" name=\"group_id\" VALUE=\"$group_id\">
	<P>
	<input type=\"submit\" name=\"Submit\" value=\""._("Approve User(s) for Group")."\">
	</form>";
}


function show_all_users_remove_list ($result, $group_id)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_all_users_remove_list ($result, $group_id) ';  global $PHP_SELF;
  print "
        <h3>"._("Removing User(s) from Group")."</h3>
	<p>
        "._("To remove an user, or several, select his/their name(s) and click on the button below. Project's administrators cannot be removed unless they quit.")."
	<form action=\"$PHP_SELF\" method=\"post\">
	<input type=\"HIDDEN\" name=\"action\" VALUE=\"remove_from_group\">
  <select name=\"user_id[]\" size=\"10\" multiple>\n";

  while ($usr = db_fetch_array($result)) {
    if (!member_check($usr[user_id], $group_id, "A"))
      {
	print "<option value=".$usr[user_id].">".$usr[realname].
	  " (".$usr[user_name].")</option>\n";
	$exists=1;
      }
  }

  if (!$exists) {
    # Show none if the list is empty
    print '<option>'._("None Found").'</option>';
  }

  print "</select>
	<br />
	<input type=\"HIDDEN\" name=\"group_id\" VALUE=\"$group_id\">
	<p>
	<input type=\"submit\" name=\"Submit\" value=\""._("Remove User(s) from Group")."\">
	</form>";

}

function show_all_users_add_searchbox ($group_id, $previous_search)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_all_users_add_searchbox ($group_id, $previous_search) ';  global $PHP_SELF;
  print '
        <h3><a name="searchuser"></a>'._("Adding User(s) to Group").'</h3>
	<p>
        '._("You can search one or several users to add in the whole users database with the following search tool. A list of users, depending on the name(s) you'll type in this form, will be generated.").'

	<form action="'.$PHP_SELF.'#searchuser" method="post">
	<input type="hidden" name="action" value="add_to_group_list">
        <input type="text" size="35" name="words" value="'.$previous_search.'"><br />
	<p>
	<input type="hidden" name="group_id" value="'.$group_id.'">
	<input type="submit" name="Submit" value="'._("Search User(s)").'">
	</form>';
}



function show_all_users_add_list ($result, $group_id)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_all_users_add_list ($result, $group_id) ';  global $PHP_SELF;
  print _("Below is the result of your search in the users database.")."

	<P></P>
	<form action=\"$PHP_SELF\" method=\"post\">
	<input type=\"HIDDEN\" name=\"action\" VALUE=\"add_to_group\">
  <select name=\"user_id[]\" size=\"10\" multiple>\n";

  while ($usr = db_fetch_array($result)) {
      print "<option value=".$usr[user_id].">".$usr[realname].
	" (".$usr[user_name].")</option>\n";
      $exists=1;
  }

  if (!$exists) {
    # Show none if the list is empty
    print '<option>'._("None Found").'</option>';
  }

  print "</select>
	<br />
	<input type=\"HIDDEN\" name=\"group_id\" VALUE=\"$group_id\">
	<p>
	<input type=\"submit\" name=\"Submit\" value=\""._("Add User(s) to Group")."\">
	</form>";
}



function show_bulk_add_users ($group_id)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_bulk_add_users ($group_id) ';  print "<h3>"._("Have your file checked")."</h3>

  "._("By submitting your file here, the format of the file and each user name, etc. will be checked.
  No modifications will be made to the Savannah user database.
  Feedback will be given on screen and by email.")."
  <br />

	<form action=\"bulk_admin_users.php?action=test&group_id=".$group_id."\" method=\"post\"  enctype=\"multipart/form-data\">
	<input type=\"HIDDEN\" name=\"action\" VALUE=\"check\">
  <input type=\"file\" name=\"file\" size=\"40\">
	<P>
	<input type=\"submit\" name=\"Submit\" value=\"Submit\">
	</P>
  </form>
  <br />

  </td></tr><tr><td class=\"boxitemalt\">

  <h3>"._("Have your file executed")."</h3>

  "._("By submitting your file here, modifications will be made to the Savannah user database.
  Feedback will be given on screen and by email.")."
  <br />

	<form action=\"bulk_admin_users.php?action=execute&group_id=".$group_id."\" method=\"post\"  enctype=\"multipart/form-data\">
	<input type=\"HIDDEN\" name=\"action\" VALUE=\"check\">
  <input type=\"file\" name=\"file\" size=\"40\">
	<P>
	<input type=\"submit\" name=\"Submit\" value=\"Submit\">
	</P>
  </form>";
}

# Administrative functions

/*
	Add a user to this group
*/
if ($action=='add_to_group' && $user_id) {
  $sys_approved_user_permissions = $GLOBALS['sys_approved_user_permissions'];
  foreach ($user_id as $user) {
    member_add($user, $group_id);
    sprintf(' '._("User %s added to the project."), user_getname($user));
  }
}

/*
	Remove a user from this group
*/
if ($action=='remove_from_group' && $user_id) {
  foreach ($user_id as $user) {
    # Check if the users about to be removed are not admins
    if (!member_check($user, $group_id, "A")) {
      member_remove($user, $group_id);
      sprintf(' '._("User %s deleted from the project."), user_getname($user));;
    }
  }
}

/*
	Approve a user for this group
*/
if ($action=='approve_for_group' && $user_id) {
  foreach ($user_id as $user) {
    member_approve($user, $group_id);
    if($email=user_get_email($user)){
      $message = sprintf(_("You've been approved as a member of the group %s on %s,\nwhere you are registered as %s."), group_getname($group_id), $GLOBALS['sys_name'], user_getname($user)) . "\n\n".
	 sprintf(_("-- the %s team."),$GLOBALS['sys_name'])."\n";

      sendmail_mail($GLOBALS['sys_replyto'] . "@".$GLOBALS['sys_lists_domain'],
		    $email,
		    ' '._("Project membership approved"),
		    $message);
    }
  }
}


# Start the page
site_project_header(array('title'=>_("Manage Members"),'group'=>$group_id,'toptab'=>'ahome'));


/*
	Show lists of users
*/


if (!$group_id) {

  exit_error('No group id given', $group_id);

} else {
  /*
		Show list for one group
  */

  $HTML->box1_top(_("Member Administration for ").group_getname($group_id));

  /*
        	Show a form so a user can be approved for this group
  */

  $result =  db_query("SELECT user.user_id AS user_id, "
		      . "user.user_name AS user_name, "
		      . "user.realname AS realname "
		      . "FROM user,user_group "
		      . "WHERE user.user_id=user_group.user_id AND user_group.group_id='$group_id' AND admin_flags='P'"
		      . "ORDER BY user.user_name");


  show_pending_users_list($result, $group_id);

  print '<br /></td></tr><tr><td class="boxitemalt">';

  /*
        	Show a form so a user can be removed from this group
  */
  $result =  db_query("SELECT user.user_id AS user_id, "
		      . "user.user_name AS user_name, "
		      . "user.realname AS realname "
		      . "FROM user,user_group "
		      . "WHERE user.user_id=user_group.user_id AND user_group.group_id=$group_id AND admin_flags<>'A'"
		      . "ORDER BY user.user_name");

  show_all_users_remove_list($result, $group_id);


  print '<br /></td></tr><tr><td class="boxitem">';

  /*
        	Show a form so a user can be added to this group
  */

  # Query to find users
  $array = explode(" ",$words);
  $words1=implode($array,"%' OR user_name LIKE '%");
  $words2=implode($array,"%' OR realname LIKE '%");
  $result = db_query("SELECT user_id, user_name, realname "
		     . "FROM user "
		     . "WHERE ((user_name LIKE '%$words1%') OR (realname LIKE '%$words2%')) AND (status='A') ORDER BY user_name LIMIT 0,26");

  show_all_users_add_searchbox($group_id, $words);

  if ($words) {
    show_all_users_add_list($result, $group_id);
  }

  $HTML->box1_bottom();

  print '<p></p>';

  /*
        	Show a form to upload a bulk-add script
  * /
           FIXME: deactivated until we provide user documentation.
                 it could broke the database information
   $HTML->box1_top(_("Upload File to Bulk-manage Users"));

  show_bulk_add_users ($group_id);

  $HTML->box1_bottom();
  */
}

project_admin_footer(array());

?>
