<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.23 2004/11/04 10:01:42 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2001 (c) Free Software Foundation
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "../include/pre.php";

# pre.php defeines group to group_id, so do check, else look at request
$group_id = $group_id ? $group_id : $_REQUST['group_id'];

# Get everything else from REQUEST
$category_id = $_REQUEST['category_id'];

if ($group_id) 
{
  
  site_project_header(array('title'=>_('Project Help Wanted'),'group'=>$group_id,'toptab'=>'people'));
  
  # we get site-specific content
  utils_get_content("people/index_group");
  
  print people_show_project_jobs($group_id);
  
} 
else if ($category_id) 
{

# Do check first
$cat_name = people_get_category_name($category_id);

if ($cat_name == 'Invalid ID')
	{ 
		print site_header(array('title' =>_('Project Help Wanted'), 'toptab'=>_('people')));
		fb(_("Invalid category: that category does not exist"),1);
	} else {
		print site_header(array('title'=>_('Projects looking for  '.$cat_name), 'toptab'=>_('people')));
	
  # we get site-specific content
  utils_get_content("people/index_cat");
  
  print people_show_category_jobs($category_id);
}

} 
else
{

  print site_header(array('title'=>_('Projects Needing Help'), 'toptab'=>_('people')));
  
  # we get site-specific content
  utils_get_content("people/index");
  
  print people_show_category_table();
  
}

site_project_footer(array());

?>
