<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: groups.php,v 1.11 2004/11/22 08:25:50 yeupou Exp $
#
#  Copyright 2003-2004 (c) Frederik Orellana <frederik.orellana@cern.ch>
#                          Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../include/pre.php";
require_directory("search");

# ###### get global user and group vars

$res_user = db_query("SELECT * FROM user WHERE user_id=" . user_getid());
$row_user = db_fetch_array($res_user);
$sys_pending_user_permissions = $GLOBALS['sys_pending_user_permissions'];
$register_error=0;


# ###### function send_pending_user_email($group_id, $user_id, $user_message)
# ###### sends an email to group admins when a user joins group

function send_pending_user_email($group_id, $user_id, $user_message)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':send_pending_user_email($group_id, $user_id, $user_message) ';

  $res_grp = db_query("SELECT * FROM groups WHERE group_id='$group_id'");

  if (db_numrows($res_grp) < 1)
    {
      return 0;
    }

  $row_grp = db_fetch_array($res_grp);

  $res_admins = db_query("SELECT user.user_name,user.email FROM user,user_group WHERE "
			 . "user.user_id=user_group.user_id AND user_group.group_id='$group_id' AND "
			 . "user_group.admin_flags='A'");

  if (db_numrows($res_admins) < 1)
    {
      return 0;
    }

  # send one email per admin, in one command line coma separated
  $admin_list = '';
  while ($row_admins = db_fetch_array($res_admins))
    {
      $admin_list .= ($admin_list ? ',':'').$row_admins['email'];
    }

  $message = approval_user_gen_email($row_grp['group_name'],
				     $row_grp['unix_group_name'],
				     $group_id,
				     user_getname($user_id),
				     user_getrealname($user_id),
				     user_getemail($user_id),
				     $user_message);

  sendmail_mail($GLOBALS['sys_email_adress'],
		$admin_list,
		sprintf(_("Membership request for group %s"), $row_grp['group_name']),
		$message,
		$row_grp['unix_group_name'],
		"usermanagement");
}


# ###### function update_tbl()
# ###### updates tables if a post

function update_tbl()
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':update_tbl()	';
  $ret_val = 1;

  global $register_error;
  global $row_user;
  global $sys_pending_user_permissions;
  global $form_id;

  utils_get_content("my/request_for_inclusion");

  $result = db_query("SELECT group_id FROM groups WHERE status='A' AND
            is_public='1' ORDER BY group_id");

  if ($GLOBALS["update"])
    {
      
      # Check for duplicates
      if (!form_check($form_id))
	{ return 0; }
	    
      while ($val = db_fetch_array($result))
	{
	  if($GLOBALS["form_groups_$val[group_id]"])
	    {
               # If not in group, add user with admin_flag "P"
               # (not very sensible, but this way we avoid changing
	       # the table layout)
	      if(!member_check_pending($row_user[user_id], $val[group_id]))
		{
		  if(!$GLOBALS["form_message"])
		    {
		      fb(_("Error: When joining you must provide a message for the administrator, a short explanation of why you want to join this/these project(s)."), 1);
		      $ret_val = 0;
		    }
		  else
		    {
		      if(member_add($row_user[user_id], $val[group_id], 'P'))
		      {
			send_pending_user_email($val[group_id], $row_user[user_id], $GLOBALS["form_message"]);
			form_clean($form_id);
		      }
		    }
		}
	      else
		{
		  fb(_("Request for inclusion already registered"),1);
		}
	    }
	}
      return $ret_val;
    }
  return 0;
}

# ###### first check if post, update requests

update_tbl();


# page header
site_user_header(array('toptab'=>'mygroups'));

# we get site-specific content
utils_get_content("account/change_groups_intro");
print "<br /><br />\n\n";

$result = db_query("SELECT groups.group_name,"
		   . "groups.group_id,"
		   . "groups.unix_group_name,"
		   . "groups.status,"
		   . "user_group.admin_flags "
		   . "FROM groups,user_group "
		   . "WHERE groups.group_id=user_group.group_id "
		   . "AND user_group.user_id='". user_getid() ."' "
		   . "AND groups.status='A'");
$rows=db_numrows($result);


################ RIGHT PART ###########################

print html_splitpage(1);

print $HTML->box_top(_("Request for Inclusion"),'',1);

print '<div class="boxitem">'._("Search a Group")."\n";
  print '<p class="text">';
print _("If there is a project - or several - I would like to be member of, to be able to fully contribute, it is possible to search his/their name(s) in the whole group database with the following search tool. A list of groups will be generated, depending on the word(s) typed in this form.")."\n";
print '</p>';

print '
	<form action="'.$PHP_SELF.'#searchgroup" method="post">
	<input type="hidden" name="action" value="searchgroup" />
        <input type="text" size="35" name="words" value="'.$words.'" /><br />
	<br /><br />
	<input type="submit" name="Submit" value="'
	._("Search Group(s)").'" />
	</form>

</div><!-- end boxitem -->';


if ($words)
{
  # Avoid to big search by asking for more than 3 characters.
  if (strlen($words) > 3)
    {
      $result_search = search_run($words, "soft", 0);
    }
  else
    { $result_search = 0; }

  print '<div class="boxitemalt"><a name="searchgroup"></a>'._("Requesting Inclusion");
  print '<p class="text">';
  print _("Below is the result of the research in the groups database.");
  print '</p>';

  if (db_numrows($result_search) < 1)
    {
      print '<br /><font class="warn">'._("None found. Please note that only search words of more than three characters are valid.").'</font><br />';
    }
  else
    {
      # We do not put pointer to group page along with checkbox,
      # to avoid creating any confusion (for instance, should I check the
      # box or click on the link?).
      # This tool is to search groups for inclusion, not to look around
      # to get information about groups.
      print '<p class="text">';
      print _("To request inclusion in one or several groups, check the correspondants boxes, write a meaningful message for the project administrator, that will approve or disapprove the request, and submit the form.");

      print '</p>'.form_header($PHP_SELF);

      while ($val = db_fetch_array($result_search))
	{
	  if (!user_is_group_member($row_user[user_id], $val[group_id]))
	    {
	      print '<input type="checkbox" name="form_groups_'.$val[group_id].'" /> ';
	      print $val[group_name];
	      print '<br />';
	    }
	}

      print '<br />'._("Comments (required):").'<br />
     <textarea name="form_message" cols="40" rows="7"></textarea><br /><br />
     <input type="submit" name="update" value="';
      print _("Request Inclusion").'" /></form>';
    }
  print '</div><!-- end boxitemalt -->';
}



print $HTML->box_bottom(1);

print "<br />\n";

/*
     Projects the user requested to be member of
*/

print $HTML->box_top(_("Request for Inclusion Waiting For Approval"),'',1);

unset($content);
for ($i=0; $i<$rows; $i++)
{
  if (db_result($result,$i,'admin_flags') == 'P')
    {
      
      $content .= '<li class="'.utils_get_alt_row_color($j).'">';
      $content .= '<span class="trash"><a href="../my/rmproject.php?group_id='. db_result($result,$i,'group_id').'">'.
	   '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="'._("Discard this request?").'" /></a></span>'; 

      $content .= '<a href="'.$GLOBALS['sys_home'].'projects/'. db_result($result,$i,'unix_group_name') .'/">'.db_result($result,$i,'group_name').'</a><br />&nbsp;</li>';
      $exists=1;

    }
}

if (!$exists)
{
  print _("None Found");
}
else
{
  print '<ul class="boxli">'.$content.'</ul>';
}
unset($exists);

print $HTML->box_bottom(1);

print html_splitpage(2);

################ LEFT PART ###########################


if (!$result || $rows < 1)
{

  print $HTML->box_top(_("My Groups"),'',1);
  print _("You're not a member of any public projects");
  print $HTML->box_bottom(1);

}
else
{

  /*
     Projects administrated by the user
  */

  print $HTML->box_top(_("Groups I'm Administrator of"),'',1);

  $j = 1;
  unset($content);
  for ($i=0; $i<$rows; $i++)
    {
      if (db_result($result,$i,'admin_flags') == 'A')
	{
	  $content .= '<li class="'.utils_get_alt_row_color($j).'">';
	  $content .= '<span class="trash"><a href="../my/rmproject.php?group_id='. db_result($result,$i,'group_id').
	    '">'.
	   '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="'._("Quit this project?").'" /></a><br /></span>'; 

	  $content .= '<a href="'.$GLOBALS['sys_home'].'projects/'. db_result($result,$i,'unix_group_name') .'/">'.db_result($result,$i,'group_name').'</a><br />&nbsp;</li>';
	  $exists=1;
	  $j++;
	}
    }
  if (!$exists)
    {
      print _("I am not administrator of any projects");
    }
  else
    {
      print '<ul class="boxli">'.$content.'</ul>';
    }
  unset($exists);
  
  print $HTML->box_bottom(1);

  print "<br />\n";

  /*
     Projects the user is member of
  */

  print $HTML->box_top(_("Groups I'm Contributor of"),'',1);

  $j = 1;
  unset($content);
  for ($i=0; $i<$rows; $i++)
    {
      if (db_result($result,$i,'admin_flags') == '')
	{

	  $content .= '<li class="'.utils_get_alt_row_color($j).'">';
	  $content .= '<span class="trash"><a href="../my/rmproject.php?group_id='. db_result($result,$i,'group_id').
	    '">'.
	   '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="'._("Quit this project?").'" /></a></span>'; 

	  $content .= '<a href="'.$GLOBALS['sys_home'].'projects/'. db_result($result,$i,'unix_group_name') .'/">'.db_result($result,$i,'group_name').'</a><br />&nbsp;</li>';
	  $exists=1;
	  $j++;
	}
    }

  if (!$exists)
    {
      print _("I am not contributor member of any projects");
    }
  else
    {
      print '<ul class="boxli">'.$content.'</ul>';
    }
  unset($exists);
  
  print $HTML->box_bottom(1);
 

}

print html_splitpage(3);



$HTML->footer(array());

?>