<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: field_usage.php,v 1.22 2004/11/23 16:43:23 yeupou Exp $
#
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


$is_admin_page='y';

if ($group_id && user_ismember($group_id,'A')) {

  # Initialize global bug structures
  trackers_init($group_id);

  if ($post_changes)
    {
      # A form was posted to update a field

      if ($submit)
	{
	  if (isset($n1) && isset($n2))
	    {
	      $display_size = "$n1/$n2";
	    }

	  # these are checkboxes so make sure they have value 0 if needed.
	  # 0 and 'not in the form' doesn't mean the same thing. if it is not set
	  # but is in the form it means value 0, if it is not set and not in the form
	  # it means use the system default.
	  if (!isset($keep_history) && $keep_history_here)
	    {
	      $keep_history = 0;
	    }
	  if (!isset($empty_ok) && $empty_ok_here)
	    {
	      $empty_ok = 0;
	    }

	  # the additional possibility of differently treating non project
	  # members who have a savannah account and users without a
	  # savannah account demanded a new handling of the values of
	  # the show_on_add field:
	  # bit 1 set: show for logged in non project members
	  # bit 2 set: show for non logged in users
	  $show_on_add = $show_on_add | $show_on_add_nologin;

	  trackers_data_update_usage($field,$group_id,$label,$description,
				$status,$place,$display_size,$empty_ok,$keep_history,
				$show_on_add_members,$show_on_add, $form_transition_default_auth);
	}
      else if ($reset)
	{
	  trackers_data_reset_usage($field,$group_id);
	}
      # force a re-initialization of the global structure after
      # the update and before we redisplay the field list
      trackers_init($group_id);
    }


  if ($update_field)
    {

      # Show the form to change a field setting

      trackers_header_admin(array ('title'=>_("Modify Field Usage")));

      # Escape to display the form

      print '<form action="'.$PHP_SELF.'" method="post">';
      print '<input type="hidden" name="post_changes" value="y" />
      <input type="hidden" name="field" value="'.$field.'" />
      <input type="hidden" name="group_id" value="'.$group_id.'" />
      <h2>'
	._("Field Label:").' ';

      $closetag = ' &nbsp;&nbsp; <font class="smaller">['.utils_link($GLOBALS['sys_home'].ARTIFACT.'/admin/field_values.php?group='.$group_name.'&amp;list_value=1&amp;field='.$field, _("Jump to this field values"))."]</font></h2>\n";

      # If it is a custom field let the user change the label and description
      if (trackers_data_is_custom($field))
	{
	  print '<input type="text" name="label" value="'.trackers_data_get_label($field).
	    '" size="20" maxlength="85">'.$closetag;
	  print '<span class="preinput">'._("Description:").' </span>';
	  print '<input type="text" name="description" value="'.trackers_data_get_description($field).
	    '" size="70" maxlength="255" />';
	}
      else
	{
	  print trackers_data_get_label($field).$closetag;
	}

      print '<span class="preinput">'._("Status:").' </span>&nbsp;&nbsp;';
      # Display the Usage box (Used, Unused select box  or hardcoded "required')
      if (trackers_data_is_required($field))
	{
	  print _("Required");
	  print '<input type="hidden" name="status" value="1" />';
	}
      else
	{
	  print '<select name="status">
	   <option value="1"'.(trackers_data_is_used($field)?' selected="selected"':'').'>'._("Used").'</option>
	   <option value="0"'.(trackers_data_is_used($field)?'':' selected="selected"').'>'._("Unused").'</option>
      </select>';
	}

      # Customize field size only for text fields and text areas.
      if (trackers_data_is_text_field($field))
	{
	  list($size,$maxlength) = trackers_data_get_display_size($field);
	  print "\n\n<p>&nbsp;</p><h3>"._("Field Size:").' ('._("in characters").')</h3><ul>';
	  print '<li><span class="preinput">'._("Visible Field Size:").' </span>';
	  print '<input type="text" name="n1" value="'.$size.
	    '" size="3" maxlength="3" />&nbsp;&nbsp;';
	  print '<li><span class="preinput">'._("Maximum length:").' </span>';
	  print '<input type="text" name="n2" value="'.$maxlength.
	    '" size="3" maxlength="3" />&nbsp;&nbsp; ('._("up to  255").'</ul>';
	}
      else if (trackers_data_is_text_area($field))
	{
	  list($rows,$cols) = trackers_data_get_display_size($field);
	  print "\n\n<p>&nbsp;</p><h3>"._("Field Size:").'</h3><ul>';
	  print '<li><span class="preinput">'._("Number of columns:").' </span>';
	  print '<input type="text" name="n1" value="'.$rows.
	    '" size="3" maxlength="3" />&nbsp;&nbsp;';
	  print '<li><span class="preinput">'._("Number of rows:").' </span>';
	  print '<input type="text" name="n2" value="'.$cols.
	    '" size="3" maxlength="3" /></ul>';
	}
      # Remark: Date fields have a fixed size that cannot be changed


      # Customize Properties
      if (!trackers_data_is_special($field))
	{
	  print "\n\n<p>&nbsp;</p><h3>"
	    ._("Properties:").'</h3><ul>';
	  print '<li><input type="checkbox" name="empty_ok" value="1" '.
	    (trackers_data_is_empty_ok($field)?' checked="checked"':'').' /><input type="hidden" name="empty_ok_here" value="1" />'.
	    ' <span class="preinput">' ._("Allow Empty Value").' </span></li>';
	  print '<li><input type="checkbox" name="keep_history" value="1" '.
	    (trackers_data_do_keep_history($field)?' checked="checked"':'').' /><input type="hidden" name="keep_history_here" value="1" />'.
	    '  <span class="preinput">'._("Keep Change History").'</span></li>';
	  print '</ul>';
	}

      # Customize screen presence
      if (!trackers_data_is_required($field) &&
	  !trackers_data_is_special($field_name))
	{

	  $addm_html = '<input type="checkbox" name="show_on_add_members" value="1"'.
	     (trackers_data_is_showed_on_add_members($field)?' checked="checked"':'').' />';

	  $add_html = '<input type="checkbox" name="show_on_add" value="1"'.
	     (trackers_data_is_showed_on_add($field)?' checked="checked"':'').' />';
	  $add_nologin_html = '<input type="checkbox" name="show_on_add_nologin" value="2"'.
	     (trackers_data_is_showed_on_add_nologin($field)?' checked="checked"':'').' />';

	}
      else
	{

	  # Do not let the user change these field settings but put them in the
	  # form to preserve the existing setting or use the default values
	  # imposed at the system level
	  $addm_html = '<input type="hidden" name="show_on_add_members" '.
	     'value="'.(trackers_data_is_showed_on_add_members($field)? 1:0).'" />'.
	     (trackers_data_is_showed_on_add_members($field)? ': '._("Always"):': '._("Never"));
	  $add_html = '<input type="hidden" name="show_on_add" '.
	     'value="'.(trackers_data_is_showed_on_add($field)? 1:0).'" />'.
	     (trackers_data_is_showed_on_add($field)? ': '._("Always").'':': '._("Never").'');
	  
	  $add_nologin_html = '<input type="hidden" name="show_on_add_nologin" '.
	    'value="'.(trackers_data_is_showed_on_add_nologin($field)? 2:0).'" />'.
	    (trackers_data_is_showed_on_add_nologin($field)? ': '._("Always").'':': '._("Never").'');


	}

      print "\n\n<p>&nbsp;</p><h3>"._("Display:").'</h3>';
      print '<span class="preinput">'._("Rank on screen:").' </span>&nbsp;&nbsp;';

      print '<input type="text" name="place" value="'.trackers_data_get_place($field).
	'" size="6" maxlength="6" />'."\n";
      print '<ul>';
      print '<li>'.$addm_html.' <span class="preinput">'._("On the submission form used by project members").'</span></li>';
      print '<li>'.$add_html.' <span class="preinput">'._("On the submission form used by other logged in users").'</span></li>';
      print '<li>'.$add_nologin_html.' <span class="preinput">'._("On the submission form used by non logged in users").'</span></li></ul>';
      
      $transition_default_auth = db_result(db_query("SELECT transition_default_auth FROM ".ARTIFACT."_field_usage WHERE group_id='$group_id' AND bug_field_id='".trackers_data_get_field_id($field)."'"), 0, 'transition_default_auth');

      print "\n\n<p>&nbsp;</p><h3>"._("By default, transitions (from one value to another) are:").'</h3><ul>';
      print '<li><input type="radio" name="form_transition_default_auth" value="A" '.(($transition_default_auth!='F')?' checked="checked"':'').' /> '._("Allowed").'</li><li><input type="radio" name="form_transition_default_auth" value="F" '.(($transition_default_auth=='F')?'checked="checked"':'').' /> '._("Forbidden").'</li></ul>';

      print '
      	<p align="center">
      	<input type="submit" name="submit" value="'._("Update").'" />
      	&nbsp;&nbsp;
      	<input type="submit" name="reset" value="'
	._("Reset to defaults").'" /></p>
      	</form>';



      trackers_footer(array());

    }
  else
    {

      /*
	  Show main page
      */

      trackers_header_admin(array ('title'=>_("Field Usage")));


      # Show all the fields currently available in the system
      $i=0;
      $title_arr=array();
      $title_arr[]=_("Field Label");
      $title_arr[]=_("Type");
      $title_arr[]=_("Description");
      $title_arr[]=_("Rank on screen");
      $title_arr[]=_("Scope");
      $title_arr[]=_("Status");

      $hdr = html_build_list_table_top ($title_arr);

      # Build HTML ouput for  Used fields first and Unused field second
      $iu=$in=$inc=0;
      while ( $field_name = trackers_list_all_fields() )
	{

	  # Do not show some special fields any way in the list
	  # because there is nothing to customize in them
	  if (($field_name == 'group_id') ||
	      ($field_name == 'comment_type_id') ||
	      ($field_name == 'bug_id') ||
	      ($field_name == 'date') ||
	      ($field_name == 'close_date') ||
	      ($field_name == 'submitted_by') )
	    { continue; }

	  # Show Used, Unused and Required fields on separate lists
	  # SHow Unused Custom field in a separate list at the very end
	  $is_required = trackers_data_is_required($field_name);
	  $is_custom = trackers_data_is_custom($field_name);

	  $is_used = trackers_data_is_used($field_name);
	  $status_label = ($is_required?_("Required"):($is_used?_("Used"):_("Unused")));

	  $scope_label  = (trackers_data_get_scope($field_name)=='S'?
			   _("System"):_("Project"));
	  $place_label = ($is_used?trackers_data_get_place($field_name):'-');

	  $html = '<td><a href="'.$PHP_SELF.'?group_id='.$group_id.
	     '&update_field=1&field='.$field_name.'">'.
	     trackers_data_get_label($field_name).'</a></td>'.
	     "\n<td>".trackers_data_get_display_type_in_clear($field_name).'</td>'.
	     "\n<td>".trackers_data_get_description($field_name).
	     (($is_custom && $is_used) ? ' - <b>['._("Custom Field").']</b>':'').'</td>'.
	     "\n<td align =\"center\">".$place_label.'</td>'.
	     "\n<td align =\"center\">".$scope_label.'</td>'.
	     "\n<td align =\"center\">".$status_label.'</td>';

	  if ($is_used)
	    {
	      $html = '<tr class="'.
		 utils_get_alt_row_color($iu) .'">'.$html.'</tr>';
	      $iu++;
	      $hu .= $html;
	    }
	  else
	    {
	      if ($is_custom)
		{
		  $html = '<tr class="'.
		     utils_get_alt_row_color($inc) .'">'.$html.'</tr>';
		  $inc++;
		  $hnc .= $html;
		}
	      else
		{
		  $html = '<tr class="'.
		     utils_get_alt_row_color($in) .'">'.$html.'</tr>';
		  $in++;
		  $hn .= $html;
		}
	    }

	} /* end while all fields */

      # Now print the HTML table
      if ($iu == 0)
	{
	  $html = '<p>'._("No extension field in use.").' '._("Choose one below.").'</p>'.$html;
	}
      else
	{
	  $hu= '<tr><td colspan="5"><center><b>---- '._("USED FIELDS").' ----</b></center></tr>'.$hu;
	  if ($in)
	    {
	      $hn = '<tr><td colspan="5"> &nbsp;</td></tr>'.
		 '<tr><td colspan="5"><center><b>---- '._("UNUSED STANDARD FIELDS").' ----</b></center></tr>'.$hn;
	    }

	  if ($inc)
	    {
	      $hnc = '<tr><td colspan="5"> &nbsp;</td></tr>'.
		 '<tr><td colspan="5"><center><b>---- '._("UNUSED CUSTOM FIELDS").' ----</b></center></tr>'.$hnc;
	    }
	}
      print $hdr.$hu.$hn.$hnc.'</table>';


      trackers_footer(array());
    }


} else {

  #browse for group first message

  if (!$group_id)
    {
      exit_no_group();
    }
  else
    {
      exit_permission_denied();
    }

}

?>