<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: graphs.php,v 1.5 2004/11/26 15:50:33 yeupou Exp $
#
#  Copyright 2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Attempt to replace HTML_graphs.php with someone more spartian, efficient
# and w3c compliant.

# It can accept db result directy or an array.
# Total must be an array too, if provided
function graphs_build ($result, $field=0, $dbdirect=1,$total=0) 
{
  if (!$result) 
    { 
      fb(_("No data to work on, no graph will be built"), 1);
      break;
    }
  
  if ($dbdirect) 
    {
      $content = array();
      for ($i=0; $i < db_numrows($result) ; $i++)
	{
	  $content[db_result($result, $i, 0)] = db_result($result, $i, 1);
	}
    }
  else
    {
      $content = $result;
    }

  # Get the total number of items
  # Total should not be passed as argument, normally
  if (!$total) 
    {
      $totalvar = 0;
      while(list($k, $v)=each($content))
	{
	  $totalvar += $v;
	}

      $total = array();
      reset($content);
      while(list($k, $v)=each($content))
	{
	  $total[$k] = $totalvar;
	}
    }
  else
    {
      # If total was passed as argument, no crosscheck, assume it is accurate
      $totalvar = 1;
    }
     
  # Print the stats, unless $total is nul
  # If total was passed as argument, strange result may be printed.
  if ($totalvar) 
    {
      print "\n\n<table width=\"100%\">\n";
      reset($content);
      while(list($k, $v)=each($content))
	{
	  $percent = sprintf("%d", (($v / $total[$k]) * 100));

	  if ($field && $field == "assigned_to")
	    { $title = utils_user_link($k); }
	  else 
	    { $title = $k; }
	  

	  if ($percent > 25)
	    { unset($class); }
	  else
	    { $class="closed"; }

	  print '<tr width="100%">'.
	    '<td width="15%" align="right" valign="center">'.$title.'</td>'.
	    '<td width="5%" align="right" valign="center">'.sprintf(_("%s/%s"), $v, $total[$k]).'</td>'.
	    '<td width="5%" align="center" valign="center">'.sprintf(_("%s%%"), $percent).'</td>'.
	    '<td width="75%" class="prioraclosed" align="left"><table class="priori'.$class.'" width="'.$percent.'%" cellpadding="0" cellspacing="0"><tr><td>&nbsp;</td></tr></table></td>'.
	    '</tr>';
	}
      print "\n</table>\n\n";
    }
  else 
    {
      print '<p class="warn">Total of results is nul.</p>';
    }
}

?>
