<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: features_boxes.php,v 1.47 2004/11/26 15:50:33 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#                          Mathieu Roy <yeupou--at--gnu.org>
#
#  Copyright 2004      (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function show_features_boxes() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_features_boxes() ';
  GLOBAL $HTML;

  $return .= $HTML->box_top(utils_link($GLOBALS['sys_home']."stats/", sprintf(_("%s Statistics"),$GLOBALS['sys_name']),"sortbutton"));

  $return .= show_sitestats();
  $return .= $HTML->box_bottom();

  $result = db_query("SELECT type_id,name FROM group_type ORDER BY type_id");
 

  # try to find out how many latest registered groups per group type
  # we should print, depending on how many groups we have.
  $limit = 10;
  $count = db_numrows($result);
  # If count of group types > 25, print 2 latest groups per type
  # If count of group types < 2, print 25 latest groups per type
  # Else, print (50/count of groups) latest groups per type
  if ($count > 25)
    { $limit = 2; }
  elseif ($count < 2)
    { $limit = 25; }
  else
    {
      $limit = round(50 / $count);
    }

  while ($eachtype = db_fetch_array($result)) 
    {
      $return .= "<br />\n";
      $return .= $HTML->box_top(sprintf(_("Newest %s Projects"),$eachtype['name']),'',1);
      $return .= show_newest_projects($group_type=$eachtype['type_id'], $limit);
      global $j;
      $return .= '<div class="'.utils_get_alt_row_color($j).'"><font class="smaller"><a href="'.$GLOBALS['sys_home'].'search/?type_of_search=soft&amp;words=%%%&amp;type='.$eachtype['type_id'].'">[';
      $return .= sprintf( _("all %s projects"),$eachtype['name'] ) ;
      $return .= ']</a></font></div>';
      $return .= $HTML->box_bottom(1);
    }
  return $return;
}


function show_sitestats() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_sitestats() ';
  $return .= '<font class="smaller">';
  $return .= _("Registered Users").': <b>'.stats_getusers().'</b>';
  $return .= '</font></div>';
  $return .= '<div class="'.utils_get_alt_row_color(0).'"><font class="smaller">';
  $return .= _("Hosted Projects").': <b>'.stats_getprojects_active().'</b></font></div>';
  $result = db_query("SELECT type_id,name FROM group_type ORDER BY type_id");
  while ($eachtype = db_fetch_array($result)) 
    {
      $i++;
      $return .= '<div class="'.utils_get_alt_row_color($i).'"><font class="smaller">';	  
      $return .= '&nbsp;&nbsp;- <a href="'.$GLOBALS['sys_home'].'search/?type_of_search=soft&amp;words=%%%&amp;type='.$eachtype['type_id'].'" class="center">';
      $return .= stats_getprojects_bytype_active($eachtype['type_id']);
      $return .= ' '.$eachtype['name'].'</a>';
      $return .= '</font></div>';
    }
  $return .= '<div class="'.utils_get_alt_row_color(($i+1)).'"><font class="smaller">&nbsp;&nbsp;+ '.stats_getprojects_pending().' '._("Registrations Pending").'</font>';

  return $return;
}

function show_newest_projects($group_type, $limit) 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_newest_projects($group_type) ';
  global $j;

  $sql =	"SELECT group_id,unix_group_name,group_name,register_time FROM groups " .
     "WHERE is_public=1 AND status='A' AND type=$group_type " .
     "ORDER BY register_time DESC LIMIT $limit";
  $res_newproj = db_query( $sql );
  $sql_type = "SELECT type_id,base_host FROM group_type WHERE type_id=$group_type";
  $res_newproj_type = db_query($sql_type);
  $row_newproj_type = db_fetch_array($res_newproj_type);
  if ($row_newproj_type['base_host']) 
    {
      $base_url = 'http'.(session_issecure()?'s':'').'://'.$row_newproj_type['base_host'];
    } 

  if (!$res_newproj || db_numrows($res_newproj) < 1) 
    {
      return db_error();
    } 
  else
    {
      while ( $row_newproj = db_fetch_array($res_newproj) ) 
	{
	  if ( $row_newproj['register_time'] ) 
	    {
	      # It would be best to have only Month + Day, but php locale
	      # implementations cant do that, apparently. Feel free to 
	      # improve.
	      $return .= '<div class="'.utils_get_alt_row_color($j).'"><font class="smaller">&nbsp;&nbsp;- <a href="'.$base_url.$GLOBALS['sys_home']."projects/$row_newproj[unix_group_name]/\">"
		 . $row_newproj[group_name].'</a><font class="smaller">, '.strftime('%x',$row_newproj['register_time']).'</font></font></div>';
	      $j++;
	    }
	}
    }
  return $return;
}


?>
