<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.24 2004/09/22 08:11:50 yeupou Exp $
#
# Copyright 2002-2003 (c) Mathieu Roy <yeupou@gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../include/pre.php";

$FAQ_DIR = $GLOBALS['sys_incdir'].'/faq';
$files_dir = $FAQ_DIR; 
$group_id = $GLOBALS['sys_group_id'];


project_get_object($group_id);


############## display faq function

function print_faq($faqdir, $gr_id, $question)
{
   $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':print_faq($faqdir, $gr_id, $question)';

   if (strstr($question, '..')) return ''; # zerodeux: basic security fix, still incomplete

   $question_title = ereg_replace(".txt", "", $question);	
   $question_title = ereg_replace("_", " ", $question_title);

   $question_text = utils_read_file($faqdir.$subdir."/".$question);
   $question_text = ereg_replace("\\\\\"", "\"", $question_text);
   $question_text = ereg_replace("\\\\'", "'", $question_text);
   $question_text = ereg_replace("@", "at###at", $question_text);
   $question_text = ereg_replace("\\\$sys_https_url", $GLOBALS['sys_https_url'], $question_text);
   $question_text = ereg_replace("\\\$group_id", $gr_id, $question_text);
   $question_text = ereg_replace("\\\$sys_email_adress", $sys_email_adress, $question_text);
   $question_text = utils_make_links($question_text);
   $question_text = ereg_replace("at###at", "@", $question_text);

   if($question_text && $question_text != "")
     {
       print "<h3>".$question_title." ?</h3>";
       echo $question_text;
       
       print "<p>&nbsp;</p><h3>"._("Other questions:")."</h3>";
     }
   return $question_text;
}

############## generic faq function

function print_faq_list($faqdir, $proj, $gr_id, $sdir, $question, $header)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':print_faq_list($faqdir, $proj, $gr_id, $sdir, $question, $header)';
  unset($questions_array);
  $frontpage=1;
  $faqs="";
  
  if(file_exists("$faqdir$sdir/files.txt"))
    {
      $files = file("$faqdir$sdir/files.txt");
      foreach ($files as $file)
	{
	  $file = ereg_replace("\n", "", $file);
	  if ($file != "." && $file != ".." && $file != "index.php" && $file != "CVS" && !preg_match("/^\#.*/", $file)) 
	    {
	      # print ($file . "!=" . $question. "<br />");
	      if ($file != $question) 
		{
		  $questions_array[] = "$file";
		}
	      else 
		{
		  $frontpage = 0;
		}
	    }
	}
      $questions_max = count($questions_array);
      for ($x = 0; $x <$questions_max; $x++)
	{     
	  $question = ereg_replace(".txt", "", $questions_array[$x]);	
	  $question = ereg_replace("_", " ", $question);
	  $faqs = $faqs . "<li><a href=\"".$GLOBALS['sys_home']."faq/?admin=".$GLOBALS['admin']."&group_id=".$gr_id."&amp;question=".$questions_array[$x]."\">".$question."?</a><br />\n";
	}
    }
  elseif(file_exists($faqdir.$sdir))
    {
      $dir = opendir($faqdir.$sdir);
      while ($file = readdir($dir))
	{
	  if ($file != "." && 
	      $file != ".." && 
	      $file != "index.php" && 
	      $file != "CVS" &&
	      $file != "admin" && 
	      $file != "files.txt") 
	    {
	      #$questions_array[] = "$file";
	      if($file != $question)
		{
		  $questions_array[] = "$file";
		}
	     else 
	       {
		 $frontpage = 0;
	       }
	    }
	}
      $questions_max = count($questions_array);
      #if($questions_max > 0){sort($questions_array);};
      for ($x = 0; $x <$questions_max; $x++)
	{     
	  $question = ereg_replace(".txt", "", $questions_array[$x]);	
	  $question = ereg_replace("_", " ", $question);
	  $faqs =  $faqs . "<li><a href=\"".$GLOBALS['sys_home']."faq/?group_id=".$gr_id."&amp;question=".$questions_array[$x]."\">".$question."?</a><br />\n";
	}
      closedir($dir);
    }
  
  
  print "<ul>";
  print $faqs;
  print "</ul>";
  
  
}





############## content


site_project_header(array('group'=>$group_id,'toptab'=>'faq'));

if (isset($question)) 
{
  $res = print_faq($FAQ_DIR.$subdir, $group_id, $question);
  if(!$res)
    { print_faq($files_dir.$subdir, $group_id, $question); }
}

# general faq(s)


print_faq_list($FAQ_DIR, $project, $group_id, $subdir, $question, 1);
#if(file_exists($files_dir)){
#print_faq_list($files_dir, $project, $group_id, $subdir, $question, 0);
#}



print '
<p>&nbsp;</p><h3>'._("The FAQ is also available in the following formats:").'</h3>
<ul>
<li><a href="export_html.php?group_id='.$group_id.'">HTML</a>
<li><a href="export_texinfo.php?group_id='.$group_id.'">Texinfo</a>
</ul>';



# other stuff

/* temporarily removed these hardcoded links
if($GLOBALS['allhelp'] == 1){
  if($GLOBALS['admin'] == 1){
  print "<h1>Other documentation</h1>
  <ul>
  <li><a href=\"../docs/admin.php\">Savannah administrator's guide</a>
  <li><a href=\"../cvs/?group_id=$group_id\">Local CVS information</a>
  <li><a href=\"../files/admin/?group=$group_name\">Local File List information</a>.
  </ul>";
  }
  else
  {
  print "<h1>Other documentation</h1>
  <ul>
  <li><a href=\"https://pcitapi34.cern.ch/savannah/cvs/?group_id=$group_id\">Local CVS information</a>.
  <li><a href=\"https://pcitapi34.cern.ch/savannah/files/admin/?group=$group_name\">Local File List information</a>.</ul>";
  }
}
*/

site_project_footer(array());


?>
