<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: login.php,v 1.54 2004/09/23 15:45:52 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Header( "Expires: Wed, 11 Nov 1998 11:11:11 GMT");
Header( "Cache-Control: no-cache");
Header( "Cache-Control: must-revalidate");

require '../include/pre.php';
require '../include/account.php';

if ($GLOBALS['sys_https_host'] != "" && !session_issecure())
{
  #force use of SSL for login
  header('Location: '.$GLOBALS['sys_https_url'].$GLOBALS['sys_home'].'account/login.php?uri='.$uri);
}

###### first check for valid login, if so, redirect

if ($login)
{
  # If we come from brother, it means that passwd is encrypted
  $crypted_pw = $from_brother;
  $success=session_login_valid($form_loginname,$form_pw,0,$cookie_for_a_year,$crypted_pw, $stay_in_ssl);
  if ($success)
    {
      # Optionally stay in SSL mode
      if ($GLOBALS['sys_https_host'] != "" && $stay_in_ssl)
	{ $http = "https"; }
      else
	{ $http = "http"; }

      # If a brother server exists, login there too, if we are not
      # already coming from there
      if ($GLOBALS['sys_brother_domain'] && $brotherhood)
	{
	  if (!$from_brother)
	    {
	      # Go there saying hello to your brother
	      # First, crypt the password.
	      # (Normally, users shouldn't use this feature
	      # unless they ever login at brother site).
	      $form_pw=crypt(md5($form_pw));
	      header ("Location: ".$http."://".$GLOBALS['sys_brother_domain'].$GLOBALS['sys_home']."/account/login.php?form_loginname=$form_loginname&form_pw=$form_pw&cookie_for_a_year=$cookie_for_a_year&from_brother=1&login=1&stay_in_ssl=$stay_in_ssl&brotherhood=1&uri=$uri");
	      exit;
	    }
	  else
	    {
	      # We return to our brother 'my', where we login originally,
              # unless we are request to go to an uri
              if (!$uri) 
                {            
	         header ("Location: ".$http."://".$GLOBALS['sys_brother_domain'].$GLOBALS['sys_home']."my/");
                }
              else
                {
	         header ("Location: ".$http."://".$GLOBALS['sys_brother_domain'].$uri);
                }
	      exit;
	    }
	}
      else
	{
	  # If No brother server exists, just go to 'my' page 
          # unless we are request to go to an uri
          if (!$uri) 
           {  
	      header ("Location: ".$http."://".$GLOBALS['sys_default_domain'].$GLOBALS['sys_home']."my/");
           }
          else
           {
	      header ("Location: ".$http."://".$GLOBALS['sys_default_domain'].$uri);
           }
	  exit;
	}

    }
}

if ($session_hash)
{
   # Nuke their old session securely. 
   session_cookie('session_hash','');
   db_query("DELETE FROM session WHERE session_hash='$session_hash' AND user='$user_id'");
}

site_header(array('title'=>_("Login")));

if ($login && !$success)
{

  if ("Account Pending" == $feedback)
    {

      echo '<h3>'._("Pending Account").'</h3>';
      echo '<p>'._("Your account is currently pending your email confirmation. Visiting the link sent to you in this email will activate your account.").'</p>';
      echo '<p>'._("If you need this email resent, please click below and a confirmation email will be sent to the email address you provided in registration.").'</p>';
      echo '<p><a href="pending-resend.php?form_user='.$form_loginname.'">['._("Resend Confirmation Email").']</a></p>';

    }
  else
    {
      # print helpful error message
      print '<div class="splitright"><div class="boxitem">';
      print '<div class="warn">'._("Troubleshooting:").'</div></div><ul class="boxli">'.
	'<li class="boxitemalt">'._("Is the \"Caps Lock\" or \"A\" light on your keyboard on?").'<br />'._("If so, hit \"Caps Lock\" key before trying again.").'</li>'.
	'<li class="boxitem">'._("Did you forget or misspell your password?").'<br />'.utils_link('lostpw.php', _("You can recover your password using the lost password form.")).'</li>'.
	'<li class="boxitemalt">'._("Still having trouble?").'<br />'.utils_link($GLOBALS['sys_home'].'support/?group='.$GLOBALS['sys_unix_group_name'],  _("Fill a support request.")).'</li>';
      print '</ul></div>';
    }

}

if (session_issecure())
{
  echo '<p class="warn">'._("Cookies must be enabled past this point.").'</p>';
  echo '<p>'._("You will be connected with an SSL server and your password will not be visible to other users.").'</p>';
}

echo '<form action="'.$GLOBALS['sys_https_url'].$GLOBALS['sys_home'].'account/login.php" method="post">';
echo '<input type="hidden" name="uri" value="'.$uri.'" />';

echo '<p><font class="preinput">'._("Login Name:").'</font><br />&nbsp;&nbsp;';
echo '<input type="text" name="form_loginname" value="'.$form_loginname.'" /></p>';

echo '<p><font class="preinput">'._("Password:").'</font><br />&nbsp;&nbsp;';
echo '<input type="password" name="form_pw" /></p>';

if (session_issecure())
{
  print '<p><input type="checkbox" name="stay_in_ssl" value="1" checked="checked" /><font class="preinput">';
  print _("Stay in SSL mode after login")."</font><br />\n";
  print '<font class="text">'._("Lynx, Emacs w3 and Microsoft Internet Explorer users will have intermittent SSL problems, so they should leave SSL after login. Gecko-based browser (Mozilla, Galeon, Netscape...) and Konqueror users should stay in SSL mode permanently for maximum security.").'</font></p>';
}
else
{
  print '<p class="warn"><input type="hidden" name="stay_in_ssl" value="0" />';
  print _("This server does not use SSL, so the password you sent may be viewed by other people. Do not use any important passwords.").'</p>';
}

print '<p><input type="checkbox" name="cookie_for_a_year" value="1" /><font class="preinput">'._("Remember me").'</font><br />';
print '<font class="text">'._("For a year, your login information will be stored in a cookie. Use this only if you are using your own computer.").'</font>';

if ($GLOBALS['sys_brother_domain'])
{
  print '<p><input type="checkbox" name="brotherhood" value="1" /><font class="preinput">';
  printf (_("Login also in %s").'</font><br />', $GLOBALS['sys_brother_domain']);
  print '<font class="text">';
  printf (_("Do not use this if you are using kerberos. Do not use this until you already successfully logged in on %s, the result would be unpredictable."), $GLOBALS['sys_brother_domain']);
  print '</font>';
}

print '<p class="center"><input type="submit" name="login" value="'._("Login").'" /></p>';
print '</form>';

print '<p><a href="lostpw.php">['._("Lost your password?").']</a></p>';
print '<p><a href="register.php">['._("New Account").']</a></p>';


$HTML->footer(array());

?>
