<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.50 2004/11/22 09:12:49 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../include/pre.php";    


#######################
####################### UPDATE DATABASE

session_require(array('isloggedin'=>1));

if ($update) 
{
  if($user_theme == "Default") 
    { $user_theme = ""; }
  
  if ($theme_rotate_jump == "1") 
    {
      theme_rotate_jump($theme_rotate_numeric);
    } 
  else 
    {
      setcookie("SV_THEME", $user_theme, time() + 60*60*24*365, $GLOBALS['sys_home']);
    }
  
  $success = db_query("UPDATE user SET "
		      . "email_hide=" . ($form_email_hide?"1":"0") . ","
		      . "theme='" . addslashes($user_theme) . "' WHERE "
		      . "user_id=" . user_getid());



  ####### Subject line
  # First test content: to avoid people entering white space and being in
  # trouble at a later point, first check if we can find something else than
  # white space
  if ($form_reverse_comments_order == "1")
    { user_set_preference("reverse_comments_order", 1); }
  else
    { user_unset_preference("reverse_comments_order"); }


  if ($success) 
    {
      fb(_("Succesful update, theme/color changes will be effective the next time a page is loaded"));
    }
  else
    {
      fb(_("Failed to update the database"),1);
    }
}


#######################
####################### PRINT FORM + LINKS


site_user_header(array('toptab'=>'account'));

# get global user vars
$res_user = db_query("SELECT * FROM user WHERE user_id=" . user_getid());
$row_user = db_fetch_array($res_user);

# we get site-specific content
utils_get_content("account/index_intro");


print "<br /><br />\n\n".html_splitpage(1);

############## Passwd / SSH

print $HTML->box_top('Authentication');
print '<a href="change.php?item=password">'._("Change Password").'</a>';
print '<p class="text">'._("This password gives access to the web interface.").'<br />';
utils_get_content("account/index_passwd");
print '</p>';

unset($i);
print $HTML->box_nextitem(utils_get_alt_row_color($i));
print '<a href="sessions.php">';
printf(gettext("Manage the %d opened session(s)"),session_count(user_getid())); 
print '</a><p class="text">&nbsp;</p>';

# get shared key count from db                                         
$expl_keys = explode("###",$row_user['authorized_keys']);

# If the last 'key' is empty, then it is because of a trailing separator;
# so do not count it
$keynum = (sizeof($expl_keys));
if ($expl_keys[$keynum-1] == "")
  $keynum--;

$i++;
print $HTML->box_nextitem(utils_get_alt_row_color($i));
print '<a href="editsshkeys.php">';
if ($keynum > 0) 
{ printf(gettext("Edit the %d SSH Public Key(s) Registered"),($keynum)); }
else
{ print gettext("Register an SSH Public Key"); }

print '</a><p class="text">';
utils_get_content("account/index_ssh");
print '</p>';


print $HTML->box_bottom();
print "<br />\n";

################### Prefs

print '<form action="'.$PHP_SELF.'" method="post">';
print $HTML->box_top(_('Preferences'));

print _("Theme / Color scheme");

html_select_theme_box("user_theme", $row_user['theme']);


if ("rotate"==$row_user['theme'])
{
  print '<br /><input type="checkbox" name="theme_rotate_jump" value="1" /> '._("Jump to the next theme").'';
  print '<input type="hidden" name="theme_rotate_numeric" value="'. $HTTP_COOKIE_VARS["SV_THEME_ROTATE_NUMERIC"] .'" />';
}
print '<p class="text">'._("Note: themes use CSS massively and can not be used without aesthetic troubles (worse in some cases) with browsers that do not offer good CSS support (such as Netscape 4.x or MSIE).").' <font class="warn">'._("You are strongly advised to use a browser like Mozilla or Konqueror if you encounter such troubles.").'</font></p>';

if (!theme_guidelines_check(SV_THEME))
{
  print '<p class="text"><font class="warn">'._("The theme you are currently using does not follow the latest Savane CSS guidelines. As result, page layout may be more or less severely broken. It is not advised to use this theme.").' ';
  # If the non-valid theme is the default one, tell users they should fill 
  # a support request
  if (SV_THEME == $GLOBALS['sys_themedefault']) 
    {
      print utils_link($GLOBALS['sys_home'].'support/?group='.$GLOBALS['sys_unix_group_name'], 
		       sprintf(_("%s administrators should be asked to take care of Savane CSS Guidelines, since it is the default theme"), $GLOBALS['sys_name']), "warn");
    }
  print '</font></p>';
}

unset($i);
print $HTML->box_nextitem(utils_get_alt_row_color($i));

print '<a href="change_notifications.php">'._("Edit Personal Notification Settings").'</a>';
print '<p class="text">'._("Here is defined when the trackers should send email notifications. It permits also to configure the subject line prefix of sent mails.").'</p>';

$i++;
print $HTML->box_nextitem(utils_get_alt_row_color($i));

print '<input type="checkbox" name="form_email_hide" value="1" '.($row_user['email_hide'] ? 'checked="checked"':'').' /> '._("Hide email address from your account information");

print '<p class="text">'._("So the only way to get in touch with you would be using the form available to logged-in users. It is generally a bad idea to choose this option, especially if I am a project administrator.").'</p>';

$i++;
print $HTML->box_nextitem(utils_get_alt_row_color($i));

print '<input type="checkbox" name="form_reverse_comments_order" value="1" '.(user_get_preference("reverse_comments_order") ? 'checked="checked"':'').' /> '._("Print items comments from the oldest to latest");

print '<p class="text">'._("By default, comments are listed in reverse chronological order: it means that, for a given item, comments are printed from the latest to the oldest. If this behavior does not suit you, select this option.").'</p>';

print '<p class="center"><input type="submit" name="update" value="'._("Update").'" /></p>';
print $HTML->box_bottom();

print '</form>';

################### Infos
print html_splitpage(2);


print $HTML->box_top('Information');


print _("Account #").''.$row_user['user_id'];
print '<p class="text">'._("Your login is").' <b>'.$row_user['user_name'].'</b>.<br />'._("You are member since").' <b>'.format_date($sys_datefmt,$row_user['add_date']).'</b>.</p>';

unset($i);
print $HTML->box_nextitem(utils_get_alt_row_color($i));
print '<a href="change.php?item=realname">'._("Change Real Name").'</a>';
print '<p class="text">'._("Set to").' <b>'.$row_user['realname'].'</b>.</p>';

$i++;
print $HTML->box_nextitem(utils_get_alt_row_color($i));
print '<a href="change.php?item=email">'._("Change Email Address").'</a>';
print '<p class="text">'._("Set to").' <b>'.$row_user['email'].'</b>.</p>';

$i++;
print $HTML->box_nextitem(utils_get_alt_row_color($i));
print '<a href="change.php?item=timezone">'._("Change Timezone").'</a>';
print '<p class="text">'._("Set to").' <b>'.$row_user['timezone'].'</b>.</p>';

$i++;
print $HTML->box_nextitem(utils_get_alt_row_color($i));
print '<a href="change.php?item=gpgkey">'._("Edit GPG Key").'</a>';
print '<p class="text">'._("GPG Keys can be used to crypt message or to certify originator identity. Adding here my (ASCII) public key allows other user to crypt message for me so I'll be the only one able to read these.").'</p>';

$i++;
print $HTML->box_nextitem(utils_get_alt_row_color($i));
print '<a href="resume.php">'._("Edit Resume and Skills").'</a>';
print '<p class="text">'._("Details about your experience and skills may be of interest to others users or visitors.").'</p>';

$i++;
print $HTML->box_nextitem(utils_get_alt_row_color($i));
print '<a href="'.$GLOBALS['sys_home'].'users/'.$row_user['user_name'].'">'._("View your Public Profile").'</a>';
print '<p class="text">'._("Your profile can be viewed by everybody.").'</p>';

print $HTML->box_bottom();
print html_splitpage(3);

$HTML->footer(array());
?>
