#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_export_data.pl,v 1.3 2004/01/31 00:56:17 yeupou Exp $
#
#
# Copyright (c) 2004 Mathieu Roy <yeupou@gnu.org>
# http://yeupou.coleumes.org
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#   USA
#
#

use strict;
use Savannah;
use Getopt::Long;

my ($getopt, $help, $project);

eval {
    $getopt = GetOptions("project=s" => \$project,
			 "help" => \$help);
};



die "No project name given. Exiting" unless $project;

sub Escape {
    my $data = $_[0];
    $data =~ s/\'/\\\'/g;
    return $data;
}



# this is site specific:
my $sourcecode = "/savannah/cvsroot/".$project."/cvsroot/".$project;
my $homepage = "/savannah/cvsroot/".$project."/webcvs/".$project;
my $download = "/backups/current/upload/".$project;
my $tarball = "/tmp/svdata_".$project;




# remove old build dir, if existing
unlink($tarball) if -e $tarball;

# prepare build dir
`mkdir -p $tarball`;

# make an SQL file:
#   - we will not do over-complicated SQL commands, the group_id string will
#   be replaced by the string  ----GROUPID----
#                              ----ADMINID---- : uid of the project admin
#                                                on the new system.
#   - the script import_data that will have no trouble to get the group_id on
#   the new host will replace ----GROUPID---- by the appropriate number before
#   running the SQL file
open(SQL, "> $tarball/sql");

my $project_id = GetGroupSettings($project, "group_id");


# groups table
foreach my $line (GetDBAlt("groups", 
			     "unix_group_name='$project'",
			     "group_name,short_description,long_description,devel_status,license,bugs_preamble,task_preamble,patch_preamble,support_preamble")) {
    my ($group_name,$short_description,$long_description,$devel_status,$license,$bugs_preamble,$task_preamble,$patch_preamble,$support_preamble) = split("------SPLIT------", $line);;
    
    print SQL "UPDATE groups SET group_name='".Escape($group_name)."',short_description='".Escape($short_description)."',long_description='".Escape($long_description)."',devel_status='".Escape($devel_status)."',license='".Escape($license)."',bugs_preamble='".Escape($bugs_preamble)."',task_preamble='".Escape($task_preamble)."',patch_preamble='".Escape($patch_preamble)."',support_preamble='".Escape($support_preamble)."' WHERE unix_group_name='$project';\n";
    
}

# mailing list table
foreach my $line (GetDBAlt("mail_group_list", 
			"group_id='$project_id'",
			"list_name,is_public,password,list_admin,description")) {
    my ($list_name,$is_public,$password,$list_admin,$description) = split("------SPLIT------", $line);;

    # we must avoid duplicates
    print SQL "DELETE FROM mail_group_list WHERE list_name='".Escape($list_name)."';\n";
    print SQL "INSERT INTO mail_group_list (group_id,list_name,is_public,password,list_admin,description) VALUES ('----GROUPID----','".Escape($list_name)."','".Escape($is_public)."','".Escape($password)."',----ADMINID----,'".Escape($description)."');\n";
}

# groups_default_permissions 
foreach my $line (GetDBAlt("groups_default_permissions", 
			"group_id='$project_id'",
			"admin_flags,forum_flags,bugs_flags,task_flags,patch_flags,support_flags,news_flags")) {
    my ($admin_flags,$forum_flags,$bugs_flags,$task_flags,$patch_flags,$support_flags,$news_flags) = split("------SPLIT------", $line);;

    print SQL "INSERT INTO groups_default_permissions (group_id,admin_flags,forum_flags,bugs_flags,task_flags,patch_flags,support_flags,news_flags) VALUES ('----GROUPID----','".Escape($admin_flags)."','".Escape($forum_flags)."','".Escape($bugs_flags)."','".Escape($task_flags)."','".Escape($patch_flags)."','".Escape($support_flags)."','".Escape($news_flags)."');\n";
}

# trackers
foreach my $tracker ("support", "patch", "bugs", "task") {
    foreach my $line (GetDBAlt($tracker, 
			    "group_id='$project_id'",
			    "status_id , severity , category_id, date , summary , details , close_date , bug_group_id , resolution_id , category_version_id , platform_version_id , reproducibility_id , size_id , fix_release_id , plan_release_id , hours , component_version , fix_release , plan_release , priority , planned_starting_date , planned_close_date , percent_complete , keywords , release_id , release , originator_name , originator_email , originator_phone , custom_tf1 , custom_tf2 , custom_tf3 , custom_tf4 , custom_tf5 , custom_tf6 , custom_tf7 , custom_tf8 , custom_tf9 , custom_tf10 , custom_ta1 , custom_ta2 , custom_ta3 , custom_ta4 , custom_ta5 , custom_ta6 , custom_ta7 , custom_ta8 , custom_ta9 , custom_ta10 , custom_sb1 , custom_sb2 , custom_sb3 , custom_sb4 , custom_sb5 , custom_sb6 , custom_sb7 , custom_sb8 , custom_sb9 , custom_sb10 , custom_df1 , custom_df2 , custom_df3 , custom_df4 , custom_df5")) {
	chomp($line);
	my ( $status_id , $severity , $category_id, $date , $summary , $details , $close_date , $bug_group_id , $resolution_id , $category_version_id , $platform_version_id , $reproducibility_id , $size_id , $fix_release_id , $plan_release_id , $hours , $component_version , $fix_release , $plan_release , $priority , $planned_starting_date , $planned_close_date , $percent_complete , $keywords , $release_id , $release , $originator_name , $originator_email , $originator_phone , $custom_tf1 , $custom_tf2 , $custom_tf3 , $custom_tf4 , $custom_tf5 , $custom_tf6 , $custom_tf7 , $custom_tf8 , $custom_tf9 , $custom_tf10 , $custom_ta1 , $custom_ta2 , $custom_ta3 , $custom_ta4 , $custom_ta5 , $custom_ta6 , $custom_ta7 , $custom_ta8 , $custom_ta9 , $custom_ta10 , $custom_sb1 , $custom_sb2 , $custom_sb3 , $custom_sb4 , $custom_sb5 , $custom_sb6 , $custom_sb7 , $custom_sb8 , $custom_sb9 , $custom_sb10 , $custom_df1 , $custom_df2 , $custom_df3 , $custom_df4 , $custom_df5) = split("------SPLIT------", $line);;
	
	print SQL "INSERT INTO ".$tracker." (group_id,status_id,severity,category_id,date,summary,details,close_date,bug_group_id,resolution_id,category_version_id,platform_version_id,reproducibility_id,size_id,fix_release_id,plan_release_id,hours,component_version,fix_release,plan_release,priority,planned_starting_date,planned_close_date,percent_complete,keywords,release_id,release,originator_name,originator_email,originator_phone,custom_tf1,custom_tf2,custom_tf3,custom_tf4,custom_tf5,custom_tf6,custom_tf7,custom_tf8,custom_tf9,custom_tf10,custom_ta1,custom_ta2,custom_ta3,custom_ta4,custom_ta5,custom_ta6,custom_ta7,custom_ta8,custom_ta9,custom_ta10,custom_sb1,custom_sb2,custom_sb3,custom_sb4,custom_sb5,custom_sb6,custom_sb7,custom_sb8,custom_sb9,custom_sb10,custom_df1,custom_df2,custom_df3,custom_df4,custom_df5) VALUES ('----GROUPID----' , '".Escape($status_id)."' , '".Escape($severity)."' , '".Escape($category_id)."', '".Escape($date)."' , '".Escape($summary)."' , '".Escape($details)."' , '".Escape($close_date)."' , '".Escape($bug_group_id)."' , '".Escape($resolution_id)."' , '".Escape($category_version_id)."' , '".Escape($platform_version_id)."' , '".Escape($reproducibility_id)."' , '".Escape($size_id)."' , '".Escape($fix_release_id)."' , '".Escape($plan_release_id)."' , '".Escape($hours)."' , '".Escape($component_version)."' , '".Escape($fix_release)."' , '".Escape($plan_release)."' , '".Escape($priority)."' , '".Escape($planned_starting_date)."' , '".Escape($planned_close_date)."' , '".Escape($percent_complete)."' , '".Escape($keywords)."' , '".Escape($release_id)."' , '".Escape($release)."' , '".Escape($originator_name)."' , '".Escape($originator_email)."' , '".Escape($originator_phone)."' , '".Escape($custom_tf1)."' , '".Escape($custom_tf2)."' , '".Escape($custom_tf3)."' , '".Escape($custom_tf4)."' , '".Escape($custom_tf5)."' , '".Escape($custom_tf6)."' , '".Escape($custom_tf7)."' , '".Escape($custom_tf8)."' , '".Escape($custom_tf9)."' , '".Escape($custom_tf10)."' , '".Escape($custom_ta1)."' , '".Escape($custom_ta2)."' , '".Escape($custom_ta3)."' , '".Escape($custom_ta4)."' , '".Escape($custom_ta5)."' , '".Escape($custom_ta6)."' , '".Escape($custom_ta7)."' , '".Escape($custom_ta8)."' , '".Escape($custom_ta9)."' , '".Escape($custom_ta10)."' , '".Escape($custom_sb1)."' , '".Escape($custom_sb2)."' , '".Escape($custom_sb3)."' , '".Escape($custom_sb4)."' , '".Escape($custom_sb5)."' , '".Escape($custom_sb6)."' , '".Escape($custom_sb7)."' , '".Escape($custom_sb8)."' , '".Escape($custom_sb9)."' , '".Escape($custom_sb10)."' , '".Escape($custom_df1)."' , '".Escape($custom_df2)."' , '".Escape($custom_df3)."' , '".Escape($custom_df4)."' , '".Escape($custom_df5)."');\n";
    }

    foreach my $line (GetDBAlt($tracker."_canned_responses", 
			    "group_id='$project_id'",
			    "title,body")) {
	my ($title,$body) = split("------SPLIT------", $line);;
	
	print SQL "INSERT INTO ".$tracker."_canned_responses (group_id,title,body) VALUES ('----GROUPID----','".Escape($title)."','".Escape($body)."');\n";
 
    }
    
    
#FIXME: grabbing reports is more complex, we skip it for now   
#    foreach my $line (GetDBAlt($tracker."_report", 
#			    "group_id='".Escape($project_id' AND scope='P'",
#			    "name,description")) {
#	chomp($line);
#	my ($name,$description) = split("------SPLIT------", $line);;
#	
#	print SQL "INSERT INTO ".$tracker."_report (group_id,scope,name,description) VALUES ('----GROUPID----)."','P)."', '".Escape($name)."','".Escape($description')\n";
#     }
    

    foreach my $line (GetDBAlt($tracker."_field_usage", 
			    "group_id='$project_id'",
			    "bug_field_id,use_it,show_on_add,show_on_add_members,place,custom_label,custom_description,custom_display_size,custom_empty_ok,custom_keep_history")) {

	my ($bug_field_id,$use_it,$show_on_add,$show_on_add_members,$place,$custom_label,$custom_description,$custom_display_size,$custom_empty_ok,$custom_keep_history) = split("------SPLIT------", $line);;
	
	# we need to keep the bug field id, otherwise the work on _field_value
	# would not be feasible as easily
	print SQL "INSERT INTO ".$tracker."_field_usage (group_id,bug_field_id,use_it,show_on_add,show_on_add_members,place,custom_empty_ok,custom_keep_history) VALUES ('----GROUPID----','".Escape($bug_field_id)."','".Escape($use_it)."','".Escape($show_on_add)."','".Escape($show_on_add_members)."','".Escape($place)."','".Escape($custom_empty_ok)."','".Escape($custom_keep_history)."');\n";

    }

    foreach my $line (GetDBAlt($tracker."_field_value", 
			    "group_id='$project_id'",
			    "bug_field_id,value_id,value,description,order_id,status,email_ad,send_all_flag")) {

	my ($bug_field_id,$value_id,$value,$description,$order_id,$status,$email_ad,$send_all_flag) = split("------SPLIT------", $line);;
	
	# value_id = 100 = None, a default field, not to be imported
	if ($value_id != "100") {
	    
	    # it works only because we kept the bug_field_id as it where.
	    print SQL "INSERT INTO ".$tracker."_field_value (group_id,bug_field_id,value_id,value,description,order_id,status,email_ad,send_all_flag) VALUES ('----GROUPID----','".Escape($bug_field_id)."','".Escape($value_id)."','".Escape($value)."','".Escape($description)."','".Escape($order_id)."','".Escape($status)."','".Escape($email_ad)."','".Escape($send_all_flag)."');\n";
	    
	}
    }
    

}
close(SQL);


# copy cvs (and remove CVSROOT)
`cp -a $sourcecode $tarball/sourcecode`;
`rm -rf $tarball/sourcecode/CVSROOT`;
`cp -a $homepage $tarball/homepage`;
`rm -rf $tarball/homepage/CVSROOT`;
`cp -a $download $tarball/download`;

# compress
`tar cfz $tarball.tar.gz svdata_$project --directory $tarball`;


`rm -rf $tarball`;
