<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: submit.php,v 1.23 2004/09/22 08:11:51 yeupou Exp $
# 
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#                          Mathieu Roy <yeupou--at--gnu.org>
#
#  Copyright 2004      (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "../include/pre.php";

if ($_POST['group_id'])
   { $group_id= $_POST['group_id'];  }
elseif ($_GET['group_id'])
   { $group_id = $_GET['group_id'];  }

if ($_POST['post_changes'])
   { $post_changes = $_POST['post_changes']; }
if ($_POST['summary'])
   { $summary = $_POST['summary']; }
if ($_POST['details'])
   { $details = $_POST['details']; }
if ($_POST['feedback'])
   { $feedback = $_POST['feedback'];  }
elseif ($_GET['feedback'])
   { $feedback = $_GET['feedback']; }
if ($_POST['group'])
   {   $group = $_POST['group']; }
elseif ($_GET['group'])
   { $group = $_GET['group'];  }      
if ($_POST['id'])
   { $id = $_POST['id'];  }
elseif ($_GET['id'])
   { $id = $_GET['id']; }     

if (!group_restrictions_check($group_id, "news"))
    {
      exit_error(sprintf(_("Action Unavailable: %s"), group_getrestrictions_explained($group_id, ARTIFACT)));
    }
 
if (user_isloggedin()) 
{

  if ($post_changes) 
    {
      
      # Insert the new item, with 5 as status: project admin
      # must moderate it.
      # There must be a title.

      if (!$summary) 
	{ $feedback = _("Title is missing:"); }
      else 
	{
	  $new_id=forum_create_forum($group_id,$summary,1,0);
	  $sql="INSERT INTO news_bytes (group_id,submitted_by,is_approved,date,forum_id,summary,details) ".
	     " VALUES ('$group_id','".user_getid()."','5','".time()."','$new_id','".htmlspecialchars($summary)."','".htmlspecialchars($details)."')";
	  $result=db_query($sql);
	}

      if (!$result) 
	{  " "._("Error doing insert"); } 
      else 
	{
	  # $details needs to be keept only if there was an error
	  unset($details);
	  $feedback = _("News Posted: it will need to be approved by a news manager of this project before it shows on the project front page.");
	  session_redirect($GLOBALS['sys_home'].'news/?group='.$group_name.'&feedback='.urlencode($feedback));
	}
    } 
  
  # News must be submitted from a project page
 
  
  if (!$group_id) 
    {
      exit_no_group();
    }

  # Show the submit form
  site_project_header(array('title'=>_("Submit News"),
			    'group'=>$group_id,
			    'toptab'=>'news'));
  
  if($feedback) 
    {
      print '<h3 class="warn">'.$feedback.'</h3>';
    }
  
  print '
		<p>You can post news about this project if you are logged in.
                An administrator of this project will have to review it and approve it.
                It means that you should contact one of them.</p><p>
                Posts that are of special interest to the community that should be shown on the '.$GLOBALS['sys_name'].' front page have to be, also, approved by the '.$GLOBALS['sys_name'].' administrators.
                </p><p>
		You may include URLs, emails, that will be made clickable, but not HTML.
		</p>
		<form action="'.$PHP_SELF.'" method="post">
		<input type="hidden" name="group_id" value="'.$group_id.'" />
		<input type="hidden" name="post_changes" value="y" />
               	<font class="preinput">Subject:</font><br/>&nbsp;&nbsp;
		<input type="text" name="summary" value="" size="65" maxlenght="80" />
		<br />
		<font class="preinput">Details:</font><br />&nbsp;&nbsp;
		<textarea name="details" rows="20" cols="65" wrap="soft">'.$details.'</textarea><br />
                <p class="center">
		<input type="submit" name="submit" value="'._("Submit").'" />
                </p>
		</form>';

  site_project_footer(array());
  
} 
else 
{
  
  exit_not_logged_in();
  
}
?>
