<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: theme.php,v 1.9 2004/09/22 08:11:51 yeupou Exp $
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# theme value is fetched by getting the cookie. But we keep in the
# database the setting, so someone using another computer can easily
# remember the theme he previously chose.

# Jump to the next theme available and set cookie appropriately
function theme_rotate_jump($num) 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':theme_rotate_jump($theme_selection_dir, $num) ';  

  utils_get_content("forbidden_theme");
  $theme = theme_list(1);
 
  $num++;
	
  # if the num is a value superior of the number of themes
  # we reset to 0
  if ($num == count($theme)) 
    { $num = "0"; }
  
  # keep in mind the new number
  setcookie("SV_THEME_ROTATE_NUMERIC", $num, time() + 60*60*24*365, $GLOBALS['sys_home']);

  # associate this number with a theme
  setcookie("SV_THEME_ROTATE", $theme[$num], time() + 60*60*24, $GLOBALS['sys_home']);
}

# Return an array with all the themes, but not the special case "rotate" 
# and "random"
# By default, it does not skip forbidden themes (strict=0), in order to
# avoid doing too many unrequired tests.
function theme_list ($strict=0) 
{
  if ($strict)
    { utils_get_content("forbidden_theme"); }

  # Feed the array
  $theme = array();
  $dir = opendir($GLOBALS['sys_urlroot']."/css/");
  while ($file = readdir($dir)) 
    {
      # take only correct css files
      if (preg_match("/^(.*)\.css$/", $file, $matches)) 
	{
	  # base.css is always ignored
	  if ($matches[1] != "base") {
	    if (!$strict)
	      {
		$theme[] = $matches[1];
	      }
	    elseif (!preg_match($GLOBALS['forbid_theme_regexp'], $matches[1]))
	      {
		$theme[] = $matches[1];
	      }
	  }
	}
    }
  closedir($dir);

  # No result? Return only the default theme. 
  # (If there were no result, there is a problem anyway somewhere in the
  # installation)
  if (!count($theme))
    {
      $theme[] = $GLOBALS['sys_themedefault'];
    }
  return $theme;
}


if (isset($HTTP_COOKIE_VARS["SV_THEME"])) 
{
  # the user selected a theme
  if ($HTTP_COOKIE_VARS["SV_THEME"]=="random") 
    {
      # the user selected random theme
      # we set randomly a theme and a cookie for a day
      if (isset($HTTP_COOKIE_VARS["SV_THEME_RANDOM"])) 
	{	  
	  define ('SV_THEME', $HTTP_COOKIE_VARS["SV_THEME_RANDOM"]);
	} 
      else 
	{
	  $theme = theme_list(1);
	  mt_srand ((double)microtime()*1000000);
	  $num = mt_rand(0,count($theme)-1);
	  $random_theme = $theme[$num];
	  setcookie("SV_THEME_RANDOM", $random_theme, time() + 60*60*24, $GLOBALS['sys_home'],$GLOBALS['sys_default_domain']);
	  define('SV_THEME', $random_theme);
	}
    } 
  elseif ($HTTP_COOKIE_VARS["SV_THEME"]=="rotate") 
    { 
      # the user want a rotation between themes
      if (isset($HTTP_COOKIE_VARS["SV_THEME_ROTATE"])) 
	{	    
	  define('SV_THEME', $HTTP_COOKIE_VARS["SV_THEME_ROTATE"]);
	} 
      else 
	{
	  $theme = theme_list(1);
	  
	  # we get a number and set a cookie with this number
	  # if this number exist, +1 to his value
	  if (!isset($HTTP_COOKIE_VARS["SV_THEME_ROTATE_NUMERIC"])) 
	    { $num = "0"; } 
	  else 
	    {
	      $num = $HTTP_COOKIE_VARS["SV_THEME_ROTATE_NUMERIC"]+1;
	      # if the num is a value superior of the number of themes
	      # we reset to 0
	      if ($num==count($theme)) 
		{ $num = "0"; }		  
	    }
	  setcookie("SV_THEME_ROTATE_NUMERIC", $num, time() + 60*60*24*365, $GLOBALS['sys_home'],$GLOBALS['sys_default_domain']);	  
	  # we associate this number with a theme
	  $rotate_theme = $theme[$num];
	  setcookie("SV_THEME_ROTATE", $rotate_theme, time() + 60*60*24, $GLOBALS['sys_home'],$GLOBALS['sys_default_domain']);
	  define('SV_THEME', $rotate_theme);
	}
    } 
  else 
    {
      # the user picked a particular theme
      define('SV_THEME', $HTTP_COOKIE_VARS["SV_THEME"]);       
    }
} 
else 
{
  # no theme was defined, we use the default one
  define('SV_THEME', $sys_themedefault);
}

# Check whether a theme follows latest GUIDELINES
function theme_guidelines_check ($theme)
{
  # Get from the README the latest GUIDELINES number
  preg_match("/VERSION: (.*)/", utils_read_file($GLOBALS['sys_urlroot']."/css/README"), $latest);  
  # Get from the css the current GUIDELINES number
  preg_match("/\/\* GUIDELINES VERSION FOLLOWED: (.*) \*\//", utils_read_file($GLOBALS['sys_urlroot']."/css/".$theme.".css"), $current);
  
  if ($latest[1] != $current[1])
    {
      return false;
    }
  
  return true;
}

?>
