<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: project_home.php,v 1.109 2004/09/22 08:11:51 yeupou Exp $
#
# Copyright 1999-2000 (c) The SourceForge Crew
# Copyright 2000-2003 (c) Free Software Foundation
#
# Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#                         Yves Perrin <yves.perrin--at--cern.ch>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require_directory("people");
require_directory("news");
require $GLOBALS['sys_urlroot']."/include/vars.php";

# if we are at wrong url, redirect
if ($HTTP_HOST != $project->getTypeBaseHost() && $project->getTypeBaseHost())
{
  header ("Location: http".(session_issecure()?'s':'')."://".$project->getTypeBaseHost().$PHP_SELF);
  exit;
}

$group_name = $project->getUnixName();
site_project_header(array('group'=>$group_id,
			  'toptab'=>'home'));


# ########################### Members of this project
# (little box on the right)

$res_admin = db_query("SELECT user.user_id AS user_id,user.user_name AS user_name, user.realname AS realname "
		      . "FROM user,user_group "
		      . "WHERE user_group.user_id=user.user_id AND user_group.group_id=$group_id AND "
		      . "user_group.admin_flags = 'A'");


print '
<div class="indexright">
';

print $HTML->box_top(_("Membership Info"));
$adminsnum = db_numrows($res_admin);
if ($adminsnum > 0)
{

  print _("Project Admins").':';
  while ($row_admin = db_fetch_array($res_admin))
{
    print "<br />&nbsp; - ".utils_link($GLOBALS['sys_home']."users/".$row_admin[user_name], $row_admin[realname]);
  }
}

#count of developers on this project
$membersnum = db_fetch_array(db_query("SELECT COUNT(*) AS count FROM user_group WHERE group_id=$group_id AND admin_flags<>'P'"));
print '<br /><br />'._("Members").': <font class="bold">'.$membersnum[count].'</font>';

# if member = 1, it's obviously (or it should be) the project admin
# if there's no admin, we need to get access to the list
# But we show it anyway: this page can be used for request for membership,
# provide more info that the little infobox.
print '<br />&nbsp; '.utils_link($GLOBALS['sys_home'].'project/memberlist.php?group='.$group_name, "[View&nbsp;&nbsp;Members]");


print $HTML->box_bottom();
print '<br />';
print $HTML->box_top(_("Group identification"));
print '&nbsp; - #'.$group_id;
print '<br />&nbsp; - '.$group_name;
print $HTML->box_bottom();


print '
</div><!-- end indexright -->
<div class="indexcenter">
';


# ########################### General Informations

if ($project->getTypeDescription())
{ print '<p>'.$project->getTypeDescription()."</p>\n"; }

if ($project->getLongDescription())
{
  print "<p>" . utils_make_links(nl2br($project->getLongDescription()), $group_id)."</p>\n";
} else
{
  if ($project->getDescription())
{
    print "<p>" . $project->getDescription()."</p>\n";
  }
else
{
    print '<p>';
    printf(_("This project has not yet submitted a short description. You can %ssubmit it%s now."), '<a href="'.$GLOBALS['sys_home'].'project/admin/editgroupinfo.php?group='.$group_name.'">', '</a>');
    print "</p>\n";
  }
}
print '<p>';
if ($project->CanUse("license"))
{
  $license = $project->getLicense();
  print _("License").' : ';
  if ($LICENSE_URL[$license] != "0")
    { print utils_link($LICENSE_URL[$license], $LICENSE[$license]); }
  else
    { print $LICENSE[$license]; }
}
print '<br />'._("Registration Date").' : '.format_date($sys_datefmt,$project->getStartDate())."\n";
if ($project->CanUse("devel_status"))
{
  $devel_status = $project->getDevelStatus();
  print '<br />'._("Development Status").' : '.$DEVEL_STATUS[$devel_status]."\n";
}
print '</p>
</div><!-- end indexcenter -->
<p class="clearr">&nbsp;</p>
';

# ############################## ###########################
# #######################################################################
# ##############################  ###########################
# #######################################################################

# ########################### News

if ($project->Uses("news")) {

  print '
<div class="splitright">';

  print $HTML->box_top(_("Latest News"));
  print news_show_latest($group_id,4,"true");
  print $HTML->box_bottom();

  print '
</div><!-- end splitright -->
<div class="splitleft">
';

}

# ############################## ADMIN AREA ###########################
# #######################################################################

if ($GLOBALS[sys_group_id] == $group_id)
{
  if (member_check(0, $group_id, 'A'))
    {
      require $GLOBALS['sys_urlroot']."/include/features_boxes.php";
      print $HTML->box_top(sprintf(_("Administration: %s server"), $GLOBALS['sys_name']));
      print sprintf(_("Since you are administrator of this project, which one is the \"system project\", you are administrator of the whole %s server."), $GLOBALS['sys_name']);

      print $HTML->box_nextitem(utils_get_alt_row_color($i));

      print utils_link($GLOBALS['sys_home'].'admin/',
		      html_image("admin.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Server Admin"))).'&nbsp;'._("Server Main Administration Page"));

      print $HTML->box_nextitem(utils_get_alt_row_color($i+1));

      print utils_link($GLOBALS['sys_home'].'admin/approve-pending.php',
		       html_image("admin.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Server Admin"))).'&nbsp;'._("Pending Projects List"));
      print ' (<b>'.number_format(stats_getprojects_pending()).'</b> '._("registrations pending").')';
      print $HTML->box_bottom();
      print '<br />';
    }
}

if (member_check(0, $group_id, 'A'))
{
  print $HTML->box_top(sprintf(_("Administration: %s project"), $project->getName()));
  print _("As administrator of this project, you can manage members and activate/deactivate/configure your project's tools.");

  print $HTML->box_nextitem(utils_get_alt_row_color($i));

  print utils_link($GLOBALS['sys_home'].'project/admin/?group='.$group_name,
		  html_image("main.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Admin Page"))).'&nbsp;'._("Project Main Administration Page"));
  print $HTML->box_bottom();
  print '<br />';
}


# ############################## PUBLIC AREAS ###########################
# #######################################################################

# ################################## QUICK OVERVIEW

function specific_makesep ()
{
  # too specific to be general function
  global $i, $j, $HTML;
  if ($i != $j)
    {
      print $HTML->box_nextitem(utils_get_alt_row_color($i));
      $j = $i;
    }
}

print $HTML->box_top(_("Public Areas: Quick Overview"));
$i = 1;
$j = $i;
# Homepage Link

if ($project->Uses("homepage"))
{
  print utils_link($project->getUrl("homepage"),
		   html_image("www.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Homepage"))).'&nbsp;'._("Project Homepage"));
  $i++;
}

# Documentation (extra link)
if ($project->Uses("extralink_documentation"))
{
  specific_makesep();

  print utils_link($project->getUrl("extralink_documentation"),
		   html_image("man.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Documentation"))).'&nbsp;'._("Documentation"));
  $i++;
}

# Download area
if($project->Uses("download")) {
  specific_makesep();

  # the pointer is always the filelist, this page will handle redirect
  # appropriately in case that no download area is here
  print utils_link($project->getArtifactUrl("files"),
		   html_image("download.png",array('width'=>'24', 'height'=>'24', 'alt'=>'Filelist')).'&nbsp;'._("Filelist").' ('._("Download area").')');
  $i++;
}

# Memberlist
specific_makesep();
print utils_link($GLOBALS['sys_home'].'project/memberlist.php?group='.$group_name,
		 html_image("people.png",array('width'=>'24', 'height'=>'24', 'alt'=>'Memberlist')).'&nbsp;'._("Project Memberlist"));
$i++;

print $HTML->box_bottom();
print '<br />';


# ################################## COMMUNICATION

if ($GLOBALS[sys_unix_group_name] == $group_name ||
    $project->Uses("support") ||
    $project->Uses("forum") ||
    $project->usesMail() ||
    people_project_jobs_rows($group_id) != 0)
{

  print $HTML->box_top(_("Public Areas: Communication Tools"));
  $i = 1;
  $j = $i;

  if ($GLOBALS[sys_unix_group_name] == $group_name) {
    print utils_link($GLOBALS['sys_home'].'faq/?group='.$group_name,
		     html_image("man.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Frequently Asked Questions"))).'&nbsp;'._("Frequently Asked Questions"));
    $i++;
  }


  # Support Manager

  if ($project->Uses("support")) {
    specific_makesep();
    $url = $project->getArtifactUrl("support");

    print utils_link($url,
		     html_image("help.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Tech Support Manager"))).'&nbsp;'._("Tech Support Manager"));

    if (group_get_artifact_url("support", 0) == $url)
      {

	$res_count = db_query("SELECT count(*) AS count FROM support WHERE group_id=$group_id AND status_id != 3");
	$row_count = db_fetch_array($res_count);
	print " (<b>$row_count[count]</b>";
	$res_count = db_query("SELECT count(*) AS count FROM support WHERE group_id=$group_id");
	$row_count = db_fetch_array($res_count);
	print ' '._("open requests").", <b>$row_count[count]</b> "._("total").")\n";
	print '<br /> &nbsp; - '.utils_link($url.'&amp;func=additem', _("Submit a Request"), 0, group_restrictions_check($group_id, "support"));
	print '<br /> &nbsp; - '.utils_link($url.'&amp;func=browse&amp;set=open', _("Browse Open Requests"));
      }

    $i++;
  }


  # Fora
  # It must be reactivated on Savannah.

  if ($project->Uses("forum")) {
    specific_makesep();

    $url = $project->getArtifactUrl("forum");

    print utils_link($url,
		     html_image("help.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Public Forum"))).'&nbsp;'._("Public Forum"));

    if (group_get_artifact_url("forum", 0) == $url)
      {

	$res_count = db_query("SELECT count(forum.msg_id) AS count FROM forum,forum_group_list WHERE "
			      . "forum_group_list.group_id=$group_id AND forum.group_forum_id=forum_group_list.group_forum_id "
			      . "AND forum_group_list.is_public=1");
	$row_count = db_fetch_array($res_count);
	print ' (<b>'.$row_count[count].'</b> '._("messages in");

	$res_count = db_query("SELECT count(*) AS count FROM forum_group_list WHERE group_id=$group_id "
			      . "AND is_public=1");
	$row_count = db_fetch_array($res_count);

	print " <b>$row_count[count]</b> "._("forums").")\n";
      }
    $i++;

  }

  # Mailing lists

  if ($project->usesMail())
    {
      specific_makesep();
      $url = $project->getArtifactUrl("mail");
   
      print utils_link($url,
		       html_image("mail.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Mailing Lists"))).'&nbsp;'._("Mailing Lists"));
      $res_count = db_query("SELECT count(*) AS count FROM mail_group_list WHERE group_id=$group_id AND is_public=1");
      $row_count = db_fetch_array($res_count);
      print " (<b>$row_count[count]</b> "._("public mailing lists").")";
      $i++;
    }

  # Looking for people

  if (people_project_jobs_rows($group_id) != 0) {
    specific_makesep();
    print utils_link($GLOBALS['sys_home'].'people/?group='.$group_name,
		     html_image("people.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("People"))).'&nbsp;'._("This project is looking for people"));
    print ' (<b>'.people_project_jobs_rows($group_id).'</b> '._("jobs").')';
    $i++;
  }

  print $HTML->box_bottom();
  print '<br />';
}

# ################################## DEVELOPMENT

if ($project->Uses("patch") ||
    $project->Uses("cvs") ||
    $project->Uses("homepage") ||
    $project->Uses("bugs") ||
    $project->Uses("task") ||
    $project->Uses("patch"))
{
  print $HTML->box_top(_("Public Areas: Development Tools"));
  $i = 1;
  $j = $i;

  # CVS

  if (($project->getUrl("cvs_viewcvs") != 'http://' && $project->getUrl("cvs_viewcvs") != '' && $project->Uses("cvs")) || ($project->getUrl("cvs_viewcvs_homepage") != 'http://' && $project->getUrl("cvs_viewcvs_homepage") != '' && $project->Uses("homepage")))
    {
      
      $url = $project->getArtifactUrl("cvs");
      
      html_image("cvs.png",array('width'=>'24', 'height'=>'24', 'alt'=>'CVS'));
      print '&nbsp;<a href="'.$url.'">'._("CVS Repository").'</a>';

      if ($project->getUrl("cvs_viewcvs") != 'http://' && $project->getUrl("cvs_viewcvs") != '' && $project->Uses("cvs"))
	{
	  print '<br /> &nbsp; - <a href="'.$project->getUrl("cvs_viewcvs").'">'._("Browse Sources Repository").'</a>';
	}
      if ($project->getUrl("cvs_viewcvs_homepage") != 'http://' && $project->getUrl("cvs_viewcvs_homepage") != '' && $project->Uses("homepage"))
	{
	  # Consider that this link is valid if not empty or not 'http:#'
	  # (default).
	  # Only the backend should make use of the is_homepage_on_cvs value,
	  # because and homepage can be on CVS with this flag off: this flag
	  # is used to determine whether a CVSROOT must be created or not
	  print '<br /> &nbsp; - <a href="'.$project->getUrl("cvs_viewcvs_homepage").'">'._("Browse Web Pages Repository").'</a>';
	}
      $i++;
    }

  # Bug tracking

  if ($project->Uses("bugs")) {
    specific_makesep();
    $url = $project->getArtifactUrl("bugs");

    print utils_link($url,
		     html_image("bug.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Bug Tracking"))).'&nbsp;'._("Bug Tracking"));
    
    if (group_get_artifact_url("bugs", 0) == $url)
      {
	$res_count = db_query("SELECT count(*) AS count FROM bugs WHERE group_id=$group_id AND status_id != 3");
	$row_count = db_fetch_array($res_count);
	print " (<b>$row_count[count]</b>";
	$res_count = db_query("SELECT count(*) AS count FROM bugs WHERE group_id=$group_id");
	$row_count = db_fetch_array($res_count);
	print ' '._("open bugs").", <b>$row_count[count]</b> "._("total").")\n";
	print '<br /> &nbsp; - '.utils_link($url.'&amp;func=additem', _("Submit a Bug"), 0, group_restrictions_check($group_id, "bugs"));
	print '<br /> &nbsp; - '.utils_link($url.'&amp;func=browse&amp;set=open', _("Browse Open Bugs"));
      }
    $i++;
  }


  # Task Manager

  if ($project->Uses("task")) {
    specific_makesep();
    $url = $project->getArtifactUrl("task");

    print utils_link($url,
		     html_image("task.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Task Manager"))).'&nbsp;'._("Task Manager"));

    if (group_get_artifact_url("task", 0) == $url)
      {
	$res_count = db_query("SELECT count(*) AS count FROM task WHERE group_id=$group_id AND status_id != 3");
	$row_count = db_fetch_array($res_count);
	print " (<b>$row_count[count]</b>";
	$res_count = db_query("SELECT count(*) AS count FROM task WHERE group_id=$group_id");
	$row_count = db_fetch_array($res_count);
	print ' '._("open tasks").", <b>$row_count[count]</b> "._("total").")\n";
	print '<br /> &nbsp; - '.utils_link($url.'&amp;func=additem', _("Submit a Task"), 0, group_restrictions_check($group_id, "task"));
	print '<br /> &nbsp; - '.utils_link($url.'&amp;func=browse&amp;set=open', _("Browse Open Tasks"));
      }
    $i++;
  }


  # Patch Manager

  if ($project->Uses("patch")) {
    specific_makesep();
    $url = $project->getArtifactUrl("patch");

    print utils_link($url,
		     html_image("attach.png",array('width'=>'24', 'height'=>'24', 'alt'=>_("Patch Manager"))).'&nbsp;'._("Patch Manager"));


    if (group_get_artifact_url("patch", 0) == $url)
      {
	$res_count = db_query("SELECT count(*) AS count FROM patch WHERE group_id=$group_id AND status_id != 3");
	$row_count = db_fetch_array($res_count);
	print " (<b>$row_count[count]</b>";
	$res_count = db_query("SELECT count(*) AS count FROM patch WHERE group_id=$group_id");
	$row_count = db_fetch_array($res_count);
	print ' '._("open patch").", <b>$row_count[count]</b> "._("total").")\n";
	print '<br /> &nbsp; - '.utils_link($url.'&amp;func=additem', _("Submit a Patch"), 0, group_restrictions_check($group_id, "patch"));
	print '<br /> &nbsp; - '.utils_link($url.'&amp;func=browse&amp;set=open', _("Browse Open Patches"));
      }
    $i++;
  }

  print $HTML->box_bottom();
}


# ########################### News

if ($project->Uses("news")) {
  print '
</div><!-- end splitleft -->
';
}


site_project_footer(array());

?>
