<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: skill.php,v 1.5 2004/03/13 18:22:06 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2004      (c) ...
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
#
#

function people_skill_box($name='skill_id',$checked='xyxy')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_skill_box ';
  global $PEOPLE_SKILL;
  if (!$PEOPLE_SKILL)
    {
      #will be used many times potentially on a single page
      $sql="SELECT * FROM people_skill ORDER BY name ASC";
      $PEOPLE_SKILL=db_query($sql);
    }
  return html_build_select_box ($PEOPLE_SKILL,$name,$checked);
}

function people_skill_level_box($name='skill_level_id',$checked='xyxy')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_skill_level_box ';
  global $PEOPLE_SKILL_LEVEL;
  if (!$PEOPLE_SKILL_LEVEL)
    {
      #will be used many times potentially on a single page
      $sql="SELECT * FROM people_skill_level";
      $PEOPLE_SKILL_LEVEL=db_query($sql);
    }
  return html_build_select_box ($PEOPLE_SKILL_LEVEL,$name,$checked);
}

function people_skill_year_box($name='skill_year_id',$checked='xyxy')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_skill_year_box ';
  global $PEOPLE_SKILL_YEAR;
  if (!$PEOPLE_SKILL_YEAR)
    {
      #will be used many times potentially on a single page
      $sql="SELECT * FROM people_skill_year";
      $PEOPLE_SKILL_YEAR=db_query($sql);
    }
  return html_build_select_box ($PEOPLE_SKILL_YEAR,$name,$checked);
}

function people_add_to_skill_inventory($skill_id,$skill_level_id,$skill_year_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_add_to_skill_inventory($skill_id,$skill_level_id,$skill_year_id) ';
  global $feedback;
  if (user_isloggedin())
    {
      #check if they've already added this skill
      $sql="SELECT * FROM people_skill_inventory WHERE user_id='". user_getid() ."' AND skill_id='$skill_id'";
      $result=db_query($sql);
      if (!$result || db_numrows($result) < 1)
	{
	  #skill not already in inventory
	  $sql="INSERT INTO people_skill_inventory (user_id,skill_id,skill_level_id,skill_year_id) ".
	     "VALUES ('". user_getid() ."','$skill_id','$skill_level_id','$skill_year_id')";
	  $result=db_query($sql);
	  if (!$result || db_affected_rows($result) < 1)
	    {
	      ' ERROR inserting into skill inventory ';
	      echo db_error();
	    }
	  else
	    {
	      ' Added to skill inventory ';
	    }
	}
      else
	{
	  ' ERROR - skill already in your inventory ';
	}
    }
  else
    {
      echo '<H1>You must be logged in first</H1>';
    }
}

function people_show_skill_inventory($user_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_show_skill_inventory($user_id) ';
  $sql="SELECT people_skill.name AS skill_name, people_skill_level.name AS level_name, people_skill_year.name AS year_name ".
     "FROM people_skill_year,people_skill_level,people_skill,people_skill_inventory ".
     "WHERE people_skill_year.skill_year_id=people_skill_inventory.skill_year_id ".
     "AND people_skill_level.skill_level_id=people_skill_inventory.skill_level_id ".
     "AND people_skill.skill_id=people_skill_inventory.skill_id ".
     "AND people_skill_inventory.user_id='$user_id'";
  $result=db_query($sql);

  $title_arr=array();
  $title_arr[]=_("Skill");
  $title_arr[]=_("Level");
  $title_arr[]=_("Experience");

  echo html_build_list_table_top ($title_arr);

  $rows=db_numrows($result);
  if (!$result )  {
    echo '<tr><td><p class="warn">('._("SQL Error:").')</p>';
    echo db_error();
    echo '</td></tr>';
  } else if ( $rows < 1)
    {
      echo '<tr><td><p class="warn">('._("No Skill Inventory Set Up").')</p>';
      echo '</td></tr>';
    }
  else
    {
      for ($i=0; $i < $rows; $i++)
	{
	  echo '
			<tr class="'. utils_get_alt_row_color($i) .'">
				<td>'.db_result($result,$i,'skill_name').'</td>
				<td>'.db_result($result,$i,'level_name').'</td>
				<td>'.db_result($result,$i,'year_name').'</td></tr>';
	}
    }
  echo '</table>';
}

function people_edit_skill_inventory($user_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':people_edit_skill_inventory($user_id) ';
  global $PHP_SELF;
  $sql="SELECT *,people_skill.name AS skill_name FROM people_skill_inventory,people_skill WHERE user_id='$user_id' and people_skill.skill_id=people_skill_inventory.skill_id";
  $result=db_query($sql);

  $title_arr=array();
  $title_arr[]=_("Skill");
  $title_arr[]=_("Level");
  $title_arr[]=_("Experience");
  $title_arr[]=_("Action");

  echo html_build_list_table_top ($title_arr);

  $rows=db_numrows($result);
  if (!$result )  {
    echo '<tr><td colspan="4"><p class="warn">('._("SQL Error:").')';
    echo db_error();
    echo '</p></td></tr>';
  } else if ( $rows < 1)
    {
      echo '<tr><td colspan="4"><p class="warn">('._("No Skill Inventory Set Up").')</p>';
      echo '</td></tr>';
    }
  else
    {
      for ($i=0; $i < $rows; $i++)
	{
	  echo '
			<form action="'.$PHP_SELF.'" method="POST">
			<input type="hidden" name="skill_inventory_id" value="'.db_result($result,$i,'skill_inventory_id').'">
			<tr class="'. utils_get_alt_row_color($i) .'">
				<td><font size="-1">'. db_result($result,$i,'skill_name') .'</td>
				<td><font size="-1">'. people_skill_level_box('skill_level_id',db_result($result,$i,'skill_level_id')). '</td>
				<td><font size="-1">'. people_skill_year_box('skill_year_id',db_result($result,$i,'skill_year_id')). '</td>
				<td nowrap><font size="-1"><input type="SUBMIT" name="update_skill_inventory"'
	    .'value="'._("Update").'"> &nbsp;
					<input type="SUBMIT" name="delete_from_skill_inventory"'
	    .'value="'._("Delete").'"></td>
			</tr>
			</form>';
	}

    }
  #add a new skill
  $i++; #for row coloring

  echo '
	<tr><td colspan="4"><h3>'._("Add A New Skill").'</h3></td></tr>
	<form action="'.$PHP_SELF.'" method="POST">
	<tr class="'. utils_get_alt_row_color($i) .'">
		<td><font size="-1">'. people_skill_box('skill_id'). '</td>
		<td><font size="-1">'. people_skill_level_box('skill_level_id'). '</td>
		<td><font size="-1">'. people_skill_year_box('skill_year_id'). '</td>
		<td nowrap><font size="-1"><input type="submit" name="add_to_skill_inventory" value="'
    ._("Add Skill").'"></td>
	</tr>
	</form>';

  echo '
		</table>';
}


?>