#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_askrmgif.pl,v 1.2 2004/01/31 00:56:17 yeupou Exp $
#
#
#
# Copyright (C) Loic Dachary <loic@gnu.org>, 2002
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

use strict;

my($cmd);

my(%projects);
my(%base2project);
my(%project2base);
my(%www);
my(%sources);
my($totalcount);

#
# Projects with gif files in their sources
#
$cmd = "locate .gif,v | grep '^/cvsroot/' | grep -v Attic | sort ";
open(FILES, "$cmd |") or die "cannot run $cmd : $!";
while(<FILES>) {
    if(m:^/cvsroot/(.*?)/(.*).gif,v$:) {
	$sources{$1} .= "$2\n";
	$projects{$1} ++;
	$totalcount++;
    }
}
close(FILES);

#
# Projects with gif files in their webspace
#

#
# Map base directory with project name
#
$cmd = "mysql -B -Ne 'select html_cvs,unix_group_name from groups where html_cvs is not null and html_cvs != \"\" and status = \"A\" order by html_cvs desc ' sourceforge";
open(MAP, "$cmd |") or die "cannot run $cmd : $!";
while(<MAP>) {
    chop;
    my($base, $project) = split("\t");
    $base2project{$base} = $project;
    $project2base{$project} = $base;
}
close(MAP);

#
# Collect gif files, per project
#
$cmd = "locate .gif,v | grep '^/subversions/cvs/gnuweb/' | grep -v Attic | sort ";
open(FILES, "$cmd |") or die "cannot run $cmd : $!";
while(<FILES>) {
    if(m:^/subversions/cvs/gnuweb(/.*):) {
	my($file) = $1;
	my($base);
	foreach $base (reverse(sort(keys(%base2project)))) {
	    if($file =~ m:^${base}(.*).gif,v$:) {
		my($project) = $base2project{$base};
		$www{$project} .= $1 . "\n";
		$projects{$project} ++;
		$totalcount++;
		last;
	    }
	}
    }
}
close(FILES);

#
# Prepare mails to be sent
#
my($tmp) = "/tmp/mail.savannah.report";
open(REPORT, ">$tmp") or die "cannot open $tmp for writing : $!";
print REPORT <<EOF;
Subject: GIF files report
To: savannah-hackers\@gnu.org

    A mail asking to remove GIF files was automatically sent to
the following project members. The script generating this report
is subversions.gnu.org:$0 and is run once a week from 
subversions.gnu.org:/etc/cron.d/savannah.

EOF

print REPORT "Total: " . keys(%projects) . " projects and $totalcount files.\n\n";

my($project);
foreach $project (keys(%projects)) {
    $cmd = "mysql -B -Ne \"select user.email,user.user_name,user.realname from user,groups,user_group where user_group.user_id = user.user_id and user_group.group_id = groups.group_id and groups.unix_group_name = '$project'\" sourceforge";
    print REPORT "\nhttp://savannah.gnu.org/projects/$project ($projects{$project} files)\n";
    open(PEOPLE, "$cmd |") or die "cannot run $cmd : $!";
    my(@recipients);
    while(<PEOPLE>) {
	chop;
	my($email, $user, $realname) = split("\t");
	
	print REPORT "\thttp://savannah.gnu.org/users/$user\n\t\t$realname\t<$email>\n";
	push(@recipients, $email);
    }

    close(PEOPLE);

    my($email) = join(',', @recipients);
    my($tmp) = "/tmp/mail.$project";
    open(MAIL, ">$tmp") or die "cannot open $tmp for writing : $!";
        print MAIL <<EOF;
Subject: $project: GIF files
To: $email
Reply-To: savannah-hackers\@gnu.org

    Hi,

    Could you please remove the following GIF files from the project
$project hosted on the GNU machines ? 

    For an explanation on why there are not GIF files on the GNU
machines read http://www.gnu.org/philosophy/gif.html. This policy was
established years ago by the GNU project and is an integral part of
the requirements for every project registering on savannah.gnu.org
(see http://savannah.gnu.org/register/requirements.php).


    This mail was created by a script on the Savannah machine and
run manually by one of the savannah-hackers\@gnu.org. It was sent
to all members of $project because we have no automated way to
figure out what is the relevant mailing list and who, among the 
existing developers, is taking care of these issues at present.

    The home page of your project is 
      http://savannah.gnu.org/projects/$project/

    You can convert GIF files to PNG using the gif2png program.
      http://www.tuxedo.org/~esr/gif2png/gif2png-2.4.2.tar.gz

    In the following we suggest a small script to convert the images
to the PNG format. Note that you should also make sure the software does
not reference the old GIF images. This is likely to require manual
attention in most cases.

EOF

    if(exists($www{$project})) {
	my($base) = $project2base{$project};
        $base =~ s:^/::;
	print MAIL <<EOF;
    Here is a sample script to convert the GIF files that are in
your web pages to PNG.

    export CVS_RSH=ssh
    cvs -d user\@subversions.gnu.org:/webcvs co $base
    cd $base

    while read file 
    do
	gif2png -O \$file.gif
	cvs delete -f \$file.gif
	cvs add \$file.png
    done <<'EOF'
$www{$project}EOF
    cvs commit -m 'Convert GIF to PNG'

EOF
}

    if(exists($sources{$project})) {
	print MAIL <<EOF;
    Here is a sample script to convert the GIF files that are in
the sources of $project to PNG.

    export CVS_RSH=ssh
    mkdir tmp 
    cd tmp
    cvs -d user\@subversions.gnu.org:/cvsroot/$project co .

    while read file 
    do
	gif2png -O \$file.gif
	cvs delete -f \$file.gif
	cvs add \$file.png
    done <<'EOF'
$sources{$project}EOF
    cvs commit -m 'Convert GIF to PNG'

EOF
}

	print MAIL <<EOF;

        For additional information please write to savannah-hackers\@gnu.org. A more sophisticated shell script to convert the GIF files
into PNG files is also available at
http://savannah.gnu.org/cgi-bin/viewcvs/savannah/savannah/gnuscripts/sf_removegif

	Thanks for your help,

	The GNU volunteers, savannah-hackers\@gnu.org
EOF
	close(MAIL);
}
close(REPORT);

print <<'EOF'

Now send all mails by running:

for i in /tmp/mail.* ; do sendmail -f savannah-hackers@gnu.org -t < $i ; sleep 5 ; echo $i ; done

EOF
