<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: detail.php,v 1.32 2004/09/22 08:11:51 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#                          Yves Perrin <yves.perrin--at--cern.ch>
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
$sql="SELECT * FROM ".ARTIFACT." WHERE bug_id='$item_id' AND group_id='$group_id'";
$fields_per_line=2;
$max_size=40;

$result=db_query($sql);

if (db_numrows($result) > 0) 
{
  # ################################ Start the form
  
  # Defines the item name, converting bugs to bug.
  # (Ideally, the artifact bugs should be named bug)
  if (ARTIFACT == "bugs") 
    { $item_name = "bug #".$item_id; }
  else
    { $item_name = ARTIFACT." #".$item_id; }
  # Defines the item link
  $item_link = utils_link("?func=detailitem&item_id=".$item_id, $item_name);

  # Check whether this item is private or not. If it is private, show only to 
  # the submitter
  unset($private_intro);
  if (db_result($result,0,'privacy') == "2") 
    {
      if (db_result($result,0,'submitted_by') != user_getid()) 
	{
	  exit_error(_("This item is private."));
	}
      else 
	{
	  $private_intro = _("This item is private. However, you are allowed to read it as you submitted it.");
	}
    }

  trackers_header(array ('title'=>_("Item Detail:").' '.$item_id));

  print $private_intro;

  print '<h2 class="'.utils_get_priority_color(db_result($result,0,'priority'), db_result($result,0,'status_id')).'">'.sprintf(_("<i>%s</i> overview:"), $item_link).' '.db_result($result,0,'summary').'</h2>';

  print '<form action="'.$PHP_SELF.'" method="post" enctype="multipart/form-data">';
 
  print '<input type="hidden" name="func" value="postaddcomment">';
  print '<input type="hidden" name="group_id" value="'.$group_id.'">';
  print '<input type="hidden" name="item_id" value="'.$item_id.'">';

  print '<table cellpadding="0" width="100%">';
  print '<tr><td><font class="preinput">'._("Submitted by:").'</font>&nbsp;'.utils_user_link(user_getname(db_result($result,0,'submitted_by')),user_getrealname(db_result($result,0,'submitted_by'))).'</td>';
  print '<td colspan="6" align="center" valign="top"><input type="submit" name="submit" value="'._("Submit Changes").'" class="bold"></td>';
  print '</tr>';
  print '<tr><td><font class="preinput">'._("Submitted on:").'</font>&nbsp;'.format_date($sys_datefmt,db_result($result,0,'date')).'</td>';
  print '<td>&nbsp;</td>';
  print '</tr>';
  print '<tr><td colspan="'.$fields_per_line.'">&nbsp</td></tr>';

  # Print special fields

  $i=0;
  while ( $field_name = trackers_list_all_fields() ) 
    {


      # if the field is a special field (except summary and details) 
      # or if not used by this project  then skip it.
      if ( (!trackers_data_is_special($field_name)  || $field_name=='summary' || $field_name=='details') &&
	   trackers_data_is_used($field_name) ) 
	{

	  # if the submitter was anonymous, print the originator email field
	  if ($field_name != 'originator_email' ||
	      ($field_name == 'originator_email' && db_result($result,0,'submitted_by') == '100'))
	    {

				   
	  # display the bug field
	  # if field size is greatest than max_size chars then force it to
	  # appear alone on a new line or it won't fit in the page
	  $field_value = db_result($result,0,$field_name);
	  list($sz,) = trackers_data_get_display_size($field_name);

	  $field_display = trackers_field_display($field_name,$group_id,$field_value,false,true,true);
	  if ($field_name=='details') 
	    $value = utils_make_links($field_display,$group_id);

	  if ($sz > $max_size) 
	    {
	      print "\n<tr>".
		'<td valign="top" colspan="'.$fields_per_line.'">'.
		$field_display.'</td>'."\n</tr>";
	      $i=0;
	    } 
	  else 
	    {
	      print ($i % $fields_per_line ? '':"\n<tr>");
	      print '<td valign="top">'.$field_display.'</td>';
	      $i++;
	      print ($i % $fields_per_line ? '':"\n</tr>");
	    }
	}  
        }
    }
      
  print '</table>';
  print '<p>&nbsp;</p>';

  # ################################ Shortcuts

  print '<h2 class="'.utils_get_priority_color(db_result($result,0,'priority'), db_result($result,0,'status_id')).'">'.sprintf(_("<i>%s</i> details:"), $item_link).'</h2>';
  print '&nbsp;&nbsp;- <a href="#comments">'._("Follow-up Comments").'</a><br />';  
  print '&nbsp;&nbsp;- <a href="#attached">'._("Attached Files").'</a><br />';
  print '&nbsp;&nbsp;- <a href="#cc">'._("Mail Notification Carbon-Copy List").'</a><br />';
  print '&nbsp;&nbsp;- <a href="#dependencies">'._("Dependencies").'</a><br />';
  print '&nbsp;&nbsp;- <a href="#history">'._("History").'</a><br />';
  print '<p>&nbsp;</p>';


# ################################ Comments 

  print '<h3>'.html_anchor(_("Follow-up Comments"), 'comments').'</h3>';
  printf (_("(Note: you can add pointers to others items by typing %s where %s is one of %s and %s the item id number.)"), 
	  "<font class=\"italic\">artifact #nnn</font>",
	  "<font class=\"italic\">artifact</font>",
	  "<font class=\"italic\">support, bug, task, patch</font>",
	  "<font class=\"italic\">nnn</font>");
  print '<p>&nbsp;&nbsp;&nbsp;';
  print trackers_field_textarea('details','');
  print '<p>';

  if (!user_isloggedin()) 
    {
      print '<h2 class="warn">'._("You are not logged in").'</h2><p>';
      printf (_("Please %slog in,%s so followups can be emailed to you."),'<a href="'.$GLOBALS['sys_home'].'account/login.php?uri='.urlencode($REQUEST_URI).'">','</a>');
      print '</p>';
    }

  print '<p>&nbsp;</p>';

  print show_item_details($item_id,$group_id);

  print '<p>&nbsp;</p>';

  # ################################ Attached Files

  print '<h3>'.html_anchor(_("Attached Files"), "attached").'</h3>';
  
  print '<font class="preinput"> '._("Attach File:").'</font><br />
      &nbsp;&nbsp;&nbsp;<input type="file" name="input_file" size="40">
      <br />
      <font class="preinput">'._("File Description:").'</font><br />
      &nbsp;&nbsp;&nbsp;<input type="text" name="file_description" size="60" maxlength="255">
      </p><p>';
	  
  show_item_attached_files($item_id,$group_id);

  print '</p>&nbsp;<p>';

  # ################################ Mail notification
  
  print '<h3>'.html_anchor(_("Mail Notification Carbon-Copy List"), "cc").'</h3>';

  if (user_isloggedin()) 
    {
      printf (_("(Note: for %s users, you can use their login name rather than their email addresses.)"), $GLOBALS['sys_name']);
      print '<p>
	   <font class="preinput">'._("Add an email address that should receive carbon copies of updates of this item:").'</font><br />&nbsp;&nbsp;&nbsp;<input type="text" name="add_cc" size="30"><br />
	   <font class="preinput">'._("Comment:").'</font><br />&nbsp;&nbsp;&nbsp;<input type="text" name="cc_comment" size="40" maxlength="255"><p>';
    }

  show_item_cc_list($item_id, $group_id);
    
  print '<p>&nbsp;</p>';

  # Dependancies 

  print '<h3>'.html_anchor(_("Dependencies"), "dependencies").'</h3>';

  print show_item_dependency($item_id);

  print '<p></p>';

  print show_dependent_item($item_id);

  print '<p>&nbsp;</p>';

  #  Submit 

  print '<p align="center">
	  <input type="submit" name="submit" class="bold" value="'._("Submit Changes").'">
	  </form>
	</p>';



  # History 

  print '<p>&nbsp;</p><p>&nbsp;</p>';
  show_item_history($item_id,$group_id);

  trackers_footer(array());
} 
else
{
  exit_error(_("No item found with that id."));
}


?>
