#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_cleaner.pl,v 1.4 2004/09/22 08:11:49 yeupou Exp $
#
#  Copyright 2003 (c) Mathieu Roy <yeupou@gnu.org> 
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

##
## This script should be used via a cronjob to clean up the system and
## the database.
## Why cleaning up? Well, in some case, when an operation is interrupted,
## the PHP frontend cannot make this cleanup by himself.
##
## This script should run every hour at least.
## 
## WARNING: this script is not supposed to handle bugs in the PHP interface
## but handle issues that the PHP interface cannot handled without being
## bloated.
##

use strict;
use Savannah;
use Getopt::Long;
use Term::ANSIColor qw(:constants);
use POSIX qw(strftime);
use Time::Local;

# Import
our $sys_cron_cleaner;

my $script = "sv_cleaner";
my $logfile = "/var/log/sv_cleaner.log";
my $lockfile = "/var/run/sv_cleaner.lock";
my $getopt;
my $help;
my $debug;
my $cron;
my $version = GetVersion();

# get options
eval {
    $getopt = GetOptions("help" => \$help,
			 "cron" => \$cron,
			 "debug" => \$debug);
};

if($help) {
    print STDERR <<EOF;
Usage: $0 [project] [OPTIONS] 
 
Cleaner of the database. Why cleaning up? Well, in some case, when an
operation is interrupted, the PHP frontend cannot make this cleanup by
himself.

  -h, --help                   Show this help and exit
  -d, --debug                  Do nothing, print everything
      --cron                   Option to set when including this script
                               in a crontab
Savane version: $version
EOF
exit(1);
}

# Test if we should run, according to conffile
exit if ($cron && ! $sys_cron_cleaner);

# Log: Starting logging
open (LOG, ">>$logfile");
print LOG strftime "[$script] %c - starting\n", localtime;


# Locks: This script should not run concurrently
#        So we add a lock
if (-e $lockfile) {
    print LOG "[$script] There's a lock ($lockfile), exiting\n";
    die "There's a lock ($lockfile), exiting";
}
`touch $lockfile`;


#######################################################################
##
## Remove user account registration not confirmed after two days
##
#######################################################################


my ($year, $month, $day) = split(",", `date -d "3 days ago" +%Y,%m,%d`);
my $date = timelocal("0","0","0",$day,($month-1),($year-1900));

my $result = DeleteUsers("status='P' AND add_date < $date");

print LOG strftime "[$script] %c ---- deleted $result unconfirmed user accounts\n", localtime if $result > 0;


#######################################################################
##
## Remove inactive projects, usually registration interrupted
##
#######################################################################
 
my ($year, $month, $day) = split(",", `date -d "1 days ago" +%Y,%m,%d`);
my $date = timelocal("0","0","0",$day,($month-1),($year-1900));

my $result = DeleteGroups("status='I' AND register_time < $date");

print LOG strftime "[$script] %c ---- deleted $result inactive groups\n", localtime if $result > 0;


#######################################################################
##
## Project in holding status for too long should be pending
##
#######################################################################
 
# FIXME: TODO





# Final exit
print LOG strftime "[$script] %c - work finished\n", localtime;
print LOG "[$script] ------------------------------------------------------\n";

unlink($lockfile);

# EOF
