<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.51 2004/08/23 13:30:24 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

require "include/pre.php";
require_directory("people");
require_directory("news");
require "include/features_boxes.php";


# Check if the PHP Frontend is acceptably configured.
# Do progressive little checks, to avoid creating to much extra load.
# Not gettextized for now, already lot of more important strings to 
# translate.
if (!$GLOBALS['sys_unix_group_name'])
{
  fb("Configuration serious problem: sys_unix_group_name is not set", 1);   
  if (!$GLOBALS['sys_name'])
    {
      fb("Configuration problem: sys_name is not set", 1); 
    }
} 

$HTML->header(array('title'=>_("Welcome")));
html_feedback_top();

print '<!-- whole page table -->
<table>
<tr><td class="indexcenter">';

utils_get_content("homepage");

print '<p></p>';

$HTML->box1_top('<a href="'.$GLOBALS['sys_home'].'news/" class="sortbutton">'._("Latest News").'</a>');
echo news_show_latest($GLOBALS['sys_group_id'],7, "true"); 
$HTML->box1_bottom();


print '</td><td class="indexright">';

print show_features_boxes();

$HTML->box1_top(_("Help Wanted"));
print '<font class="small">'.people_show_category_list().'<font>';
$HTML->box1_bottom();

print '</td></tr></table>';

$HTML->footer(array());

?>
