<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: user_home.php,v 1.33 2004/06/28 14:21:32 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2001 (c) Free Software Foundation
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.



site_header(array('title'=>_("User Profile"),'toptab'=>'people'));


/*
	Assumes $res_user result handle is present

*/
if (!$res_user || db_numrows($res_user) < 1) {
	exit_error('No Such User','No Such User');
}


/* permit to the user to specify something */

print '<form action="'. $PHP_SELF .'" method="post">';
print '<h3>';
if ($detailed)
{ $checked = " selected"; }
printf (_("Print %s information."), '<select name="detailed"><option value="0">'._("Basic").'</option><option value="1"'.$checked.'>'._("Detailed").'</option></select>');
print '&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" value="'._("Apply").'"></h3></form>';

print '<br>';


print '
<table width="100%" cellpadding="2" cellspacing="2" border="0"><tr valign="top">
<td width="50%">';

if ($detailed)
{
  $artifacts = array("support", "bugs", "task", "patch");
  
  function specific_print_items ($criterion, $user_id) 
    {
      # Print full info for the still opened items, just list the remaining.
      $k = 1;
      reset($GLOBALS['artifacts']);
      while (list(,$artifact) = each($GLOBALS['artifacts']))
	{
	  $sql='SELECT bug_id,group_id,date,summary,status_id,privacy '.
	     ' FROM '.$artifact.
	     ' WHERE  '.$criterion.'='.$user_id.' ORDER BY date DESC';
	  $result = db_query($sql);
	  $rows = db_numrows($result);
	  if ($result && $rows > 0) 
	    {
	      for ($j=0; $j<$rows; $j++) 
		{
		  # Private items are simply ignored
		  if (db_result($result,$j,'privacy') != 2)
		    {
		      if (db_result($result,$j,'status_id') == 1)
			{
			  $k++;
			  print '<a href="'.$GLOBALS['sys_home'].$artifact.'/?func=detailitem&amp;item_id='.db_result($result,$j,'bug_id').'">';
			  print '['.$artifact.' #'.db_result($result,$j,'bug_id').', '.format_date($sys_datefmt,db_result($result,$j,'date')).']<br>&nbsp;&nbsp;';
			  print group_getname(db_result($result,$j,'group_id')).': '.db_result($result,$j,'summary');
			  print '</a>';
			  print '</td></tr><tr><td colspan="2" class="'.utils_get_alt_row_color($k).'">'."\n\n";
			}
		      else
			{ 
			  $closed .= '<a href="'.$GLOBALS['sys_home'].$artifact.'/?func=detailitem&amp;item_id='.db_result($result,$j,'bug_id').'">';
			  $closed .= '['.$artifact.' #'.db_result($result,$j,'bug_id').']';
			  $closed .= '</a>, ';
			}
		      $exists = 1;
		    }
		}
	    }            
	}
      if ($closed)
	{ echo _("Closed:").' '.substr($closed,0,-2).'.'; }
      
      if (!$exists)
	{ echo '<font class="warn">'._("None found.").'</font>'; }
      
    }

  $HTML->box1_top(sprintf(_("Items submitted by %s"),db_result($res_user,0,'realname')));
  # FIXME: News item are missing
  specific_print_items("submitted_by", db_result($res_user,0,'user_id'));  
  $HTML->box1_bottom();
      
  print '<br><br>';

  $HTML->box1_top(sprintf(_("Items assigned to %s"),db_result($res_user,0,'realname')));
  # FIXME: News item are missing
  specific_print_items("assigned_to", db_result($res_user,0,'user_id'));
  $HTML->box1_bottom();
  


  print '
</td>
<td>&nbsp;</td>
<td width="50%">';

}


$HTML->box1_top(_("General Information"));

print '
<br>
<table width="100%" cellpadding="0" cellspacing="0" border="0">
<tr valign="top">
	<td>'._("Login Name:").' </td>
	<td><b>'.db_result($res_user,0,'user_name').'</b></td>
</tr>
<tr valign="top">
	<td>'
	._("Real Name:").' </td>
	<td><b>'.db_result($res_user,0,'realname').'</b></td>
</tr>
<tr valign="top">
	<td>'
	._("User ID:").' </td>
	<td><b>'.db_result($res_user,0,'user_id').'</b></td>
</tr>
<tr valign="top">
	<td>'._("Email Address:").' </td>
	<td>
	<b><a href="'.$GLOBALS['sys_home'].'sendmessage.php?touser='.db_result($res_user,0,'user_id').'">';

if (db_result($res_user,0,'email_hide') == "1") {
	print _("Send him/her a mail");

} else {
	print utils_antispam_email(db_result($res_user,0,'email'));
}

print '</a></b>
	</td>
</tr>
<tr valign="top">
	<td>'
	._("Site Member Since").':
	</td>
	<td>
		<b>'.format_date(false,db_result($res_user,0,'add_date')).'</b>
	</td>
</tr>
<tr valign="top">
	 <td></td>
	 <td><p>';

if (db_result($res_user,0,'people_view_skills') != 1) {
	print _("This user has set his/her profile to private").'.';
} else {
	print '<a href="'.$GLOBALS['sys_home'].'people/viewprofile.php?user_id='.db_result($res_user,0,'user_id').'"><b>'._("View Skills/Resume").'</b></a>';
}

print '</p>
	</td>
</tr>
';

if (db_result($res_user,0,'gpg_key') != "") {	
	print '<tr valign="top"><td></td><td>';
	print	'<a href="'.$GLOBALS['sys_home'].'people/viewgpg.php?user_id='.db_result($res_user,0,'user_id').'"><b>'._("View GPG Key").'</b></a>';
	print '</td></tr>';
}

print '</table>';

$HTML->box1_bottom();

if (!$detailed) 
{
  print '
</td>
<td>&nbsp;</td>
<td width="50%">';
}
else
{
  print '<br><br>';
}

$HTML->box1_top(_("Group Information")); 
# now get listing of groups for that user

$sql = "SELECT groups.group_name, "
. "groups.unix_group_name, "
. "groups.group_id "
. " FROM "
. "groups,user_group WHERE user_group.user_id='$user_id' AND "
. "groups.group_id=user_group.group_id AND groups.is_public='1' AND groups.status='A' AND user_group.admin_flags<>'P'";

$res_cat = db_query($sql);

# see if there were any groups
if (db_numrows($res_cat) < 1) {
  
	print '<p>'._("This developer is not a member of any project").'.</p>';
  
} else { 
	# endif no groups
	print '<p>'._("This developer/consultant is a member of the following group(s):").'</p>';
	print "<ul>";
	while ($row_cat = db_fetch_array($res_cat)) {
		print ("<li><a href=\"".$GLOBALS['sys_home']."projects/$row_cat[unix_group_name]/\">$row_cat[group_name]</a></li>\n");
	}
	print "</ul>";
} # end if groups

$HTML->box1_bottom(); 

print '</td></tr>
<tr><td colspan="3">';


if (user_isloggedin()) {
	print '<p>&nbsp;</p>';
	sendmail_form_message($GLOBALS['sys_home'].'sendmessage.php', $user_id);

} else {
	echo '<h3>'._("You Could Send a Message if you were logged in").'.</h3>';
  
}

print '
</td></tr>
</table>';


$HTML->footer(array());

?>
