<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: field_values.php,v 1.16 2004/03/13 18:22:06 yeupou Exp $
#
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

$is_admin_page='y';

if ($group_id && (user_ismember($group_id,'B2') || user_ismember($group_id,'A')))
{

  # Initialize global bug structures
  trackers_init($group_id);


  # ################################ Update the database

  if ($post_changes)
    {
      # A form of some sort was posted to update or create
      # an existing value

      if ($create_value)
	{
	  # A form was posted to update a field value
	  if ($value)
	    {
	      trackers_data_create_value($field,$group_id,
				    htmlspecialchars($value),
				    htmlspecialchars($description),
				    $order_id,'A');
	    }
	  else
	    {
	      fb(_("Error: empty field value not allowed!"));
	    }

	}
      else if ($update_value)
	{
	  # A form was posted to update a field value
	  if ($value)
	    {
	      trackers_data_update_value($fv_id, $field, $group_id,
				    htmlspecialchars($value),
				    htmlspecialchars($description),
				    $order_id,$status);
	    }
	  else
	    {
	      ("Error: empty field value not allowed!");
	    }

	}
      else if ($create_canned)
	{

	  # A form was posted to create a canned response
	  $sql="INSERT INTO ".ARTIFACT."_canned_responses (group_id,title,body) ".
	     " VALUES ('$group_id','". htmlspecialchars($title) .
	     "','". htmlspecialchars($body) ."')";
	  $result=db_query($sql);
	  if (!$result)
	    {
	      fb(_("Error inserting canned bug response!"));
	      ' - '.db_error();
	    }
	  else
	    {
	      fb(_("Canned bug response inserted"));
	    }

	}
      else if ($update_canned)
	{

	  # A form was posted to update a canned response
	  $sql="UPDATE ".ARTIFACT."_canned_responses ".
	     "SET title='". htmlspecialchars($title) ."', body='". htmlspecialchars($body).
	     "' WHERE group_id='$group_id' AND bug_canned_id='$item_canned_id'";
	  $result=db_query($sql);
	  if (!$result)
	    {
	      fb(_("Error updating canned bug response!"));
	      ' - '.db_error();
	    }
	  else
	    {
	      fb(_("Canned bug response updated"));
	    }
	}

    }


  # ################################  Display the UI form

  if ($list_value)
    {

      # Display the List of values for a given bug field

      $hdr = sprintf(_("Manage Field Values for '%s'"),trackers_data_get_label($field));

      trackers_header_admin(array ('title'=>$hdr));


      # First check that this field is used by the project and
      # it is in the project scope

      $is_project_scope = trackers_data_is_project_scope($field);

      if ( trackers_data_get_field_id($field) &&
	   trackers_data_is_select_box($field))
	{

	  $result = trackers_data_get_field_predefined_values($field, $group_id,false,false,false);
	  $rows = db_numrows($result);

	  if ($result && $rows > 0)
	    {
	      print "\n<h3>"._("Existing Values").'</h3>';

	      $title_arr=array();
	      if (!$is_project_scope)
		{ $title_arr[]='ID'; }
	      $title_arr[]=_("Value label");
	      $title_arr[]=_("Description");
	      $title_arr[]=_("Rank");
	      $title_arr[]=_("Status");


	      $hdr = html_build_list_table_top ($title_arr);

	      $ia = $ih = 0;
	      $status_stg = array('A' => _("Active"), 'P' => _("Permanent"), 'H' => _("Hidden"));

	      # Display the list of values in 2 blocks : active first
	      # Hidden second
	      while ( $fld_val = db_fetch_array($result) )
		{

		  $item_fv_id = $fld_val['bug_fv_id'];
		  $status = $fld_val['status'];
		  $value_id = $fld_val['value_id'];
		  $value = $fld_val['value'];
		  $description = $fld_val['description'];
		  $order_id = $fld_val['order_id'];

		  $html = '';

		  # keep the rank of the 'None' value in mind if any (see below)
		  if ($value == 100)
		    { $none_rk = $order_id; }

		  # Show the value ID only for system wide fields which
		  # value id are fixed and serve as a guide.
		  if (!$is_project_scope)
		    !$html .='<td>'.$value_id.'</td>';

		  # The permanent values can't be modified (No link)
		  if ($status == 'P')
		    {
		      $html .= '<td>'.$value.'</td>';
		    }
		  else
		    {
		      $html .= '<td><a href="'.$PHP_SELF.'?update_value=1'.
			 '&fv_id='.$item_fv_id.'&field='.$field.
			 '&group_id='.$group_id.'">'.$value.'</A></td>';
		    }

		  $html .= '<td>'.$description.'&nbsp;</td>'.
		     '<td align="center">'.$order_id.'</td>'.
		     '<td align="center">'.$status_stg[$status].'</td>';

		  if ($status == 'A' || $status == 'P')
		    {
		      $html = '<tr class="'.
			 utils_get_alt_row_color($ia) .'">'.$html.'</tr>';
		      $ia++;
		      $ha .= $html;
		    }
		  else
		    {
		      $html = '<tr class="'.
			 utils_get_alt_row_color($ih) .'">'.$html.'</tr>';
		      $ih++;
		      $hh .= $html;
		    }

		}

	      #Display the list of values now
	      if ($ia == 0)
		{
		  $hdr = '<p>'._("No Active value for this field. Create one or reactivate a hidden value (if any)").'</p>'.$hdr;
		}
	      else
		{
		  $ha = '<tr><td colspan="4"><center><b>'._("---- ACTIVE VALUES ----").'</b></center></tr>'.$ha;
		}
	      if ($ih)
		{
		  $hh = '<tr><td colspan="4"> &nbsp;</td></tr>'.
		     '<tr><td colspan="4"><center><b>'._("---- HIDDEN VALUES ----").'</b></center></tr>'.$hh;
		}

	      print $hdr.$ha.$hh.'</table>';

	    }
	  else
	    {
	      printf ("\n<h3>"._("No values defined yet for %s").'</h3>',trackers_data_get_label($field));
	    }


	  # Only show the add value form if this is a project scope field
	  if ($is_project_scope)
	    {

	      print '<br>';
	      print '<h3>'._("Create a new field value").'</h3>';

	      if ($ih)
		{
		  print '<p>'._("Before you create a new value make sure there isn't one in the hidden list that suits your needs.").'</p>';
		}

	      print '
      <form action="'.$PHP_SELF.'" method="post">
      <input type="hidden" name="post_changes" value="y">
      <input type="hidden" name="create_value" value="y">
      <input type="hidden" name="list_value" value="y">
      <input type="hidden" name="field" value="'.$field.'">
      <input type="hidden" name="group_id" value="'.$group_id.'">
      <p><b>'._("Value:").'</b>
      <input type="text" name="value" value="" size="30" maxlength="60">
      &nbsp;&nbsp;
      <b>'._("Rank:").'</b>
      <input type="text" name="order_id" value="" size="6" maxlength="6">';

	      if (isset($none_rk))
		{
		  print "&nbsp;&nbsp;<b> (must be &gt; $none_rk)</b><br></p>";
		}

	      print '
      <p>
      <b>'._("Description:").'</b> ('._("optional").')<br>
      <textarea name="description" rows="4" cols="65" wrap="hard"></textarea></p>
      <p>
      <input type="submit" name="submit" value="Submit"></p>
      </form>';

	    }
	}
      else
	{

	  print '<h3>';
	  printf (_("The Bug field you requested '%s' is not used by your project or you are not allowed to customize it"),$field);
	  print '</h3>';
	}


    }
  else if ($update_value)
    {
      # Show the form to update an existing field_value
      # Display the List of values for a given bug field

      trackers_header_admin(array ('title'=>_("Update Field Values")));

      # Get all attributes of this value
      $res = trackers_data_get_field_value($fv_id);

      print '<form action="'.$PHP_SELF.'" method="post">
      <input type="hidden" name="post_changes" value="y">
      <input type="hidden" name="update_value" value="y">
      <input type="hidden" name="list_value" value="y">
      <input type="hidden" name="fv_id" value="'.$fv_id.'">
      <input type="hidden" name="field" value="'.$field.'">
      <input type="hidden" name="group_id" value="'.$group_id.'">
      <p><b>'
	._("Value").':</b><br>
      <input type="text" name="value" value="'.db_result($res,0,'value').'" size="30" maxlength="60">
      &nbsp;&nbsp;
      <b>'
	._("Rank:").'</b>
      <input type="text" name="order_id" value="'.db_result($res,0,'order_id').'" size="6" maxlength="6">
      &nbsp;&nbsp;
      <b>'
	._("Status").':</b>
      <select name="status">
	   <option value="A">'
	._("Active").'</option>
	   <option value="H"'.((db_result($res,0,'status') == 'h') ? ' selected':'').'>'
	._("Hidden").'</option>
      </select>
      <p>
      <b>'._("Description:").'</b> ('
	._("optional").')<br>
      <textarea name="description" rows="4" cols="65" wrap="soft">'.db_result($res,0,'description').'</textarea></p>
      <p>
      <input type="submit" name="submit" value="'._("Submit").'"></p>';


    }
  else if ($create_canned)
    {
      /*
	  Show existing responses and UI form
      */
      trackers_header_admin(array ('title'=>_("Create/Modify Canned Responses")));

      $sql="SELECT bug_canned_id,title,body FROM ".ARTIFACT."_canned_responses WHERE group_id='$group_id'";
      $result=db_query($sql);
      $rows=db_numrows($result);

      if($result && $rows > 0)
	{
	  /*
	      Links to update pages
	  */
	  print "\n<h3>"._("Existing Responses:").'</h3><p>';

	  $title_arr=array();
	  $title_arr[]=_("Title");
	  $title_arr[]=_("Body (extract)");

	  print html_build_list_table_top ($title_arr);

	  for ($i=0; $i < $rows; $i++)
	    {
	      print '<tr class="'. utils_get_alt_row_color($i) .'">'.
		'<td><a href="'.$PHP_SELF.'?update_canned=1&amp;item_canned_id='.
		db_result($result, $i, 'bug_canned_id').'&amp;group_id='.$group_id.'">'.
		db_result($result, $i, 'title').'</A></TD>'.
		'<td>'.substr(db_result($result, $i, 'body'),0,160).
		'<b>...</b></td></tr>';
	    }
	  print '</table>';

	}
      else
	{
	  print "\n<h3>"._("No canned bug responses set up yet").'</h3>';
	}
      /*
	  Escape to print the add response form
      */

      print '<h3>'._("Create a new response").'</h3>
     <p>
     '._("Creating generic quick responses can save a lot of time when giving common responses.").'</p>
     <p>
     <form action="'.$PHP_SELF.'" method="post">
     <input type="hidden" name="create_canned" value="y">
     <input type="hidden" name="group_id" value="'.$group_id.'">
     <input type="hidden" name="post_changes" value="y">
     <b>'._("Title:").'</b><br>
     <input type="text" name="title" value="" size="50" maxlength="50"></p>
     <p>
     <b>'._("Message Body:").'</b><br>
     <textarea name="body" rows="20" cols="65" wrap="hard"></textarea></p>
     <p>
     <input type="submit" name="submit" value="'._("Submit").'"></p>
     </form>';



    }
  else if ($update_canned)
    {
      /*
	  Allow change of canned responses
      */
      trackers_header_admin(array ('title'=>_("Modify Canned Response")));

      #	print '<h2>'._("Modify Canned Response").'</h2>';

      $sql="SELECT bug_canned_id,title,body FROM ".ARTIFACT."_canned_responses WHERE ".
	 "group_id='$group_id' AND bug_canned_id='$item_canned_id'";

      $result=db_query($sql);

      if (!$result || db_numrows($result) < 1)
	{
	  print "\n<h2>"._("No such response!").'</h2>';
	}
      else
	{
	  /*
	      Escape to print update form
	  */

	  print '<p>'
	    ._("Creating generic messages can save you a lot of time when giving common responses.").'</p>
      <p>
      <form action="'.$PHP_SELF.'" method="post">
      <input type="hidden" name="update_canned" value="y">
      <input type="hidden" name="group_id" value="'.$group_id.'">
      <input type="hidden" name="item_canned_id" value="'.$item_canned_id.'">
      <input type="hidden" name="post_changes" value="y">
      <b>'._("Title").':</b><br>
      <input type="text" name="title" value="'.db_result($result,0,'title').'" size="50" maxlength="50"></p>
      <p>
      <b>'._("Message Body:").'</b><br>
      <textarea name="body" rows="20" cols="65" wrap="hard">'.db_result($result,0,'body').'</textarea></p>
      <p>
      <input type="submit" name="submit" value="Submit"></p>
      </form>';

	}

    }
  else
    {

      trackers_header_admin(array ('title'=>_("Field Values Management")));

      print '<h3>'._("List of all Available Fields").'</h3>';
      print '<p>('._("Click to modify").')</p>';

      # Loop through the list of all used fields that are project manageable
      $i=0;
      $title_arr=array();
      $title_arr[]=_("Field Label");
      $title_arr[]=_("Description");
      $title_arr[]=_("Scope");
      print html_build_list_table_top ($title_arr);
      while ( $field_name = trackers_list_all_fields() )
	{

	  if ( trackers_data_is_select_box($field_name)
	       && ($field_name != 'submitted_by')
	       && ($field_name != 'assigned_to')
	       && trackers_data_is_used($field_name) )
	    {

	      $scope_label  = (trackers_data_is_project_scope($field_name)?
			       _("Project"):_("System"));

	      print '<tr class="'. utils_get_alt_row_color($i) .'">'.
		'<td><a href="'.$PHP_SELF.'?group_id='.$group_id.'&list_value=1&field='.$field_name.'">'.trackers_data_get_label($field_name).'</a></td>'.
		"\n<td>".trackers_data_get_description($field_name).'</td>'.
		"\n<td>".$scope_label.'</td>'.
		'</tr>';
	      $i++;
	    }
	}

      # Now the special canned response field
      print '<tr class="'. utils_get_alt_row_color($i) .'">';
      print "<td><a href=\"$PHP_SELF?group_id=$group_id&amp;create_canned=1\">"._("Canned Responses").'</a></td>';
      print "\n<td>"._("Create or Change generic quick response messages for the bug tracking tool. Theses pre-written messages can then be used to quickly reply to bug submission.").' </td>';
      print "\n<td>"._("Project").'</td></tr>';
      print '</table>';
    }

  trackers_footer(array());

}
else
{

  #browse for group first message
  if (!$group_id)
    {
      exit_no_group();
    }
  else
    {
      exit_permission_denied();
    }

}

?>