<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: add.php,v 1.18 2004/06/08 23:37:01 beuc Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


if (ARTIFACT == "task" && !member_check(0, $group_id))
    {
      # Disallow posting task to non-member of a project
      # FIXME: In the future, it should be configure on a tracker basis
      exit_error(_("You are not member of this project, you cannot submit task"));
    }

trackers_header(array('title'=>_("Submit")));
$fields_per_line=2;
$max_size=40;

# First display the message preamble
$res_preamble = db_query("SELECT ".ARTIFACT."_preamble FROM groups WHERE group_id=$group_id");

print utils_unconvert_htmlspecialchars(db_result($res_preamble,0,ARTIFACT.'_preamble'));
print '<h3>'._("Details").'</h3>';

# Beginning of the submission form with fixed fields
print '<form action="'.$PHP_SELF.'" method="post" enctype="multipart/form-data" name="trackers_form">
	<input type="hidden" name="func" value="postadditem">
	<input type="hidden" name="group_id" value="'.$group_id.'">
	<table cellpadding="0">
	<tr><td valign="top" colspan="'.(2*$fields_per_line).'">
        </td></tr>';



# Now display the variable part of the field list (depend on the project)

$i=0;
$is_trackeradmin = member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2');

while ($field_name = trackers_list_all_fields()) 
{

  # if the field is a special field (except summary and original description)
  # or if not used by this project  then skip it. 
  # Plus only show fields allowed on the bug submit_form 
  if ((!trackers_data_is_special($field_name) || $field_name=='summary' || $field_name=='details') &&
      trackers_data_is_used($field_name)) 
    {
      
      if  (($is_trackeradmin && trackers_data_is_showed_on_add_members($field_name)) ||
	   (!$is_trackeradmin && trackers_data_is_showed_on_add($field_name)) ||
	   (!user_isloggedin() && trackers_data_is_showed_on_add_nologin($field_name)) ) 
	{
	  
	  # display the bug field with its default value
	  # if field size is greatest than max_size chars then force it to
	  # appear alone on a new line or it won't fit in the page

	  # We allow people to make urls with predefined values,
	  # if the values are in the url, we override the default value.
	  if (!$$field_name)
	    { $field_value = trackers_data_get_default_value($field_name); }
	  else
	    { $field_value = $$field_name; }

	  list($sz,) = trackers_data_get_display_size($field_name);
	  $label = trackers_field_label_display($field_name,$group_id,false,false);
	  $value = trackers_field_display($field_name,$group_id,$field_value,false,false);
	  $star = (trackers_data_is_empty_ok($field_name) ? '':'<font class="error"> *</font>');
	  
	  if ($sz > $max_size) 
	    {
	      print "\n<tr>".
		'<td valign="middle">'.$label.'</td>'.
		'<td valign="middle" colspan="'.(2*$fields_per_line-1).'">'.
		$value.$star.'</TD>'.		      
		"\n</TR>";
	      $i=0;
	    } 
	  else 
	    {
	      print ($i % $fields_per_line ? '':"\n<tr>");
	      print '<td valign="middle">'.$label.'</td>'.
		'<td valign="middle">'.$value.$star.'</td>';
	      $i++;
	      print ($i % $fields_per_line ? '':"\n</tr>");
	    }
	}
    }
}


print '</table>';
	     
#  possibility of attachment


print '<p></p>';
print '<h3>'._("Attached Files").'</h3>';
print '<font class="preinput"> '._("Attach File:").'</font><br>
      &nbsp;&nbsp;&nbsp;<input type="file" name="input_file" size="40">
      <br>
      <font class="preinput">'._("File Description:").'</font><br>
      &nbsp;&nbsp;&nbsp;<input type="text" name="file_description" size="60" maxlength="255">
      </p><p>';
	  

# Cc addresses
if (user_isloggedin())
{
  
  print '<p></p>';
  print '<h3>'._("Mail Notification CC").'</h3>';
  
  printf (_("(Note: for %s users, you can use their login name rather than their email addresses.)"), $GLOBALS['sys_name']);
  
  print '<p><font class="preinput">'
    ._("Add CC:").'</font><br>&nbsp;&nbsp;&nbsp;<input type="text" name="add_cc" size="40">&nbsp;&nbsp;&nbsp;
        <br>
        <font class="preinput">'
    ._("Comment:").'</font><br>&nbsp;&nbsp;&nbsp;<input type="text" name="cc_comment" size="40" maxlength="255">';
  print '<p></p>';
}


print '<p></p>';
print '<p><font class="warn">'._("Did you check to see if this item has already been submitted?").'</font></p>';
print '<p align="center">';
print '<input type="submit" name="submit" class="bold" value="'._("Submit").'">';
print '</p>';
print '</form>';


trackers_footer(array());

?>
