<?php
# This file is part of the Savane project
# <http:#gna.org/projects/savane/>
#
# $Id: index.php,v 1.47 2004/08/21 23:12:44 beuc Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require "../include/pre.php";    

site_user_header(array('toptab'=>'account'));

# get global user vars
$res_user = db_query("SELECT * FROM user WHERE user_id=" . user_getid());
$row_user = db_fetch_array($res_user);

# we get site-specific content
utils_get_content("account/index_intro");

print '<table width="100%" border="0"><tr><td valign="top" width="50%">';

################### Infos

print $HTML->box1_top('Information');


print '<h3>'._("Account #").''.$row_user['user_id'].'</h3>';
print '<dd>'._("Your login is").' <b>'.$row_user['user_name'].'</b>.<br>'._("You are member since").' <b>'.format_date($sys_datefmt,$row_user['add_date']).'</b>.</dd>';

print '<h3><a href="change.php?item=realname">'._("Change Real Name").'</a></h3>';
print '<dd>'._("Set to").' <b>'.$row_user['realname'].'</b>.</dd>';

print '<h3><A href="change.php?item=email">'._("Change Email Address").'</a></h3>';
print '<dd>'._("Set to").' <b>'.$row_user['email'].'</b>.</dd>';

print '<h3><A href="change.php?item=timezone">'._("Change Timezone").'</a></h3>';
print '<dd>'._("Set to").' <b>'.$row_user['timezone'].'</b>.</dd>';

print '<h3><A href="change.php?item=gpgkey">'._("Edit GPG Key").'</a></h3>';
print '<dd>'._("You can add here your (ASCII) public key or your fingerprint").'.</dd>';

print '<h3><A href="'.$GLOBALS['sys_home'].'people/editprofile.php">'._("Edit Resume and Skills").'</a></h3>';
print '<dd>'._("You can give details about your experience and skills").'.</dd>';

print '<h3><A href="'.$GLOBALS['sys_home'].'users/'.$row_user['user_name'].'">'._("View your profile").'</a></h3>';
print '<dd>'._("View the information available to others users").'.</dd>';

print $HTML->box1_bottom();

print '</td><td valign="top" WIDTH="50%">';


############## Passwd / SSH

print $HTML->box1_top('Authentication');
print '<h3><a href="change.php?item=password">'._("Change Password").'</a></h3><dd>';
utils_get_content("account/index_passwd");
print '</dd>';
# get shared key count from db                                         
$expl_keys = explode("###",$row_user['authorized_keys']);

# If the last 'key' is empty, then it is because of a trailing separator;
# so do not count it
$keynum = (sizeof($expl_keys));
if ($expl_keys[$keynum-1] == "")
  $keynum--;

print '<h3><a href="editsshkeys.php">';
if ($keynum > 0) 
{ printf(gettext("Edit the %d SSH Public Key(s) Registered"),($keynum)); }
else
{ print gettext("Register your SSH Public Key"); }

print '</a></h3><dd>';
utils_get_content("account/index_ssh");
print '</dd>';
print $HTML->box1_bottom();
print '<br><br>';

################### Prefs

print $HTML->box1_top('Preferences');

print '<form action="updateprefs.php" method="post">';
print '<h3>'._("Theme / Color scheme").'';

html_select_theme_box("user_theme", $row_user['theme']);

print '</h3>';
print '<dd>'._("Note that some themes --not the default one-- use CSS massively and can not be used without aesthetic troubles with browsers that do not offer good CSS support (such as Netscape 4.x or MSIE)").'.</dd>';

if ("rotate"==$row_user['theme'])
{
  print '<h3><input type="checkbox" name="theme_rotate_jump" value="1"> '._("Jump to the next theme").'';
  print '<input type="hidden" name="theme_rotate_numeric" value="'. $HTTP_COOKIE_VARS["SV_THEME_ROTATE_NUMERIC"] .'"></h3>';
}

print '<h3><a href="change_notifications.php">'._("Edit your Personal Notification Settings").'</a></h3>';
print '<dd>'._("You can specify in which cases you want to receive email notification from the trackers.").'.</dd>';

print '<h3><input type="checkbox" name="form_mail_hide" value="1" '.($row_user['email_hide'] ? 'checked':'').'> '._("Hide email address from your account information").'</h3>';

print '<dd>'._("So the only way to get in touch with you would be using the form available in your account information when logged in. It is generally a bad idea to choose this option, especially if you are a project admin").'.</dd>';

# 2004-02-07 yeupou@gnu.org:
#   use cvsadmin is no longer used in  the backend
#print '<h3><input type="checkbox"  name="form_use_cvsadmin" value="1" '.($row_user['use_cvsadmin'] ? 'checked':'').'> '._("Enable CVS admin commands").' </h3>';
#print '<dd>'._("Check the <http href=\"http://www.loria.fr/~molli/cvs/doc/cvs_16.html#SEC113\">CVS manual</a> for more information").'.</dd>';

print '<p align=center><input type="submit" name="Update" value="Update">';
print '</form>';


print $HTML->box1_bottom();

print '</td></table>';

$HTML->footer(array());
?>
