#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_www.pl,v 1.4 2004/01/31 00:56:17 yeupou Exp $
#
#
#
# Copyright (C) Loic Dachary <loic@gnu.org>, 2001
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# http://sourceforge.net
#
#

#use strict;
#use warnings;

use Getopt::Long;
use Savannah;

my($prefix) = "$sys_miscdir";
my($verbose) = 0;
my($user) = "";
my($password) = "";
my($getopt);
my($help);

eval {
    $getopt = GetOptions("verbose+" => \$verbose,
			 "user=s" => \$user,
			 "password=s" => \$password,
			 "help" => \$help);
};

if($help || !$getopt) {
    print STDERR <<EOF;
usage: $0 [--user=<user> --password=<password>] [--help] [--verbose]

        Generate and publish informations for GNU webmasters.

	--user=<user>		MySQL user name
	--password=<password>	MySQL password for user
	--verbose		increase verbosity level
	--help			print this help

Author: loic\@gnu.org
EOF
 exit(1);
}

$user = "--user=$user" if($user);
$password = "--password=$password" if($password);

$ENV{'CVS_RSH'} = 'ssh';

my($dir) = "$prefix/src/server/standards";
my($file) = "$dir/www2savannah.html";
open(MAP, ">$file") or die "cannot open $file for writing : $!";
print MAP "List of the areas of www.gnu.org for which each project registered
on Savannah has write access.<P><UL>\n";

open(LIST, "mysql $user $password -Ne \"SELECT group_name, unix_group_name, html_cvs, group_id  FROM groups WHERE groups.status = 'A' AND groups.is_public != 0 AND html_cvs != '' ORDER BY html_cvs  \" $sys_dbname|") or die "mysql $user $password failed";
while(<LIST>) {
    chop;
    my($group_name, $unix_group_name, $html_cvs, $group_id) = split("\t", $_);

    # yeupou@gnu.org 2002-08-05
    # wow, with group_typ stuff, this would be more complicated, but I'm not sure
    # it's usefull for now
    # I let it as it is.
    print MAP "<LI> <a href=\"http://www.gnu.org$html_cvs\">$html_cvs</a> $group_name (<a HREF=\"http://savannah.gnu.org/project/memberlist.php?group_id=$group_id\">who's in charge</a>, <a HREF=\"http://savannah.gnu.org/projects/$unix_group_name/\">project</a>)\n";

}
print MAP "</UL>\n";
close(MAP);
close(LIST);

chdir($dir) or die "cannot chdir $dir : $!";
system("cvs -q diff www2savannah.html ; cvs -q commit -m 'Update map of www directories to savannah projects' www2savannah.html");
