<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: approve.php,v 1.6 2004/03/13 18:22:06 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#                          Mathieu Roy <yeupou--at--gnu.org>
#
#  Copyright 2004      (c) ...
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require '../include/pre.php';

# This page can be used to manage the whole news system for a server
# or news for a project.
# That's why, when required, we test if group_id = sys_group_id.

if ($group_id && member_check(0, $group_id,'N3'))
{

  # Modifications are made to the database
  if ($post_changes && $approve)
    {

      if ($group_id != $GLOBALS['sys_group_id'] &&
	  $status != 0 && $status != 4)
	{
	  # Make sure that an item accepted for front page is not modified
	  $status=0;
	}

      if (user_ismember($GLOBALS['sys_group_id'],'A') &&
	  $group_id == $GLOBALS['sys_group_id'])
	{
	  $sql="UPDATE news_bytes SET is_approved='".$status."', date='".time()."', ".
	     "summary='".htmlspecialchars($summary)."'  WHERE id='$id' AND group_id='$for_group_id'";
	}
      else
	{
	  if ($status == 0)
	    {
	      $sql="UPDATE news_bytes SET is_approved='0', summary='".htmlspecialchars($summary)."', ".
		 "details='".htmlspecialchars($details)."' WHERE id='$id' AND group_id='$group_id'";
	    }
	  elseif ($status == 4)
	    {
	      $sql="UPDATE news_bytes SET is_approved='4', summary='".htmlspecialchars($summary)."', ".
		 "details='".htmlspecialchars($details)."' WHERE id='$id' AND group_id='$group_id'";
	    }
	}

      $result=db_query($sql);

      if (!$result || db_affected_rows($result) < 1)
	{
	  fb(_("ERROR doing group update"));
	}
      else
	{
	  fb(_("Project NewsByte Updated."));
	}
      /*
	   Show the list_queue
      */
      $approve='';
      $list_queue='y';

    }

  # Begin HTML
  site_project_header(array('title'=>_("Manage"),
			    'group'=>$group_id,
			    'toptab'=>'news'));

  # Form to make modifications to an existing item, to submit one
  if ($approve)
    {

      if (member_check(0, $GLOBALS['sys_group_id'], 'A') &&
	  $group_id == $GLOBALS['sys_group_id'])
	{
	  $sql="SELECT groups.unix_group_name,news_bytes.* ".
	     "FROM news_bytes,groups WHERE id='$id' ".
	     "AND news_bytes.group_id=groups.group_id ";
	}
      else
	{
	  $sql="SELECT * FROM news_bytes WHERE id='$id' AND group_id='$group_id'";
	}

      $result=db_query($sql);
      if (db_numrows($result) < 1)
	{
	  print '<h2 class="error">'._("Error - none found").'</h2>';
	  news_footer(array());
	  exit;
	}

      print '
		<form action="'.$PHP_SELF.'" method="post">
		<input type="hidden" name="id" value="'.db_result($result,0,'id').'">';
      printf (_("Approve a NewsByte for %s submitted by %s"),'<a href="'.$GLOBALS['sys_home'].'projects/'.db_result($result,0,'unix_group_name').'/">'.group_getname(db_result($result,0,'group_id')).'</a>',utils_user_link(user_getname(db_result($result,0,'submitted_by'))));
      echo '<br>
		<input type="hidden" name="approve" value="y">
		<input type="hidden" name="post_changes" value="y">
                <br>';

      if (user_ismember($GLOBALS['sys_group_id'],'A') && $group_id == $GLOBALS['sys_group_id'])
	{
	  print '<input type="radio" name="status" value="1">';
	  printf (_("Approve For %s' Front Page").'<br>',$GLOBALS['sys_name']);
	  print '<input type="radio" name="status" value="0" checked> '._("Do Nothing").'<br>';
	  print '<input type="radio" name="status" value="2"> '._("Refuse").'<br>';
	  print '<input type="hidden" name="for_group_id" value="'.db_result($result,0,'group_id').'">';
	  print '<input type="hidden" name="group_id" value="'.$GLOBALS['sys_group_id'].'">';
	} else {
	  print '<input type="radio" name="status" value="0" checked> '._("Display").'<br>';
	  print '<input type="radio" name="status" value="4"> '._("Delete").'<br>';
	  print '<input type="hidden" name="group_id" value="'.db_result($result,0,'group_id').'">';
	}

      print '<b>'
	._("Subject").':</b><br>
		<input type="text" name="summary" value="'.db_result($result,0,'summary').'" size="75" MAXLENGTH="80"><br>
		<b>'
	._("Details:").'</b><br>
		<textarea name="details" ROWS="20" COLS="75" WRAP="SOFT">'.db_result($result,0,'details').'</textarea><p>';
      printf (_("Note: If this item is on the %s home page and you edit it, it will be removed from the home page."),$GLOBALS['sys_name']);
      print '<br>
		<input type="submit" name="submit" value="'._("submit").'"></p>
		</form>';

    }
  else
    {
      # No item selected

      $old_date=(time()-(86400*7));

      # Firstly, we show item that require approval
      #   - if site news: it has to be already approved projects (0)
      #     or project submitted on the system site project
      #   - if project news: it has to be proposed news (5)
      if (user_ismember($GLOBALS['sys_group_id'],'A') && $group_id == $GLOBALS['sys_group_id'])
	{
	  $sql="SELECT * FROM news_bytes WHERE is_approved=0 AND date > '$old_date' OR group_id='$sys_group_id'";
	}
      else
	{
	  $sql="SELECT * FROM news_bytes WHERE is_approved=5 AND date > '$old_date' AND group_id='$group_id'";
	}

      $result=db_query($sql);
      $rows=db_numrows($result);

      if ($rows < 1)
	{
	  print '<p>'._("No queued items found").'</p>';
	}
      else
	{
	  print '<p>'._("These news items were submitted and need approval:").'
			<ul>';
	  for ($i=0; $i<$rows; $i++)
	    {
	      print '<li><a href="?approve=1&amp;id='.db_result($result,$i,'id');

	      if ($group_id == $GLOBALS['sys_group_id']) {
		print '&amp;group='.$GLOBALS['sys_unix_group_name'];
	      }
	      else
		{
		  print '&amp;group_id='.db_result($result,$i,'group_id');
		}


	      print '">'.
		db_result($result,$i,'summary').'</a></li>';
	    }
	  print '</ul>';
	}

      # Secondly, we show deleted items for this week

      if (user_ismember($GLOBALS['sys_group_id'],'A') && $group_id == $GLOBALS['sys_group_id'])
	{
	  $sql="SELECT * FROM news_bytes WHERE is_approved=2 AND date > '$old_date'";
	}
      else
	{
	  $sql="SELECT * FROM news_bytes WHERE is_approved=4 AND date > '$old_date' AND group_id='$group_id'";
	}

      $result=db_query($sql);
      $rows=db_numrows($result);

      if ($rows < 1)
	{
	  print '<p>'
	    ._("No deleted items found for this week").'</p>';
	}
      else
	{
	  if (user_ismember($GLOBALS['sys_group_id'],'A') && $group_id == $GLOBALS['sys_group_id'])
	    {
	      print '<p>'
		._("These items were refused this past week:").'</p>';
	    }
	  else
	    {
	      print '<p>'
		._("These items were deleted this past week:").'</p>';
	    }

	  print '<ul>';
	  for ($i=0; $i<$rows; $i++)
	    {
	      print '<li><a href="?approve=1&amp;group='.$group_name.'&amp;id='.db_result($result,$i,'id').'">'.db_result($result,$i,'summary').'</a></li>';
	    }
	  print '</ul>';
	}

      # Finally, we show approved items for this week
      if (user_ismember($GLOBALS['sys_group_id'],'A') && $group_id == $GLOBALS['sys_group_id'])
	{
	  $sql="SELECT * FROM news_bytes WHERE is_approved=1 AND date > '$old_date'";
	}
      else
	{
	  $sql="SELECT * FROM news_bytes WHERE is_approved=0 AND date > '$old_date' AND group_id='$group_id'";
	}

      $result=db_query($sql);
      $rows=db_numrows($result);

      if ($rows < 1)
	{
	  print '<p>'
	    ._("No approved for the front page items found for this week").'</p>';
	}
      else
	{
	  print '<p>'
	    ._("These items were approved this past week:").'</p><ul>';
	  for ($i=0; $i<$rows; $i++) {
	    print '<li><a href="?approve=1&amp;group='.$group_name.'&amp;id='.db_result($result,$i,'id').'">'.db_result($result,$i,'summary').'</a></li>';
	  }
	  print '</ul>';
	}

    }

  site_project_footer(array());

}
else
{

  exit_error(_("Permission Denied"),_("You have to be an admin on the project you are editing."));

}

?>
