<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: i18n.php,v 1.9 2004/03/13 18:22:06 yeupou Exp $
#
#  Copyright 2003-2004 (c) Stphane Urbanovski <s.urbanovski@ac-nancy-metz.fr>
#                          Mathieu Roy <yeupou--at--gnu.org>              
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# Description : This script is used to configure the locale using if possible 
# the user's navigator preferences. The locale is used by gettext and strftime
# functions.

# Get the user's prefered language from the navigator sended headers :
$navigatorLanguages = explode(",",getenv("HTTP_ACCEPT_LANGUAGE"));

# Set the default language :
$locale = $GLOBALS['sys_default_locale'];

# Table of supported languages :
# "lang" => "associated prefered sublanguage"
$supportedLanguages = array(
			    "de"	=> "DE",
			    "de_DE"	=> "DE",
			    "en"	=> "US",
			    "es"	=> "ES",
			    "es_ES"	=> "ES",
			    "fr"	=> "FR",
			    "fr_FR"	=> "FR",
			    "ja"	=> "JA",
			    "ko"	=> "KO",
			    "pt"	=> "BR",
			    "pt_BR"     => "BR"
			    );

# Try to find the best supported language from user's navigator preferences :
while (list(, $lng) = each ($navigatorLanguages)) {
  
  $lng = trim($lng);
  $curlocale = strtolower(substr($lng,0,2));
  if  (substr($lng,2,1) == "-") {
    $sublocale = $curlocale."_".strtoupper(substr($lng,3,2));
    if ( isset($supportedLanguages[$sublocale] )) {
      $locale = $curlocale."_".$supportedLanguages[$sublocale];
      break; 
    }
  } 
  if ( isset($supportedLanguages[$curlocale] )) { 
    $locale = $curlocale."_".$supportedLanguages[$curlocale];
    break; 
  }
  
}

# Set the locale used by gettext() and strftime() functions :
setlocale(LC_ALL, $locale);

# Gettext (i18n) configs :
textdomain('savannah');


#print "[".$locale.",".setlocale(LC_ALL,0)."]"; //debug

?>
