<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: features_boxes.php,v 1.40 2004/03/13 18:22:06 yeupou Exp $
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation
#                          Mathieu Roy <yeupou--at--gnu.org>
#
#  Copyright 2004      (c) ...
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


function show_features_boxes() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_features_boxes() ';
  GLOBAL $HTML;

  $return .= $HTML->box1_top(sprintf(_("%s Statistics"),$GLOBALS['sys_name']),0);


  $return .= show_sitestats();

  $result = db_query("SELECT type_id,name FROM group_type ORDER BY type_id");
  while ($eachtype = db_fetch_array($result)) 
    {
      $title = sprintf(_("Newest %s Projects"),$eachtype['name']);
      $return .= $HTML->box1_middle($title);
      $return .= '<font class="small">';
      $return .= show_newest_projects($group_type=$eachtype['type_id']);
      $return .= '<br><a href="'.$GLOBALS['sys_home'].'search/?type_of_search=soft&amp;words=%%%&amp;type='.$eachtype['type_id'].'" class="center">[';
      $return .= sprintf( _("all %s projects"),$eachtype['name'] ) ;
      $return .= ']</a></font>';
    }
  $return .= $HTML->box1_bottom(0);
  return $return;
}

function stats_get_generic($sql) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':stats_get_generic($sql) ';
  $res_count = db_query($sql);
  if (db_numrows($res_count) > 0) 
    {
      $row_count = db_fetch_array($res_count);
      return $row_count['count'];
    } 
  else 
    {
      return _("Error");
    }
}

function stats_getprojects_active() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':stats_getprojects_active() ';
  return stats_get_generic("SELECT count(*) AS count FROM groups WHERE status='A'");
}

function stats_getprojects_bytype_active($type_id) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':stats_getprojects_bytype_active($type_id) ';
  return stats_get_generic("SELECT count(*) AS count FROM groups WHERE status='A' AND type='$type_id'");
}

function stats_getprojects_pending() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':stats_getprojects_pending() ';
  return stats_get_generic("SELECT count(*) AS count FROM groups WHERE status='P'");
}

function stats_getprojects_total() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':stats_getprojects_total() ';
  return stats_get_generic("SELECT count(*) AS count FROM groups WHERE status='A' OR status='H'");
}

function stats_getusers() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':stats_getusers() ';
  return stats_get_generic("SELECT count(*) AS count FROM user WHERE status='A'");
}

function stats_getpageviews_total() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':stats_getpageviews_total() ';
  return stats_get_generic("SELECT SUM(site_views)+SUM(subdomain_views) AS site FROM stats_site");
}


function show_sitestats() 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_sitestats() ';
  $return .= '<font class="small">';
  $return .= _("Hosted Projects").': <b>'.number_format(stats_getprojects_active()).'</b>';
  $result = db_query("SELECT type_id,name FROM group_type ORDER BY type_id");
  $return .= '<font class="small">';
  while ($eachtype = db_fetch_array($result)) 
    {
      $return .= '<br>';	  
      $return .= '&nbsp;&nbsp;- <a href="'.$GLOBALS['sys_home'].'search/?type_of_search=soft&amp;words=%%%&amp;type='.$eachtype['type_id'].'" class="center">';
      $return .= number_format(stats_getprojects_bytype_active($eachtype['type_id']));
      $return .= ' '.$eachtype['name'].'</a>';
    }
  $return .= '<br>&nbsp;&nbsp;+ '.number_format(stats_getprojects_pending()).' '._("Registrations Pending").'</font>';
  $return .= '<br>'._("Registered Users").': <b>'.number_format(stats_getusers()).'</b>';
  $return .= '</font>';
  return $return;
}

function show_newest_projects($group_type) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_newest_projects($group_type) ';
  $sql =	"SELECT group_id,unix_group_name,group_name,register_time FROM groups " .
     "WHERE is_public=1 AND status='A' AND type=$group_type " .
     "ORDER BY register_time DESC LIMIT 10";
  $res_newproj = db_query( $sql );
  $sql_type = "SELECT type_id,base_host FROM group_type WHERE type_id=$group_type";
  $res_newproj_type = db_query($sql_type);
  $row_newproj_type = db_fetch_array($res_newproj_type);
  if ($row_newproj_type['base_host']) 
    {
      $base_url = 'http'.(session_issecure()?'s':'').'://'.$row_newproj_type['base_host'];
    } 

  if (!$res_newproj || db_numrows($res_newproj) < 1) 
    {
      return db_error();
    } 
  else
    {
      while ( $row_newproj = db_fetch_array($res_newproj) ) 
	{
	  if ( $row_newproj['register_time'] ) 
	    {
	      $return .= "(" . date("m/d",$row_newproj['register_time'])  . ") "
		 . '<a href="'.$base_url.$GLOBALS['sys_home']."projects/$row_newproj[unix_group_name]/\">"
		 . $row_newproj[group_name].'</a><br>';
	    }
	}
    }
  return $return;
}


?>
