<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: editprofile.php,v 1.16 2004/02/11 14:04:20 toddy Exp $
#
#
# Copyright 1999-2000 (c) The SourceForge Crew
#
#
#  Copyright 2000-2003 (c) Free Software Foundation
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
#
#

require "../include/pre.php";

if ( ! user_isloggedin()) {
  exit_not_logged_in();
}

if ($update_profile) {
  /*
		update the job's description, status, etc
  */
  if (!$people_resume) {
    #required info
    fb(_("Error").' '._("Missing info: fill in all required fields"));

  } else {
    $people_resume = utils_unconvert_htmlspecialchars($people_resume);
    $sql="UPDATE user SET people_view_skills='$people_view_skills',people_resume='$people_resume' ".
       "WHERE user_id='".user_getid()."'";
    $result=db_query($sql);
    if (!$result || db_affected_rows($result) < 1) {
      fb(_("User update FAILED"));
      echo db_error();
    } else {
      fb(_("User updated successfully"));
    }
  }

} else if ($add_to_skill_inventory) {
  /*
		add item to job inventory
  */
  if ($skill_id==100 || $skill_level_id==100 || $skill_year_id==100) {
    #required info
    fb(_("Error").' '._("Missing info: fill in all required fields"));

  } else {
    people_add_to_skill_inventory($skill_id,$skill_level_id,$skill_year_id);
  }

} else if ($update_skill_inventory) {
  /*
		Change Skill level, experience etc.
  */
  if ($skill_level_id==100 || $skill_year_id==100  || !$skill_inventory_id) {
    #required info
    fb(_("Error").' '._("Missing info: fill in all required fields"));

  } else {
    $sql="UPDATE people_skill_inventory SET skill_level_id='$skill_level_id',skill_year_id='$skill_year_id' ".
       "WHERE user_id='". user_getid() ."' AND skill_inventory_id='$skill_inventory_id'";
    $result=db_query($sql);
    if (!$result || db_affected_rows($result) < 1) {
      fb(_("User Skill update FAILED:"));
      ' '.db_error();
    } else {
      fb(_("User Skill updated successfully"));
    }
  }

} else if ($delete_from_skill_inventory) {
  /*
		remove this skill from this job
  */
  if (!$skill_inventory_id) {
    #required info
    exit_error(_("error - missing info"),_("Fill in all required fields"));
  }

  $sql="DELETE FROM people_skill_inventory WHERE user_id='". user_getid() ."' AND skill_inventory_id='$skill_inventory_id'";
  $result=db_query($sql);
  if (!$result || db_affected_rows($result) < 1) {
    fb(_("User Skill Delete FAILED:"));
    ' '.db_error();
  } else {
    $feedback .=_("User Skill Deleted successfully");
  }

}

/*
	Fill in the info to edit the profile
*/
site_user_header(array('title'=>_("Edit Your Profile"),'toptab'=>'account'));

#for security, include group_id
$sql="SELECT * FROM user WHERE user_id='". user_getid() ."'";
$result=db_query($sql);
if (!$result || db_numrows($result) < 1) {
  echo db_error();
  fb(_("User fetch FAILED"));
  echo '<h2>'._("No Such User").'</h2>';

} else {
  # we get site-specific content
  utils_get_content("people/editprofile");

  print '<form action="'.$PHP_SELF.'" method="POST"><p>'
    ._("The following option determines if others can see your resume online. If they can't, you can still enter your skills, and search for matching jobs.").'</p>'
    .'<h5>'._("Publicly Viewable:").'</h5>'
    .'<input type="RADIO" name="people_view_skills" value="0" '. ((db_result($result,0,'people_view_skills')==0)?'CHECKED':'') .'> <b>'._("No").'</b><br>'
    .'<input type="RADIO" name="people_view_skills" value="1" '. ((db_result($result,0,'people_view_skills')==1)?'CHECKED':'') .'> <b>'._("Yes").'</b><br>
	<p>'
    ._("Give us some information, either a resume, or an explanation of your experience.").'</p>'
    .'<h5>'._("Resume / Description of Experience:").'</h5>
	<textarea name="people_resume" rows="15" cols="60" wrap="SOFT">'. db_result($result,0,'people_resume') .'</textarea></p>
	<p>'.
    '<input type="SUBMIT" name="update_profile" value="'._("Update Profile").'"></p>
	</form>';

  #now show the list of desired skills
  people_edit_skill_inventory( user_getid() );

  #echo '<form action="'.$GLOBALS['sys_home'].'people/" method="POST"><input type="SUBMIT" name="SUBMIT" value="'._("Finished").'"></form></p>'; 
  echo '<p><a href="'.$GLOBALS['sys_home'].'account/">[ '._("Return to my Account Configuration").' ]</a></p>';
}

site_user_footer(array());

?>
