<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: index.php,v 1.24 2004/01/31 00:56:19 yeupou Exp $
//
//
// Copyright 1999-2000 (c) The SourceForge Crew
//
//
//  Copyright 2000-2003 (c) Free Software Foundation
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
//
//

require '../include/pre.php';

if (!$group_id) 
{
  $group_id = $GLOBALS['sys_group_id'];
}

if (!isset($limit)) 
{ 
  $limit = 10;  
}

$project=project_get_object($group_id);
if (!$project->Uses("news"))
{ exit_error(_("This project has turned off the news tool.")); }
 
site_project_header(array('group'=>$group_id,
			  'toptab'=>'news'));

/* permit to the user to specify something */

print '<form action="'. $PHP_SELF .'" method="get">';
print '<input type="hidden" name="group" value="'.$group_name.'">';
print '<h3>';
printf (_("Print summaries for the %s latest news."), '<input type="text" name="limit" size="4" value="'.$limit.'">');
print '&nbsp;&nbsp;&nbsp;&nbsp;<input type="submit" value="'._("Apply").'"></h3></form>';

print '<br>';


$HTML->box1_top(_("Latest News Approved - With Summaries"));
print news_show_latest($group_id, $limit, "true", $start_from="nolinks");
$HTML->box1_bottom();

/* A box with no summaries, if they are not all already shown */
if ($limit < news_total_number($group_id)) 
{
  print '<br><br>';
  $HTML->box1_top(_("Older News Approved"));
  print news_show_latest($group_id, 0, "false", $start_from=$limit);
  $HTML->box1_bottom();
}

site_project_footer(array());

?>
