<?php
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: index.php,v 1.55 2004/03/04 21:33:14 toddy Exp $
#
#
#  Copyright 1999-2000 (c) The SourceForge Crew
#  Copyright 2000-2003 (c) Free Software Foundation,
#  Copyright 2001-2002 (c) Laurent Julliard, CodeX Team, Xerox
#
#  Copyright 2002-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


require '../include/pre.php';
require_directory("trackers");

if (user_isloggedin())
{

  # Some action to be done ?
  if ($func)
    {
      if ($func == "delwatchee")
	{
	  # Stop watching another user
	  $result = trackers_data_delete_watchees(user_getid(),$watchee_id,$group_id);
	  if (!$result)
	    {
	      fb(_("Unable to remove user from the watched users list, probably a broken URL"));
	    }

	}

      if ($func == "addwatchee")
	{
	  # Stop watching another user
	  $result = trackers_data_add_watchees(user_getid(),$watchee_id,$group_id);
	  if (!$result)
	    {
	      fb(_("Unable to add user in the watched users list, probably a broken URL"));
	    }

	}

      if ($func == "delbookmark")
	{
	  # Remove a bookmark
	  if ($bookmark_id)
	    {
	      bookmark_delete($bookmark_id);
	    }
	}

    }

  # Make sure this page is not cached because
  # it uses the exact same URL for all user's
  # personal page
  header("Cache-Control: no-cache, must-revalidate"); # for HTTP 1.1
  header("Pragma: no-cache");  # for HTTP 1.0

  site_user_header(array('toptab'=>'my'));
  # we get site-specific content
  utils_get_content("my/index");

  if ($feedback)
    {
      echo $feedback;
    }

  echo '<table width="100%" border="0"><tr><td valign="top" width="50%">';
  # Tasks assigned to me
  echo $HTML->box1_top(_("My Tasks"));
  my_artifact_items("task");
  echo $HTML->box1_bottom();
  echo '<br><br>';

  # SRs assigned to or submitted by me
  echo $HTML->box1_top(_("My Support Requests"));
  my_artifact_items("support");
  echo $HTML->box1_bottom();
  echo '<br><br>';

  # Bugs assigned to or submitted by me
  echo $HTML->box1_top(_("My Bugs"));
  my_artifact_items("bugs");
  echo $HTML->box1_bottom();
  echo '<br><br>';

  # Patch assigned to me
  echo $HTML->box1_top(_("My Patches"));
  my_artifact_items("patch");
  echo $HTML->box1_bottom();
  echo '<br><br>';

  /*
	 Change from the left to the right of the page
  */
  echo '</td><td valign="top" width="50%">';



  # Bookmarks
  echo $HTML->box1_top(_("My Bookmarks"));

  $result = db_query("SELECT bookmark_url, bookmark_title, bookmark_id from user_bookmarks where ".
		     "user_id='". user_getid() ."' ORDER BY bookmark_title");
  $rows=db_numrows($result);
  if (!$result || $rows < 1)
    {
      echo _("You currently do not have any bookmarks saved");
      echo db_error();
    }
  else
    {

      echo '<table>';
      for ($i=0; $i<$rows; $i++)
	{
	  echo '<tr class="'. utils_get_alt_row_color($i) .'"><td width="99%">';
	  echo '
                                           <b><a href="'. db_result($result,$i,'bookmark_url') .'">'.
	    db_result($result,$i,'bookmark_title') .'</a></b> '.
	    '<a href="'.$GLOBALS['sys_home'].'my/bookmark_edit.php?bookmark_id='. db_result($result,$i,'bookmark_id') .'">[Edit]</a></td>'.
	    '<td><a href="'.$PHP_SELF.'?func=delbookmark&amp;bookmark_id='. db_result($result,$i,'bookmark_id') .
	    '" onClick="return confirm(\''._("Delete this bookmark?").'\')">'.
	    '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="delete"></a></td></tr>';
	}
      echo '</table>';
    }
  echo $HTML->box1_bottom();
  echo '<br><br>';



  # Forums that are actively monitored
  echo $HTML->box1_top(_("Monitored Forums"));

  $sql="SELECT groups.group_id, groups.group_name ".
     "FROM groups,forum_group_list,forum_monitored_forums ".
     "WHERE groups.group_id=forum_group_list.group_id ".
     "AND forum_group_list.group_forum_id=forum_monitored_forums.forum_id ".
     "AND forum_monitored_forums.user_id='".user_getid()."' GROUP BY group_id ORDER BY group_id ASC LIMIT 100";

  $result=db_query($sql);
  $rows=db_numrows($result);
  if (!$result || $rows < 1)
    {
      echo '<p>'._("You are not monitoring any forums.").'</p>';
      echo '<p>'._("If you monitor forums, you will be sent new posts in the form of an email, with a link to the new message.");
      echo '<p>'._("You can monitor forums by clicking 'Monitor Forum' in any given discussion forum.");
      echo '<br>&nbsp;';
      echo db_error();
    }
  else
    {

      for ($j=0; $j<$rows; $j++)
	{

	  $group_id = db_result($result,$j,'group_id');

	  $sql2="SELECT forum_group_list.group_forum_id,forum_group_list.forum_name ".
	     "FROM groups,forum_group_list,forum_monitored_forums ".
	     "WHERE groups.group_id=forum_group_list.group_id ".
	     "AND groups.group_id=$group_id ".
	     "AND forum_group_list.group_forum_id=forum_monitored_forums.forum_id ".
	     "AND forum_monitored_forums.user_id='".user_getid()."' LIMIT 100";

	  $result2 = db_query($sql2);
	  $rows2 = db_numrows($result2);

	  list($hide_now,$count_diff,$hide_url) =
	    my_hide_url('forum',$group_id,$hide_item_id,$rows2,$hide_forum);

	  $html_hdr = ($j ? '<td colspan="2">' : '').
	     $hide_url.'<A HREF="'.$GLOBALS['sys_home'].'forum/?group_id='.$group_id.'"><B>'.
	     db_result($result,$j,'group_name').'</B></A>&nbsp;&nbsp;&nbsp;&nbsp;';

	  $html = '';
	  $count_new = max(0, $count_diff);
	  for ($i=0; $i<$rows2; $i++)
	    {

	      if (!$hide_now)
		{
		  $group_forum_id = db_result($result2,$i,'group_forum_id');
		  $html .= '
			<tr class="'. utils_get_alt_row_color($i) .'"><td width="99%">'.
		     '&nbsp;&nbsp;&nbsp;-&nbsp;<a href="'.$GLOBALS['sys_home'].'forum/forum.php?forum_id='.$group_forum_id.'">'.
		     stripslashes(db_result($result2,$i,'forum_name')).'</a></td>'.
		     '<td align="middle"><a href="'.$GLOBALS['sys_home'].'forum/monitor.php?forum_id='.$group_forum_id.
		     '" onClick="return confirm(\''._("Stop monitoring this Forum?").'\')">'.
		     '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" '.
		     'border="0" alt="stop monitoring"></a></td></tr>';
		}
	    }

	  $html_hdr .= my_item_count($rows2,$count_new).'</td></tr>';
	  echo $html_hdr.$html;
	}

      echo '<TR><TD COLSPAN="2">&nbsp;</TD></TR>';
    }
  echo $HTML->box1_bottom();
  echo '<br><br>';


  # Watching other users.

  echo $HTML->box1_top(_("Watched Partners"));

  $result = trackers_data_get_watchees(user_getid());
  $rows=db_numrows($result);

  if (!$result || $rows < 1)
    {
      echo '<p>'._("You are not watching any partners.").'</p>';
      echo '<p>'.sprintf(_("If you want to be the backup of someone when they're away from the office, or if you need to do the QA to all their activities on a project, %s can send their email notification to you also."),$GLOBALS['sys_name']);
      echo '</p><p>'._("You can watch someone clicking 'Watch Partner' in any project memberlist page (you must be member of that project, indeed).");
      echo '<br>&nbsp;';
      echo db_error();
    }
  else
    {

      echo '<table>';
      for ($i=0; $i<$rows; $i++)
	{
	  echo '<tr class="'.utils_get_alt_row_color($i).'"><td width="99%"><font class="bold">'.
	    utils_user_link(user_getname(db_result($result, $i, 'watchee_id')), user_getrealname(db_result($result, $i, 'watchee_id'))).
	    '</font> <font class="smaller">['.group_getname(db_result($result, $i, 'group_id')).']'.
	    '</font>';

	  echo '</td>'.
	    '<td><a href="'.$PHPSELF.'?func=delwatchee&amp;group_id='.db_result($result,$i,'group_id').'&amp;watchee_id='.db_result($result, $i, 'watchee_id').
	    '" onClick="return confirm(\''._("Stop watching this user?").'\')">'.
	    '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/trash.png" border="0" alt="remove"></a></td></tr>';
	}
      echo '</table>';

    }

  $result = trackers_data_get_watchers(user_getid());
  $arr_watchers = array();
  while ($row_watcher = db_fetch_array($result))
    {
      $watchers .= utils_user_link(user_getname($row_watcher['user_id']), user_getrealname($row_watcher['user_id'])).'</font> <font class="smaller">['.group_getname($row_watcher['group_id']).']</font>, ';
    }

  if ($watchers)
    {
      $watchers = substr($watchers,0,-2); # remove extra comma at the end
      $watchers .= ".";

      echo '<p>';
      printf (_("For your information your own notifications are currently watched by: %s"),$watchers);
      echo '</p>';
    }
  else
    {
      echo '<p>'._("For your information nobody is currently watching your own notifications.").'</p>';
    }

  echo $HTML->box1_bottom();



  # End
  echo '</td></tr><tr><td colspan="2">';

  echo show_priority_colors_key();

  echo '</td></tr></table>';

  $HTML->footer(array());

}
else
{

  exit_not_logged_in();

}

?>
