<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: browse.php,v 1.26 2004/03/02 18:26:18 toddy Exp $
//
//  Copyright 1999-2000 (c) The SourceForge Crew
//  Copyright 2000-2003 (c) Free Software Foundation
//  Copyright 2001-2002 (c) Xerox Corporation, CodeX Team, All rights reserved
//  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
//
//
//	Bug Tracker originally by Tim Perdue 11/99
//	Very Heavy rewrite by Laurent Julliard 2001, 2002, CodeX Team, Xerox
//


// Number of search criteria (boxes) displayed in one row
$fields_per_line=5;

// Number of bugs displayed on screen in one chunk.
// Default 50
if (!$chunksz)
{ $chunksz = 50; }

// Make sure offset is defined and has a correct value
if (!$offset || $offset < 0)
{ $offset=0; }


/* ==================================================
    Get the list of bug fields used in the form (they are in the URL - GET method)
    and then build the preferences array accordingly
    Exclude the group_id parameter// Extract the list of bug fields
 ================================================== */

$prefs = trackers_extract_field_list(false);
unset($prefs['group_id']);

/* ==================================================
   Make sure all URL arguments are captured as array. For simple
   search they'll be arrays with only one element at index 0 (this
   will avoid to deal with scalar in simple search and array in
   advanced which would greatly complexifies the code)
 ================================================== */
while (list($field,$value_id) = each($prefs))
{
  if (!is_array($value_id))
    {
      unset($prefs[$field]);
      $prefs[$field][] = $value_id;
      //echo '<br> DBG Setting $prefs['.$field.'] [] = '.$value_id;
    }
  else
    {
      //echo '<br> DBG $prefs['.$field.'] = ('.implode(',',$value_id).')';
    }

  if (trackers_data_is_date_field($field))
    {
      if ($advsrch)
	{
	  $field_end = $field.'_end';
	  $prefs[$field_end] = $$field_end;
	  //echo '<br> DBG Setting $prefs['.$field.'_end]= '.$prefs[$field.'_end'];
	}
      else
	{
	  $field_op = $field.'_op';
	  $prefs[$field_op] = $$field_op;
	  if (!$prefs[$field_op])
	    $prefs[$field_op] = '>';
	  //echo '<br> DBG Setting $prefs['.$field.'_op]= '.$prefs[$field.'_op'];
	}
    }
}


/* ==================================================
   Memorize order by field as a user preference if explicitly specified.

   $morder = comma separated list of sort criteria followed by - for
     DESC and + for ASC order
   $order = last sort criteria selected in the UI
   $msort = 1 if multicolumn sort activated.
  ================================================== */
//echo "<br>DBG \$morder at top: [$morder ]";
//   if morder not defined then reuse the one in preferences
if (user_isloggedin() && !isset($morder))
{
  $morder = user_get_preference('bug_browse_order'.$group_id);
}

if (isset($order))
{

  if ($order != '')
    {
      // Add the criteria to the list of existing ones
      $morder = trackers_add_sort_criteria($morder, $order, $msort);
    }
  else
    {
      // reset list of sort criteria
      $morder = '';
    }
}

if (isset($morder))
{

  if (user_isloggedin())
    {
      if ($morder != user_get_preference('bug_browse_order'.$group_id))
	user_set_preference('bug_browse_order'.$group_id, $morder);
    }

  if ($morder != '')
    {
      $order_by = ' ORDER BY '.trackers_criteria_list_to_query($morder);
    }
}

//echo "<BR> DBG Order by = $order_by";


/* ==================================================
  If the report type is not defined then get it from the user preferences.
  If it is set then update the user preference.  Also initialize the
  bug report structures.
  ================================================== */
if (user_isloggedin())
{
  if (!isset($report_id))
    {
      $report_id = user_get_preference('bug_browse_report'.$group_id);
    }
  else
    {
      if ($report_id != user_get_preference('bug_browse_report'.$group_id))
	user_set_preference('bug_browse_report'.$group_id, $report_id);
    }
}

// If still not defined then force it to system 'Default' report
if (!$report_id)
{ $report_id=100; }

trackers_report_init($group_id, $report_id);



/* ==================================================
  Now see what type of bug set is requested (set is one of none,
  'my', 'open', 'custom').
    - if no set is passed in, see if a preference was set ('custom' set).
    - if no preference and logged in then use 'my' set
    - if no preference and not logged in the use 'open' set
     (Prefs is a string of the form  &field1[]=value_id1&field2[]=value_id2&.... )
  ================================================== */
if (!$set)
{

  if (user_isloggedin())
    {

      $custom_pref=user_get_preference('bug_brow_cust'.$group_id);

      if ($custom_pref)
	{
	  $pref_arr = explode('&',substr($custom_pref,1));
	  while (list(,$expr) = each($pref_arr))
	    {
	      // Extract left and right parts of the assignment
	      // and remove the '[]' array symbol from the left part
	      list($field,$value_id) = explode('=',$expr);
	      $field = str_replace('[]','',$field);
	      if ($field == 'advsrch')
		$advsrch = $value_id;
	      else if ($field == 'msort')
		$msort = $value_id;
	      else if ($field == 'chunksz')
		$chunksz = $value_id;
	      else if ($field == 'report_id')
		$report_id = $value_id;
	      else
		$prefs[$field][] = $value_id;

	      //echo '<br>DBG restoring prefs : $prefs['.$field.'] []='.$value_id;
	    }
	  $set='custom';

	}
      else
	{
	  $set='open';
	}

    }
  else
    {
      $set='open';
    }
}


if ($set=='my')
{
  /*
      My bugs - backwards compat can be removed 9/10
  */
  $prefs['status_id'][]=1;
  $prefs['assigned_to'][]=user_getid();

}
else if ($set=='custom')
{

  // Get the list of bug fields used in the form (they are in the URL - GET method)
  // and then build the preferences array accordingly
  // Exclude the group_id parameter
  reset($prefs);
  while (list($field,$arr_val) = each($prefs))
    {
      while (list(,$value_id) = each($arr_val))
	{
	  $pref_stg .= '&'.$field.'[]='.$value_id;
	}

      // build part of the HTML title of this page for more friendly bookmarking
      // Do not add the criteria in the header if value is "Any"
      if ($value_id != 0)
	{
	  $hdr .= ' By '.trackers_data_get_label($field).': '.
	     trackers_data_get_value($field,$group_id,$value_id);
	}
    }
  $pref_stg .= '&advsrch='.$advsrch;
  $pref_stg .= '&msort='.$msort;
  $pref_stg .= '&chunksz='.$chunksz;
  $pref_stg .= '&report_id='.$report_id;

  if ($pref_stg != user_get_preference('bug_brow_cust'.$group_id))
    {
      //echo "<br> DBG setting pref = $pref_stg";
      user_set_preference('bug_brow_cust'.$group_id,$pref_stg);
    }

}
else
{
  // Open bugs - backwards compat can be removed 9/10
  $prefs['status_id'][]=1;
}

/* ==================================================
   At this point make sure that all paramaters are defined
   as well as all the arguments that serves as selection criteria
   If not defined then defaults to ANY (0)
  ================================================== */
if (!isset($advsrch))
{ $advsrch = 0; }
if (!isset($msort))
{ $msort = 0; }
while ($field = trackers_list_all_fields())
{
  // the select boxes for the bug DB search first
  if (trackers_data_is_showed_on_query($field) &&
      trackers_data_is_select_box($field) )
    {
      if (!isset($prefs[$field])) $prefs[$field][] = 0;
    }
}

/* ==================================================
   Start building the SQL query (select and where clauses)
  ================================================== */

// Force the selection of severity because it is always shown as color code
$col_list = $lbl_list = array();
$select_count = 'SELECT count(*) AS count ';
$select = 'SELECT '.ARTIFACT.'.priority ';
$from = 'FROM '.ARTIFACT.' ';
$where = 'WHERE '.ARTIFACT.'.group_id='.$group_id.' ';
if (!$pv)
{ $limit = " LIMIT $offset,$chunksz";}


// prepare the where clause with the selection criteria given by the user
reset($prefs);
while (list($field,$value_id) = each($prefs))
{

  // If the criteria is not in the field showed on query screen then
  // skip it. This is a sanity check to make sure that the SQL
  // query we run actually matches the displayed search criteria
  if (!trackers_data_is_showed_on_query($field))
    { continue; }

  if (trackers_data_is_select_box($field) && !trackers_isvarany($prefs[$field]) )
    {

      // Only select box criteria to where clause if argument is not ANY
      $where .= ' AND '.ARTIFACT.'.'.$field.' IN ('.implode(',',$prefs[$field]).') ';

    } else if (trackers_data_is_date_field($field) && $prefs[$field][0])
      {

	// transform a date field into a unix time and use <, > or =
	list($time,$ok) = utils_date_to_unixtime($prefs[$field][0]);

	if ($advsrch)
	  {
	    list($time_end,$ok_end) = utils_date_to_unixtime($prefs[$field.'_end'][0]);
	    if ($ok)
	      $where .= ' AND '.ARTIFACT.'.'.$field.' >= '. $time;

	    if ($ok_end)
	      $where .= ' AND '.ARTIFACT.'.'.$field.' <= '. $time_end;


	  }
	else
	  {

	    $operator = $prefs[$field.'_op'][0];
	    // '=' means that day between 00:00 and 23:59
	    if ($operator == '=')
	      {
		$time_end = mktime(23, 59, 59, $month, $day, $year);
		$where .= ' AND '.ARTIFACT.'.'.$field." >= $time ".'AND '.ARTIFACT.'.'.$field." <= $time_end ";
	      }
	    else
	      {
		$where .= ' AND '.ARTIFACT.'.'.$field." $operator= $time ";
	      }
	  }

	// Always exclude undefined dates (0)
	$where .= ' AND '.ARTIFACT.'.'.$field." <> 0 ";

      } else if ((trackers_data_is_text_field($field) || trackers_data_is_text_area($field))
		 && $prefs[$field][0])
	{

	  // It's a text field accept. Process INT or TEXT,VARCHAR fields differently
	  $where .= ' AND '.trackers_build_match_expression($field, $prefs[$field][0]);
	}
}

/* ==================================================
   Loop through the list of used fields to define label and fields/boxes
   used as search criteria
  ================================================== */
$ib=0;$is=0;
$load_cal=false;
while ( $field = trackers_list_all_fields(cmp_place_query))
{

  if (!trackers_data_is_used($field) ||
      !trackers_data_is_showed_on_query($field) )
    {
      continue;
    }

  // beginning of a new row
  if ($ib % $fields_per_line == 0)
    {
      $align = ($pv ? "left" : "center");
      $labels .= "\n".'<tr align="'.$align.'" valign="top">';
      $boxes .= "\n".'<tr align="'.$align.'" valign="top">';
    }

  $labels .= '<td class="preinput">'.trackers_data_get_label($field).' :</td>';
     // Duh, it never work with konqueror and many others browsers
     // and basically, if "category" is unclear, the name of the field
     // must be change
     //     ($pv ? '':help_button('browse_bug_query_field',$field)).
  //     '</td>';

  $boxes .= '<TD><FONT SIZE="-1">';

  if (trackers_data_is_select_box($field) )
    {

      $boxes .=
	 trackers_field_display($field,$group_id,
				($advsrch ? $prefs[$field] : $prefs[$field][0]),
				false,false,($pv?true:false),false,true,'None', true,'Any');

    } else if (trackers_data_is_date_field($field) ){

      $load_cal = true; // We need to load the Javascript Calendar
      if ($advsrch)
	$boxes .= trackers_multiple_field_date($field,$prefs[$field][0],
					       $prefs[$field.'_end'][0],0,0,$pv);
      else
	$boxes .= trackers_field_date_operator($field,$prefs[$field.'_op'][0],$pv).
	  trackers_field_date($field,$prefs[$field][0],0,0,$pv);

    } else if (trackers_data_is_text_field($field) ||
	       trackers_data_is_text_area($field) )
      {

	$boxes .=
	   ($pv ? $prefs[$field][0] : trackers_field_text($field,$prefs[$field][0],15,80)) ;

      }
  $boxes .= "</TD>\n";

  $ib++;

  // end of this row
  if ($ib % $fields_per_line == 0)
    {
      $html_select .= $labels.'</TR>'.$boxes.'</TR>';
      $labels = $boxes = '';
    }

}

// Make sure the last few cells are in the table
if ($labels)
{
  $html_select .= $labels.'</TR>'.$boxes.'</TR>';
}


/* ==================================================
   Loop through the list of used fields to see what fields are in the
   result table and complement the SQL query accordingly.
  ================================================== */
while ( $field = trackers_list_all_fields(cmp_place_result))
{

  if (!trackers_data_is_used($field) ||
      !trackers_data_is_showed_on_result($field) )
    {
      continue;
    }

  $col_list[] = $field;
  $width_list[] = trackers_data_get_col_width($field);
  $lbl_list[] = trackers_data_get_label($field);

  if ( trackers_data_is_username_field($field))
    {
      // user names requires some special processing to display the username
      // instead of the user_id
      $select .= ",user_$field.user_name AS $field";
      $from .= ",user user_$field";
      $where .= " AND user_$field.user_id=".ARTIFACT.".$field ";
    }
  else
    {
      // otherwise just select this column as is
      $select .= ",".ARTIFACT.".$field";
    }

}

/* ==================================================
    Run 2 queries : one to count the total number of results, and the second
    one with the LIMIT argument. It is faster than selecting all
    rows (without LIMIT) because when the number of bugs is large it takes
    time to transfer all the results from the server to the client. It is also faster
    than using the SQL_CALC_FOUND_ROWS/FOUND_ROWS() capabilities of
    MySQL
  ================================================== */
$sql_count = "$select_count $from $where";
$result_count=db_query($sql_count);
$totalrows = db_result($result_count,0,'count');

$sql = "$select $from $where $order_by $limit";
$result=db_query($sql);
//echo "<br> DBG SQL = $sql";
//exit 0;


/* ==================================================
   Display the HTML search form
  ================================================== */

if ($pv)
{
  help_header(_("Bug Search Report").' - '.format_date($sys_datefmt,time()),false);
}
else
{
  trackers_header(array('title'=>_("Browse").' '.$hdr));
}

if ($load_cal)
{
  echo ' <script language="JavaScript" src="'.
    $GLOBALS['sys_home'].'include/calendar.js"></script> ';
}

echo '    <FORM ACTION="'.$PHP_SELF .'" METHOD="GET" NAME="bug_form">
          <INPUT TYPE="HIDDEN" NAME="group_id" VALUE="'.$group_id.'">
          <INPUT TYPE="HIDDEN" NAME="set" VALUE="custom">
          <INPUT TYPE="HIDDEN" NAME="msort" VALUE="'.$msort.'">
          <h3>'._("Browse").' ';

// Show the list of available bug reports kind
if (!$pv)
{
  $res_report = trackers_data_get_reports($group_id,user_getid());
  $box_name = 'report_id" onChange="document.bug_form.go_report.click()';

  printf(_("with the %s query form"), html_build_select_box($res_report,$box_name,$report_id,true,'Basic'));
}

// Start building the URL that we use to for hyperlink in the form
$url = $GLOBALS['sys_home'].ARTIFACT."/?group_id=$group_id&func=browse&set=$set&msort=$msort";
if ($set == 'custom')
     $url .= $pref_stg;
     else
     $url .= '&advsrch='.$advsrch;

$url_nomorder = $url;
$url .= "&morder=$morder";

// Build the URL for alternate Search
if ($advsrch)
{
  $url_alternate_search = str_replace('advsrch=1','advsrch=0',$url);
  $text = _("Simple Search");
}
else
{
  $url_alternate_search = str_replace('advsrch=0','advsrch=1',$url);
  $text = _("Advanced Search");
}

// Select 'list form' or 'select' form
if (!$pv)
{
  if ($advsrch)
    {
      $advsrch_1 = ' selected';
    }
  else
    {
      $advsrch_0 = ' selected';
    }
  printf(' '._("and %s selection."), '<select name="advsrch"><option value="0"'.$advsrch_0.'>'._("Simple").'</option><option value="1"'.$advsrch_1.'>'._("Multiple").'</option></select>');
}

// End the form type selection
echo '<input value="'._("Apply").'" name="go_report" type="submit">';
echo '</h3>';

echo '<TABLE BORDER="0" CELLPADDING="0" CELLSPACING="5">
        <TR><TD colspan="'.$fields_per_line.'" nowrap>';

echo $html_select;

echo '</table>';
if (!$pv)
{
  echo '<p><font class="smaller">Show</font> '.
    '<input type="text" name="chunksz" size="3" maxlength="5" '.
    'value="'.$chunksz.'"> '._("items at once").'.</form>';
}

/* ==================================================
  Finally display the result table
 ================================================== */

$numrows = db_numrows($result);

if ($result && $numrows > 0)
{

  // Build the sorting header messages
  if ($morder)
    {
      $order_statement = _("sorted by:")." ".trackers_criteria_list_to_text($morder, $url_nomorder);
    }
  else
    {
      $order_statement ='';
    }
  echo '<a name="results"></a>';
  # add the plural in brackets, so it looks a little nicer -- toddy 2004-02-29
  echo '<h3>'.$totalrows.' '._("matching item(s)").' '.$order_statement.'</h3>';


  if (!$pv)
    {
    echo '<p>';
    if ($msort)
      {
        $url_alternate_sort = str_replace('msort=1','msort=0',$url).'&order=#results';
        printf(_("Click a column heading to sort results (up or down), or %ssort by priority%s or %sreset sort%s. You can also %sdeactivate%s multicolumn sort."),
          '<a href="'.$url.'&amp;order=priority#results"><b>', '</b></a>',
          '<a href="'.$url.'&order=#results"><b>', '</b></a>',
          '<a href="'.$url_alternate_sort.'"><b>', '</b></a>');
      }
    else
      {
        $url_alternate_sort = str_replace('msort=0','msort=1',$url).'&order=#results';
        printf(_("Click a column heading to sort results (up or down), or %ssort by priority%s or %sreset sort%s. You can also %sactivate%s multicolumn sort."),
          '<a href="'.$url.'&amp;order=priority#results"><b>', '</b></a>',
          '<a href="'.$url.'&order=#results"><b>', '</b></a>',
          '<a href="'.$url_alternate_sort.'"><b>', '</b></a>');
      }
      echo '&nbsp;&nbsp;&nbsp;&nbsp;(<a href="'.$url.'&pv=1"><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/print.png" border="0">';
      echo '&nbsp;'._("Printer version").'</a>)</p>'."\n";
    }
  else
    {
      $chunksz = 100000;
    }
  show_item_list($result,$offset,$totalrows,$col_list,$lbl_list,$width_list,
	       ($pv ? '' : $url), ($pv ? true:false) );
  show_priority_colors_key('Severity colors:');

}
else
{

  echo '<h2>'._("No Matching Items Found for").' '.group_getname($group_id).' '._("or filters too restrictive").'</h2>';
  echo db_error();

}

if ($pv)
     help_footer();
     else
     trackers_footer(array());

?>
