<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: userlist.php,v 1.17 2004/03/04 18:55:45 toddy Exp $
//
//
// Copyright 1999-2000 (c) The SourceForge Crew
//
//
//  Copyright 2000-2003 (c) Free Software Foundation
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
//
//

require "../include/pre.php";

site_admin_header(array('title'=>_("User List"),'toptab'=>'admuser'));

// FIXME:
// this page should use the standard savannah search method and print
// only a specified number of items at once.
// Currently it is absolutely not scalable.

function show_users_list ($result)
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':show_users_list ($result) ';
	$title_arr=array();
	$title_arr[]=_("Id");
	$title_arr[]=_("User");
	$title_arr[]=_("Status");
	$title_arr[]=_("Member Profile");
	$title_arr[]=_("Action");

	print html_build_list_table_top ($title_arr);

	while ($usr = db_fetch_array($result)) {


		print '<tr class="'.utils_get_alt_row_color($inc++).'"><td>'.$usr[user_id].'</td><td><a href="usergroup.php?user_id='.$usr[user_id].'">';
		print "$usr[user_name]</a>";
		print "</td><td>\n";

		switch ($usr[status]) {
			case 'A': print _("Active"); break;
			case 'D': print _("Deleted"); break;
			case 'S': print _("Suspended"); break;
			case 'P': print _("Pending"); break;
			default: print _("Unknown status")." : ".$usr[status]; break;
		}
		if ($usr[people_view_skills] == 1 ) {
			print '<td><a href="'.$GLOBALS['sys_home'].'people/viewprofile.php?user_id='.$usr[user_id].'">['._("View").']</a></td>';
		} else {
			print '<td>('._("Private").')</td>';
		}
		print '<td>';
		if ($usr[status] != 'D') print '<a href="'.$GLOBALS['sys_home'].'admin/userlist.php?action=delete&user_id='.$usr[user_id].'">['._("Delete").']</a> ';
		if ($usr[status] != 'S') print '<a href="'.$GLOBALS['sys_home'].'admin/userlist.php?action=suspend&user_id='.$usr[user_id].'">['._("Suspend").']</a>';
		if ($usr[status] != 'A') print '<a href="'.$GLOBALS['sys_home'].'admin/userlist.php?action=activate&user_id='.$usr[user_id].'">['._("Activate").']</a> ';
		print "</td></tr>\n";

	}
	print "</table>";

}

// Administrative functions
$out='NOTHING';
if ($action=='delete') {
	db_query("UPDATE user SET status='D' WHERE user_id='$user_id'");
	$out = _("DELETE");
} else if ($action=='activate') {

	db_query("UPDATE user SET status='A' WHERE user_id='$user_id'");
	$out = _("ACTIVE");
} else if ($action=='suspend') {
	db_query("UPDATE user SET status='S' WHERE user_id='$user_id'");
	$out = _("SUSPEND");
}


if ($action) {
	print '<h3>'._("Action done").' :</h3>';
	print '<p>';
	printf(_("Status updated to %s for user %s"), $out, $user_id);
	print '</p>';
	print db_error();
}
/*
	Add a user to this group
*/
if ($action=='add_to_group') {
	db_query("INSERT INTO user_group (user_id,group_id) VALUES ($user_id,$group_id)");

}


$abc_array = array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','0','1','2','3','4','5','6','7','8','9');

print '<h3>'._("User Search").'</h3>';

print '<p>'._("Display users beginning with").' : ';

for ($i=0; $i < count($abc_array); $i++) {
	echo "<a href=\"userlist.php?user_name_search=$abc_array[$i]\">$abc_array[$i]</a> ";
}

print '<br>'._("or search by email, username, realname or userid").' :';
print '
<form name="usersrch" action="search.php" method="POST">
  <input type="text" name="search">
  <input type="hidden" name="usersearch" value="1">
  <input type="submit" value="get">
</form>
</p>';





/*
	Show list of users
*/
print '<h3>'._("Savane user list for group:");

if (!$group_id) {
	print '<b>'._("All Groups").'</b></h3>';


	if ($user_name_search) {
		$result = db_query("SELECT user_name,user_id,status,people_view_skills FROM user WHERE user_name LIKE '$user_name_search%' ORDER BY user_name");
	} else {
		$result = db_query("SELECT user_name,user_id,status,people_view_skills FROM user ORDER BY user_name");
	}
	show_users_list ($result, $group_id);
} else {
	/*
		Show list for one group
	*/
	print " <b>" . group_getname($group_id) . "</b></h3>";


	$result = db_query("SELECT user.user_id AS user_id, user.user_name AS user_name, user.status AS status ,user.people_view_skills AS people_view_skills"
		. "FROM user,user_group "
		. "WHERE user.user_id=user_group.user_id AND "
		. "user_group.group_id=$group_id ORDER BY user.user_name");

	show_users_list ($result);

	/*
        	Show a form so a user can be added to this group
	*/
	print '<hr><p></p>';
	print '<h3>'._("Add User to Group").' '.group_getname($group_id).'</h3>';
	print '<form action="'.$PHP_SELF.'" method="post">';

	// FIXME: not conform to the coding style
	?>

	<input type="HIDDEN" name="action" VALUE="add_to_group">
	<input type="HIDDEN" name="group_id" VALUE="<?php print $group_id; ?>">
	<input name="user_id" type="TEXT" value="">
	<input type="submit" name="Submit" value="<?php print _("Add"); ?>">
	</form>

<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: userlist.php,v 1.17 2004/03/04 18:55:45 toddy Exp $
//

}

$HTML->footer(array());

?>