<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: change_notifications.php,v 1.3 2004/01/31 00:56:17 yeupou Exp $
//
//
//  the Savannah Project
//  Copyright 2003 (c) Mathieu Roy <yeupou@gnu.org>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
//
//
//
// Most of the code has been originally written by Laurent Julliard
// 2001, 2002, CodeX Team, Xerox

require "../include/pre.php";    
require "../include/account.php";
require_directory("trackers");


/*  ==================================================
    Set up some data structure needed throughout the script
 ================================================== */

$user_id = user_getid();
// get notification roles
// get notification roles
$res_roles = trackers_data_get_notification_roles();
$num_roles = db_numrows($res_roles);
$i=0;
while ($arr = db_fetch_array($res_roles))
{
  $arr_roles[$i] = $arr; $i++;
}

// get notification events
$res_events = trackers_data_get_notification_events();
$num_events = db_numrows($res_events);
$i=0;
while ($arr = db_fetch_array($res_events))
{
  $arr_events[$i] = $arr; $i++;
}

// build the default notif settings in case the user has not yet defined her own
// By default it's all 'yes'
for ($i=0; $i<$num_roles; $i++)
{
  $role_id = $arr_roles[$i]['role_id'];
  for ($j=0; $j<$num_events; $j++)
    {
      $event_id = $arr_events[$j]['event_id'];
      $arr_notif[$role_id][$event_id] = 1;
    }
}

// Overwrite with user settings if any
$res_notif = trackers_data_get_notification($user_id);
while ($arr = db_fetch_array($res_notif))
{
  $arr_notif[$arr['role_id']][$arr['event_id']] = $arr['notify'];
}

/*  ==================================================
    The form has been submitted - update the database
 ================================================== */

if ($submit)
{
  // Event/Role specific settings
  for ($i=0; $i<$num_roles; $i++)
    {
      $role_id = $arr_roles[$i]['role_id'];
      for ($j=0; $j<$num_events; $j++)
	{
	  $event_id = $arr_events[$j]['event_id'];
	  $cbox_name = 'cb-'.$role_id.'-'.$event_id;
	  //echo "DBG $cbox_name -> '".$$cbox_name."'<br>";
	  $arr_notif[$role_id][$event_id] = ( $$cbox_name ? 1 : 0);
	}
    }
  trackers_data_delete_notification($user_id);
  $res_notif = trackers_data_insert_notification($user_id, $arr_roles, $arr_events, $arr_notif);

  // Give Feedback
  if ($res_notif)
    {
      fb(_("- Successful Update"));
    }
  else
    {
      fb(_("- Update Failed").db_error());
    }

} 
// end submit


/*  ==================================================
    Start HTML
 ================================================== */

site_user_header(array('title'=>_("Mail Notification Settings"),'toptab'=>'account'));


echo '<h3>'._("Event/Role Mail Notification Settings")."</h3>\n";

echo '
<FORM action="'.$PHP_SELF.'" method="post">';

// Build Role/Event table 
// Rk: Can't use html_build_list_table_top because of the specific layout

print _("You can tune your notification settings and decide what item changes you want to be aware of, depending on your role.").' </p>
<p>';


echo '</p>';

echo '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<table border="0" cellspacing="1" cellpadding="2">
<tr bgcolor="'. $HTML->COLOR_HTMLBOX_TITLE .'">
    <td colspan="'.$num_roles.'" align="center" width="50%"><b>'._("If my role in a bug is:").'</b></td>
    <td rowspan="2" width="50%"><b>&nbsp;&nbsp;&nbsp;'._("I want to be notified when:").'</b></td>
</tr>';

for ($i=0; $i<$num_roles; $i++) 
{
  echo '<td align="center" width="10%"><b>'.$arr_roles[$i]['short_description']."</b></td>\n";
}
echo "</tr>\n";

for ($j=0; $j<$num_events; $j++) 
{
  $event_id = $arr_events[$j]['event_id'];
  $event_label = $arr_events[$j]['event_label'];
  echo '<tr class="'.utils_get_alt_row_color($j)."\">\n";
  for ($i=0; $i<$num_roles; $i++) 
    {
      $role_id = $arr_roles[$i]['role_id'];
      $role_label = $arr_roles[$i]['role_label'];
      $cbox_name = 'cb-'.$role_id.'-'.$event_id;
      if ((($event_label == 'NEW_ITEM') && ($role_label != 'ASSIGNEE') && ($role_label != 'SUBMITTER')) )
	{
	  // if the user is not an assignee or a submitter the new_item event is meaningless
	  echo '   <td align="center"><input type="hidden" name="'.$cbox_name.'" value="1">-</td>'."\n";
	} 
      else
	{
	  echo '   <td align="center"><input type="checkbox" name="'.$cbox_name.'" value="1" '.
	    ($arr_notif[$role_id][$event_id] ? 'checked':'')."></td>\n";
	}
    }
  echo '   <td>&nbsp;&nbsp;&nbsp;'.$arr_events[$j]['description']."</td>\n";
  echo "</tr>\n";
}

echo'
</table>

<HR>
<P align="center"><INPUT type="submit" name="submit" value="Submit Changes">
</FORM>';

site_user_footer(array());

?>
