#!/bin/sh
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_export_db.sh,v 1.10 2004/01/31 00:56:17 yeupou Exp $ 
#
#
#
#  Copyright 2002 (c) Mathieu Roy <yeupou@gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
#
#
#

SNAME="sv_export_db"

# output conf
OUTPUT_PATH=`pwd`/../../db
OUTPUT_DATABASE_PREFIX="database_"
OUTPUT_TABLE_PREFIX="table_"
OUTPUT_STRUCTURE_SUFFIX="structure"

# SQL server conf
CONF="/etc/savannah/local.inc.pl"

SQL_DB=`perl -e 'do "'$CONF'"; print $sys_dbname'`
SV_DB_OPTION_USER=`perl -e 'do "'$CONF'"; print $sys_dbuser'`
SV_DB_OPTION_PASSWD=`perl -e 'do "'$CONF'"; print $sys_dbpasswd'`
SQL_OPTIONS="-u $SV_DB_OPTION_USER -p$SV_DB_OPTION_PASSWD"

SQL_DUMP="mysqldump"
SQL_NAME="mysql"


# functions
function sv_export_db_license {
    echo "#  Part of the Savannah Project              "
    echo "#  Copyright 2002 (c) Mathieu Roy <yeupou@gnu.org>      "
    echo "#"
    echo "# This program is free software; you can redistribute it and/or      "
    echo "# modify it under the terms of the GNU General Public License    "
    echo "# as published by the Free Software Foundation; either version 2   "
    echo "# of the License, or (at your option) any later version.          " 
    echo "#"
    echo "# This program is distributed in the hope that it will be useful,"
    echo "# but WITHOUT ANY WARRANTY; without even the implied warranty of "
    echo "# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  "
    echo "# GNU General Public License for more details.                        "
    echo "#                                                                     "
    echo "# You should have received a copy of the GNU General Public License   " 
    echo "# along with this program; if not, write to the Free Software "
    echo "# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA."
    echo "# \$Id: sv_export_db.sh,v 1.10 2004/01/31 00:56:17 yeupou Exp $"

}

function sv_export_db_dump {
    $SQL_DUMP $SQL_DB $SQL_TABLE --no-data $SQL_OPTIONS
}

function sv_export_db_do {
    if [ $SQL_TABLE ] ; then
	PREFIX=$OUTPUT_TABLE_PREFIX
	NAME=$SQL_TABLE
    else
	PREFIX=$OUTPUT_DATABASE_PREFIX
	NAME=savannah
    fi
    OUTPUT=$OUTPUT_PATH/$SQL_NAME/$PREFIX$NAME.$OUTPUT_STRUCTURE_SUFFIX
    
    sv_export_db_license > $OUTPUT
    sv_export_db_dump >> $OUTPUT
}

# here we go

# generate the complete tdatabase file
unset SQL_TABLE
echo "export database"
sv_export_db_do

# We only export tables that will surely be in SV2
LIST_SQL_TABLE="bug bug_bug_dependencies bug_canned_responses bug_file bug_filter bug_history bug_task_dependencies bug_field bug_field_usage bug_field_value bug_report_field bug_report db_images forum forum_agg_msg_count forum_monitored_forums forum_saved_place forum_thread_id forum_group_list groups group_cvs_history group_history group_type image mail_group_list mailaliases news_bytes patch patch_category patch_history patch_status people_job people_job_inventory people_skill_inventory people_job_category people_job_status people_skill people_skill_level people_skill_year project_assigned_to project_dependencies project_group_list project_history  project_status project_task session support_canned_responses support_category support support_messages support_history support_status user_bookmarks user user_group user_preferences "

for SQL_TABLE in $LIST_SQL_TABLE; do
    echo "export table $SQL_TABLE"
    sv_export_db_do
done

echo "done"


