#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: Groups.pm,v 1.18 2004/01/31 00:56:19 yeupou Exp $
#
#
#
# Copyright 2003 (c) Mathieu Roy <yeupou@gnu.org>
#
#
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

##
## Desc: any subs related to groups.
##

use strict;
require Exporter;

# Exports
our @ISA = qw(Exporter);
our @EXPORT = qw(GetGroupSettings PrintGroupSettings SetGroupSettings GetGroupList DeleteGroup GetGroupName GetGroupTypeHost GetGroupTypeDescription IsGroupHomepageOnCvs IsGroupHomepageDirGuessed CanGroupUseHomepage GetGroupHomepageHost GetGroupHomepageDir GetGroupHomepageCvsModule GetGroupHomepageUrl CanGroupUseCvs GetGroupCvsHost GetGroupCvsDir GetGroupCvsUrl CanGroupUseDownload GetGroupDownloadHost GetGroupDownloadDir GetGroupDownloadUrl CanGroupUseMailinglist GetGroupMailinglistHost GetGroupMailinglistListinfoUrl GetGroupMailinglistArchivesUrl GetGroupMailinglistArchivesPrivateUrl GetGroupMailinglistArchivesPrivateUrl CanGroupUseForum CanGroupUsePatch CanGroupUseTask CanGroupUseNews CanGroupUseSupport CanGroupUseBug GetGroupUsers PrintGroupUsers GetGroupAdmins PrintGroupAdmins GetGroupAdminsMail PrintGroupAdminsMail GetGroupType PrintGroupType GetGroupTypeSettings PrintGroupTypeSettings GetGroupTypeName );
our $version = 1;

# Imports (needed for strict).
our $dbd;


#######################################################################
##
## On Groups
##
#######################################################################


## Get any settings for any users.
# arg0 : group name
# arg1 : setting (none for all)
sub GetGroupSettings { 
    GetDBSettings("groups", "unix_group_name='$_[0]'", $_[1]);
}


## Show in a convenient way settings for a user
# arg1 : which group name
sub PrintGroupSettings {
    print join " | ", GetGroupSettings($_[0]);
}


## Update in a convenient way settings for a group
# arg1 : which group name
# arg2 : which field
# arg3 : new value
sub SetGroupSettings {    
    SetDBSettings("groups", "unix_group_name='$_[0]'", "$_[1]='$_[2]'");
}

## Get a list of groups.
# arg0 : which criterion
# arg1 : which field to be returned
sub GetGroupList { 
    return GetDBList("groups", $_[0], $_[1]);
}


## Delete a group account. This function should be used carrefully.
# arg1 : which group name
sub DeleteGroup {    
    return $dbd->do("DELETE FROM groups WHERE unix_group_name='".$_[0]."'") if $_[0];
}

## Delete several group accounts. This function should be used carrefully.
# arg1 : a criterion
sub DeleteGroups {    
    return $dbd->do("DELETE FROM groups WHERE ".$_[0]) if $_[0];
}



## In many case, we have to deal with group_id but I find
## easier to deal directly with user_name
# arg1 : which group id
sub GetGroupName {
    return $dbd->selectrow_array("SELECT unix_group_name FROM groups WHERE group_id='".$_[0]."'");
}


## Shortcuts, arg1 is group name
# (Group within the sub name ? it should be obvious here.
#  let's avoid implicit...)
sub GetGroupTypeHost {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'base_host');
}
sub GetGroupTypeDescription {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'description');
}
sub IsGroupHomepageOnCvs {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'is_homepage_on_cvs');
}
sub IsGroupHomepageDirGuessed {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'is_homepage_dir_guessed');
}
sub CanGroupUseHomepage {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_homepage');
}
sub GetGroupHomepageHost {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'homepage_host');
}
sub GetGroupHomepageDir { 
    return GetGroupTypeSettings(GetGroupType($_[0]), 'homepage_dir').$_[0];
}
sub GetGroupHomepageCvsModule {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'homepage_cvs_module_prefix').$_[0];
}
sub GetGroupHomepageUrl {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'homepage_cvs_view_url').$_[0];
}
sub CanGroupUseCvs {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_download');
}
sub GetGroupCvsHost {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'cvs_host');
}
sub GetGroupCvsDir { 
    return GetGroupTypeSettings(GetGroupType($_[0]), 'cvs_dir').$_[0];
}
sub GetGroupCvsUrl {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'cvs_view_url').$_[0];
}
sub CanGroupUseDownload {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_download');
}
sub GetGroupDownloadHost {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'download_host');
}
sub GetGroupDownloadDir { 
    return GetGroupTypeSettings(GetGroupType($_[0]), 'download_dir').$_[0];
}
sub GetGroupDownloadUrl {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'download_url').$_[0];
}
sub CanGroupUseMailinglist {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_mailing_list');
}
sub GetGroupMailinglistHost {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'mailing_list_host');
}
sub GetGroupMailinglistListinfoUrl {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'mailing_list_listinfo_url').$_[0];
}
sub GetGroupMailinglistArchivesUrl {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'mailing_list_archives_url').$_[0];
}
sub GetGroupMailinglistArchivesPrivateUrl {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'mailing_list_archives_private_url').$_[0];
}
sub GetGroupMailinglistArchivesPrivateUrl {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'mailing_list_admin_url').$_[0];
}
sub CanGroupUseForum {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_forum');
}
sub CanGroupUsePatch {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_patch');
}
sub CanGroupUseTask {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_task');
}
sub CanGroupUseNews {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_news');
}
sub CanGroupUseSupport {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_support');
}
sub CanGroupUseBug {
    return GetGroupTypeSettings(GetGroupType($_[0]), 'can_use_bug');
}


## Get list of group's users
# arg1 : which group name
sub GetGroupUsers {
    return GetDBList("user_group", "group_id='".GetGroupSettings($_[0], "group_id")."'", "user_id");
}

## Show in a convenient way group's users
sub PrintGroupUsers {
    foreach my $user (GetGroupUsers($_[0])) {
	print GetUserName($user)." | ";
    }
}

## Get list of group's admin
# arg1 : which group name
sub GetGroupAdmins {
    return GetDBList("user_group", "group_id='".GetGroupSettings($_[0], "group_id")."' AND admin_flags='A'", "user_id");
}

## Show in a convenient way group's admin
sub PrintGroupAdmins {
    foreach my $user (GetGroupAdmins($_[0])) {
	print GetUserName($user)." | ";
    }
}

## Get list of group's admin emails
# arg1 : which group name
sub GetGroupAdminsMail {
    return GetDBList("user,user_group", "user_group.user_id=user.user_id AND user_group.group_id='".GetGroupSettings($_[0], "group_id")."' AND user_group.admin_flags='A'","user.email");
}

## Show in a convenient way group's admin emails
sub PrintGroupAdminsMail {
    print join " | ", GetGroupAdminsMail($_[0]);
}


#######################################################################
##
## On Group Types
##
#######################################################################


## Get the group type, very frequent.
# arg1 : which group name
sub GetGroupType {
    return GetGroupTypeName(GetGroupSettings($_[0], 'type'));
}

## Show in a convenient way group's type
# arg1 : which group name
sub PrintGroupType {
    print GetGroupTypeName(GetGroupType($_[0]));
}

## Get any settings for any users.
# arg1 : which group name
# arg2 : which setting (none for all)
sub GetGroupTypeSettings { 
    my $arg_group;
    my $arg_field = "*";
 
    if ($_[0] ne '') { 
	unless ($_[0] eq '*') {
	    $arg_group = " WHERE name='".$_[0]."'"; 
	}
	if ($_[1] ne '') {
	    $arg_field = $_[1];
	}
    }

    return $dbd->selectrow_array("SELECT ".$arg_field." FROM group_type".$arg_group);
}

## Show in a convenient way settings for a user
# arg1 : which group name
sub PrintGroupTypeSettings {
    print join " | ", GetGroupTypeSettings($_[0]);
}

## In many case, we have to deal with group_id but I find
## easier to deal directly with user_name
# arg1 : which group id
sub GetGroupTypeName {
    return $dbd->selectrow_array("SELECT name FROM group_type WHERE type_id='".$_[0]."'");
}
