<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: index.php,v 1.42 2004/02/03 13:54:27 yeupou Exp $
//
//
// Copyright 1999-2000 (c) The SourceForge Crew
//
//
//  Copyright 2000-2003 (c) Free Software Foundation
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
//

//


require "../../include/pre.php";    
require "../../include/account.php";

// get current information
$res_grp = group_get_result($group_id);

if (db_numrows($res_grp) < 1) 
{
  exit_error("Invalid Group","That group could not be found.");
}

//if the project isn't active, require you to be a member of the super-admin group
if (!(db_result($res_grp,0,'status') == 'A')) 
{
  session_require (array('group'=>1));
}

session_require(array('group'=>$group_id));

site_project_header(array('group'=>$group_id,'toptab'=>'ahome'));

/*
     Pointers to general administration pages
*/

print '<h3><a href="'.$GLOBALS['sys_home'].'project/admin/editgroupinfo.php?group='.$group_name.'">'._("Edit Public Informations").'</a></h3>';
print '<dd>'._("Edit project description, define mail notification addresses").'...<br>';
print _("Your current short description is: ").' <i>"'. db_result($res_grp,0,'short_description').'"</i>';
print '.</dd>';

print '<h3><a href="'.$GLOBALS['sys_home'].'project/admin/editgroupfeatures.php?group='.$group_name.'">'._("Active Features").'</a></h3>';
print '<dd>'._("Define which features you want to use for this project.").'.</dd>';


print '<h3><a href="'.$GLOBALS['sys_home'].'project/admin/useradmin.php?group='.$group_name.'">'._("Manage Members").'</a></h3>';
print '<dd>'._("Add/Remove members to your project").'.</dd>';

print '<h3><a href="'.$GLOBALS['sys_home'].'project/admin/userperms.php?group='.$group_name.'">'._("Set Member Permissions").'</a></h3>';
print '<dd>'._("Modify the rights of project members").'.</dd>';

print '<h3><a href="'.$GLOBALS['sys_home'].'project/admin/editgroupnotifications.php?group='.$group_name.'">'._("Manage Email Notifications").'</a></h3>';
print '<dd>'._("For every tracker, modify the type of notification (global/per category), the related address lists and the notification triggers").'.</dd>';

print '<h3><a href="'.$GLOBALS['sys_home'].'project/admin/history.php?group='.$group_name.'">'._("Show History").'</a></h3>';
print '<dd>'.sprintf(_("Keep tracks of your %s project's modications"),$GLOBALS['sys_name']).'.</dd>';

print '<h3><a href="'.$GLOBALS['sys_home'].'people/createjob.php?group='.$group_name.'">'._("Post Jobs").'</a></h3>';
print '<dd>'._("Add a job offer").'.</dd>';
 
print '<h3><a href="'.$GLOBALS['sys_home'].'people/editjob.php?group='.$group_name.'">'._("Edit Jobs").'</a></h3>';
print '<dd>'._("Edit jobs offers for this project").'.</dd>';

/*
 
Pointers to others configurations tools

*/


print '<br><br>';
print '<h2>'._("Others Administration Tools").'</h2>';

// function that print a tracker entry, too specific to be generalized
// and included in /include files.
function specific_tracker_entry($artifact, $artifact_title) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':specific_tracker_entry($artifact, $artifact_title) ';
  print '<h3><a href="'.$GLOBALS['sys_home'].$artifact.'/admin/?group='.$GLOBALS['group_name'].'">'.sprintf(_("%s Tracker Admin"), $artifact_title).'</a></h3>';
  print '<dd>'.sprintf(_("Configure your %s tracker: you can manage fields used, define query forms, manage mail notifications, add a specific preamble..."), $artifact_title).'</dd>';
}


if ($project->CanUse("support")) 
{ specific_tracker_entry("support", "Support");}

if ($project->CanUse("bug")) 
{ specific_tracker_entry("bugs", "Bug"); }


if ($project->CanUse("task")) 
{ specific_tracker_entry("task", "Task"); }

if ($project->CanUse("patch")) 
{ specific_tracker_entry("patch", "Patch"); }

if ($project->canuseForum()) 
{
  print '<h3><a href="'.$GLOBALS['sys_home'].'forum/admin/?group='.$group_name.'">'._("Forum Admin").'</a></h3>';
}

if ($project->CanUse("mailing_list")) 
{
  print '<h3><a href="'.$GLOBALS['sys_home'].'mail/admin/?group='.$group_name.'">'._("Mailing List Admin").'</a></h3>';
  print '<dd>'._("Create, manage, project's mailing lists").'.</dd>';
}

/* yeupou@gnu.org 2004-02-03
   FIXME: this part should be elsewhere, like we provide CVS information
   There is more risk of misleading information that anything else, so we
   shut it off for now 
   
if ($project->CanUse("download")) 
{
  print '<h3><a href="'.$GLOBALS['sys_home'].'files/admin/?group='.$group_name.'">'._("Files Admin").'</a></h3>';
  print '<dd>Your project download area is located at
<a href="'.$project->getTypeUrl("download").$project->getUnixName().'">'.$project->getTypeUrl("download").$project->getUnixName().'</a>. 
You can upload files in it using the scp or sftp commands (they are part of regular ssh packages) or rsync over ssh. 
If you encounter problems uploading your files in this way, first make sure you are able to access the CVS tree, both for reading and writing. 
The logic is the same and once you get CVS working, scp, sftp or rsync over ssh should work just fine. Check the <a href="'.$GLOBALS['sys_home'].'cvs/?group_id='.$group_id.'">CVS page for detailed instruction</a>. 
Here are three example commands to upload a file in your public download area:<br><br>
rsync --rsh=ssh distribution.tar.gz '.user_getname().'@'.$project->getTypeBaseHost().':'.$project->getTypeDir("download").$project->getUnixName().'<br>sftp -1 '.user_getname().'@'.$project->getTypeBaseHost().':/'.$project->getUnixName().'<br>scp distribution.tar.gz '.user_getname().'@'.$project->getTypeBaseHost().':'.$project->getTypeDir("download").$project->getUnixName().'</dd>';

}
*/


/*

     Other stuff

*/

utils_get_content("project/admin/index_misc");

site_project_footer(array());

?>
