<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: utils.php,v 1.53 2004/01/31 00:56:18 yeupou Exp $
//
//
// 
// Copyright 1999-2000 (c) The SourceForge Crew
//
//
//  Copyright (C) 2000-2003 Free Software Foundation,
//                          Mathieu Roy <yeupou@gnu.org>,
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
//
//

// Many functions in this file do not set sys_debug_where, they are too
// low level ones, they are not the functions that can call dbg().


// This function permit including site specific content with ease
function utils_get_content ($file) 
{
  if (is_file($GLOBALS['sys_incdir'].'/'.$file.'.'.$GLOBALS['locale'])) 
    {
      // there is localized version of the file :
      include($GLOBALS['sys_incdir'].'/'.$file.'.'.$GLOBALS['locale']);
    } 
  elseif (is_file($GLOBALS['sys_incdir'].'/'.$file.'.txt'))
    {
      include($GLOBALS['sys_incdir'].'/'.$file.'.txt');
    }
  else
    {
      fb(sprintf(_("warning: Savannah was not able to read \"%s\" site-specific information, please contact administrators"), $file), 1);
    }
}

// Make sure that to avoid malicious file paths
function utils_check_path ($path) 
{
  if (eregi(".*\.\.\/.*", $path)) 
    {
      exit_error('Error','Malformed url');
    }
}

// In a string, replace %PROJECT by the group_name
// (useful for group type configuration)
function utils_makereal ($data, $string="%PROJECT", $replacement=0)
{
  if (!$replacement)
    { $replacement = $GLOBALS[group_name]; }
  return ereg_replace($string, $replacement, $data);
}


// This function returns a string of the date $value with the format $format
// and if this date is not set, return the default value $default_value
function format_date ($format,$value,$default_value = '-') 
{
  if ($value == 0) 
    {
      return $default_value;

    } 
  else 
    {
      if ($format) 
	{
	  return date($format,$value);
	} 
      else 
	{
	  return strftime('%a %x '._("at").' %R',$value);
	}
    }
}

// Convert a date as used in the bug tracking system and other services (YYYY-MM-DD)
// into a Unix time
// Returns a list with two values: the unix time and a boolean saying whether the conversion
// went well (true) or bad (false)
function utils_date_to_unixtime ($date)
{
  $res = preg_match("/\s*(\d+)-(\d+)-(\d+)/",$date,$match);
  if ($res == 0) 
    { return array(0,false); }
  list(,$year,$month,$day) = $match;
  $time = mktime(0, 0, 0, $month, $day, $year);
  //echo "<br>DBG Matching date $date -> year $year, month $month,day $day -> time = $time<br>";
  return array($time,true);
}

function utils_read_file($filename) 
{
  @$fp = fopen($filename, "r");
  if ($fp)
    {
      $val = fread($fp, filesize($filename));
      fclose ($fp);
      return $val;
    }
  return false;
}

function utils_filesize($filename, $file_size=0) 
{
  // If file size is defined, assume that we just want an unit conversion.
  if (!$file_size) 
    {   $file_size = filesize($filename); }

  if ($file_size >= 1048576) 
    {
      $file_size = round($file_size / 1048576 * 100) / 100 . _("MB");
    }
  elseif ($file_size >= 1024) 
    {
      $file_size = round($file_size / 1024 * 100) / 100 . _("KB");
    } 
  else 
    {
      $file_size = $file_size . _("B");
    }

  return $file_size;
}

function utils_fileextension($filename) 
{
 
  $ext = substr(basename($filename), strrpos(basename($filename),".") + 1);
  if ($ext==gz || $ext==bz2) 
    {
      $ext = substr(basename($filename), strrpos(basename($filename),".") - 3);
    }
  if ($ext==rpm) 
    {
      $long_ext = _("rpm package");
    }
  if ($ext==deb) 
    {
      $long_ext = _("debian package");
    }
  if ($ext==deb || $ext==rpm) 
    {
      $arch_type = substr(basename($filename), strrpos(basename($filename),".") - 3);
      if ($arch_type == "src.".$ext) 
	{
	  $long_ext = sprintf(_("source %s"), $long_ext);
	}
      if ($arch_type == "rch.".$ext) 
	{
	  $long_ext = sprintf(_("arch independant %s"), $long_ext);
	}
      if ($arch_type == "386.".$ext) 
	{
	  $long_ext = sprintf(_("%s for i386 (ix86)"), $long_ext);
	}
      if ($arch_type == "586.".$ext) 
	{
	  $long_ext = sprintf(_("%s for i586"), $long_ext);
	}
      if ($arch_type == "686.".$ext) 
	{
	  $long_ext = sprintf(_("%s for i686"), $long_ext);
	}
      if ($arch_type == "a64.".$ext) 
	{
	  $long_ext = sprintf(_("%s for Itanium 64"), $long_ext);
	}
      if ($arch_type == "arc.".$ext) 
	{
	  $long_ext = sprintf(_("%s for Sparc"), $long_ext);
	}
      if ($arch_type == "pha.".$ext) 
	{
	  $long_ext = sprintf(_("%s for Alpha"), $long_ext);
	}
      if ($arch_type == "ppc.".$ext) 
	{
	  $long_ext = sprintf(_("%s for PowerPC"), $long_ext);
	}
      if ($arch_type == "390.".$ext) 
	{
	  $long_ext = sprintf(_("%s for s390"), $long_ext);
	}
      $ext = $long_ext;
    }
  return $ext;
}

function utils_prep_string_for_sendmail($body) 
{
  $body=str_replace("\\","\\\\",$body);
  $body=str_replace("\"","\\\"",$body);
  $body=str_replace("\$","\\\$",$body);
  $body=str_replace("`","\\`",$body);
  return $body;
}

function utils_unconvert_htmlspecialchars($string) 
{
  if (strlen($string) < 1) 
    {
      return '';
    }
  else
    {
      $string=str_replace('&nbsp;',' ',$string);
      $string=str_replace('&quot;','"',$string);
      $string=str_replace('&gt;','>',$string);
      $string=str_replace('&lt;','<',$string);
      $string=str_replace('&amp;','&',$string);
      return $string;
    }
}

// transform homepage url in the same way than $project->getUrl("homepage")
// we shouldnt use this but $project->getUrl("homepage")
function utils_gethomepage($html_cvs, $isgnu, $unix_group_name) 
{
  print 'This function should not be used, report it to savannah-hackers@gnu.org';
  
}

function utils_remove_htmlheader($string) 
{
  $string = eregi_replace('(^.*<html[^>]*>.*<body[^>]*>)|(</body[^>]*>.*</html[^>]*>.*$)', '', $string);
  return $string;
}

function utils_result_column_to_array($result, $col=0) 
{
  /*
		Takes a result set and turns the optional column into
		an array
  */
  $rows=db_numrows($result);

  if ($rows > 0) 
    {
      $arr=array();
      for ($i=0; $i<$rows; $i++) 
	{
	  $arr[$i]=db_result($result,$i,$col);
	}
    }
  else
    {
      $arr=array();
    }
  return $arr;
}

function result_column_to_array($result, $col=0) 
{
  /*
		backwards compatibility
  */
  return utils_result_column_to_array($result, $col);
}

function utils_wrap_find_space($string,$wrap) 
{
  $start=$wrap-5;
  $try=1;
  $found=false;
	
  while (!$found) 
    {
      //find the first space starting at $start
      $pos=@strpos($string,' ',$start);
		
      //if that space is too far over, go back and start more to the left
      if (($pos > ($wrap+5)) || !$pos) 
	{
	  $try++;
	  $start=($wrap-($try*5));
	  //if we've gotten so far left , just truncate the line
	  if ($start<=10) 
	    {
	      return $wrap;
	    }       
	  $found=false;
	}
      else
	{
	  $found=true;
	}       
    }       
	
  return $pos;
}

function utils_line_wrap ($text, $wrap = 78, $break = "\n") 
{
  $paras = explode("\n", $text);
			
  $result = array();
  $i = 0;
  while ($i < count($paras)) 
    {
      if (strlen($paras[$i]) <= $wrap) 
	{
	  $result[] = $paras[$i];
	  $i++;
	}
      else
	{
	  $pos=utils_wrap_find_space($paras[$i],$wrap);
			
	  $result[] = substr($paras[$i], 0, $pos);
			
	  $new = trim(substr($paras[$i], $pos, strlen($paras[$i]) - $pos));
	  if ($new != '') 
	    {
	      $paras[$i] = $new;
	      $pos=utils_wrap_find_space($paras[$i],$wrap);
	    }
	  else
	    {
	      $i++;
	    }       
	}       
    }		       
  return implode($break, $result);
}

function utils_make_links ($data='',$group_id = 0) 
{
  if(empty($data)) 
    { return $data; }

  $lines = split("\n",$data);
  while ( list ($key,$line) = each ($lines)) 
    {
      // Don't mess with html links already there
      $line = eregi_replace("<a href(.*)://(.*)://(.*)</a>","<a href\\1:##\\2:##\\3</a>",$line);
      $line = eregi_replace("<a href(.*)://(.*)</a>","<a href\\1:##\\2</a>",$line);

      // Make usual links
      $line = eregi_replace("([ \t]|^)www\."," http://www.",$line);
      // FIXME: and &gt; broke the following regexp, so we do an
      // ugly convert->work->convert.
      // Please propose a better regexp.
      $line = eregi_replace("&gt;", ">--", $line);
      $line = eregi_replace("(([a-z0-9_]|\\-|\\.)+://([^[:space:]><]*)([[:alnum:]-]))", "<a href=\"\\1\">\\1</a>", $line);
      $line = eregi_replace("(([a-z0-9_]|\\-|\\.)+@([^[:space:]&><]*)([[:alnum:]-]))", "&lt;<a href=\"mailto:\\1\">\\1</a>&gt;", $line);
      $line = eregi_replace(">--", "&gt;", $line);

      // Don't mess with html links already there
      $line = eregi_replace(":##", "://", $line);

      // Links between items
      $line = eregi_replace("(bugs|bug)[ ]?#([0-9]+)", '<a href="'.$GLOBALS['sys_home']."bugs/?func=detailitem&amp;item_id=\\2\">[bugs&nbsp;#\\2]</a>", $line); 
      $line = eregi_replace("(support|sr)[ ]?#([0-9]+)", '<a href="'.$GLOBALS['sys_home']."support/?func=detailitem&amp;item_id=\\2\">[support&nbsp;#\\2]</a>", $line);
      $line = eregi_replace("task[ ]?#([0-9]+)", '<a href="'.$GLOBALS['sys_home']."task/?func=detailitem&amp;item_id=\\1\">[task&nbsp;#\\1]</a>", $line);
      $line = eregi_replace("patch[ ]?#([0-9]+)", '<a href="'.$GLOBALS['sys_home']."patch/?func=detailitem&amp;item_id=\\1\">[patch&nbsp;#\\1]</a>", $line);


  
      $lines[$key] = $line;
    }
  return join("\n", $lines);
  
}

function utils_user_link ($username, $realname=0) 
{
  if ( $username == 'None' || empty($username)) 
    { 
      return $username; 
    }
  else 
    {
      $re = '<a href="'.$GLOBALS['sys_home'].'users/'.$username.'">';
      if ($realname) 
	{
	  $re .= $realname;
	}
      else 
	{
	  $re .= $username;
	}
      $re .= '</a>';
      
      return $re;
    }
}

function utils_double_diff_array($arr1, $arr2) 
{
  // first transform both arrays in hashes
  reset($arr1); reset($arr2);
  while ( list(,$v) = each($arr1)) 
    { $h1[$v] = $v; }
  while ( list(,$v) = each($arr2)) 
    { $h2[$v] = $v; }

  $deleted = array();
  while ( list($k,) = each($h1)) 
    {
      if (!isset($h2[$k])) 
	{ $deleted[] = $k; }
    }

  $added = array();
  while ( list($k,) = each($h2)) 
    {
      if (!isset($h1[$k])) 
	{ $added[] = $k; }
    }

  return array($deleted, $added);
}

function utils_registration_history ($unix_group_name)
{
  if ($unix_group_name != "") 
    {
      $register_discard = `grep $unix_group_name /var/log/sv_register_discard.log`;
      if ($register_discard != "") 
	{
	  return '<b>Registration history:</b><br>'.nl2br($register_discard);
	}
    }
}

function show_priority_colors_key() 
{
  print '<br><br><table border=0><tr>';
  echo '<td><b>'._("Priority Colors").":</b> &nbsp;&nbsp;&nbsp;</td>\n";
	
  for ($i=1; $i<10; $i++) 
    {
      print '<td class="'.get_priority_color($i).'">'.$i."</td>\n";
    }
  print  "</tr></table>\n";
}


function get_priority_color ($index) 
{
  /*
		Return the color value for the index that was passed in
		(defined in $sys_urlroot/themes/<selected theme>/theme.php)
  */
  global $bgpri;
	
  return $bgpri[$index];
}

function build_priority_select_box ($name="priority", $checked_val="5") 
{
  /*
		Return a select box of standard priorities.
		The name of this select box is optional and so is the default checked value
  */

  echo "<select name=\"$name\">\n";
  echo '<option value="1"'.($checked_val=="1" ?" selected":"").'>1 - '._("Lowest").'</option>';
  echo '<option value="2"'.($checked_val=="2" ?" selected":"").'>2</option>';
  echo '<option value="3"'.($checked_val=="3" ?" selected":"").'>3</option>';
  echo '<option value="4"'.($checked_val=="4" ?" selected":"").'>4</option>';
  echo '<option value="5"'.($checked_val=="5" ?" selected":"").'>5 - '._("Medium").'</option>';
  echo '<option value="6"'.($checked_val=="6" ?" selected":"").'>6</option>';
  echo '<option value="7"'.($checked_val=="7" ?" selected":"").'>7</option>';
  echo '<option value="8"'.($checked_val=="8" ?" selected":"").'>8</option>';
  echo '<option value="9"'.($checked_val=="9" ?" selected":"").'>9 - '._("Highest").'</option>';
  echo '</select>';


}

// ########################################### checkbox array
// ################# mostly for group languages and environments

function utils_buildcheckboxarray($options,$name,$checked_array) 
{
  $option_count=count($options);
  $checked_count=count($checked_array);

  for ($i=1; $i<=$option_count; $i++) 
    {
      echo '
			<BR><INPUT type="checkbox" name="'.$name.'" value="'.$i.'"';
      for ($j=0; $j<$checked_count; $j++) 
	{
	  if ($i == $checked_array[$j]) 
	    {
	      echo ' CHECKED';
	    }
	}
      echo '> '.$options[$i];
    }
}

// deprecated name
function GraphResult($result,$title) 
{
  utils_graph_result($result, $title);
}

function utils_graph_result ($result,$title) 
{

  /*
	GraphResult by Tim Perdue, PHPBuilder.com

	Takes a database result set.
	The first column should be the name,
	and the second column should be the values

	####
	####   Be sure to include (HTML_Graphs.php) before hitting these graphing functions
	####
  */

  /*
		db_ should be replaced with your database, aka mysql_ or pg_
  */
  $rows=db_numrows($result);
  
  if ((!$result) || ($rows < 1)) 
    {
      echo 'None Found.';
    }
  else
    {
      $names=array();
      $values=array();

      for ($j=0; $j<db_numrows($result); $j++) 
	{
	  if (db_result($result, $j, 0) != '' && db_result($result, $j, 1) != '' ) 
	    {
	      $names[$j]= db_result($result, $j, 0);
	      $values[$j]= db_result($result, $j, 1);
	    }
	}
      
      /*
		This is another function detailed below
      */
      GraphIt($names,$values,$title);
    }
}


// deprecated name
function GraphIt ($name_string,$value_string,$title) 
{
  utils_graph_it($name_string,$value_string,$title);
}


function utils_graph_it ($name_string,$value_string,$title) 
{

  /*
		GraphIt by Tim Perdue, PHPBuilder.com
  */
  $counter=count($name_string);

  /*
		Can choose any color you wish
  */
  $bars=array();

  for ($i = 0; $i < $counter; $i++) 
    {
      $bars[$i]=$GLOBALS['COLOR_LTBACK1'];
    }

  $counter=count($value_string);

  /*
		Figure the max_value passed in, so scale can be determined
  */

  $max_value=0;

  for ($i = 0; $i < $counter; $i++) 
    {
      if ($value_string[$i] > $max_value) 
	{
	  $max_value=$value_string[$i];
	}
    }

  if ($max_value < 1) 
    {
      $max_value=1;
    }

  /*
		I want my graphs all to be 800 pixels wide, so that is my divisor
  */

  $scale=(400/$max_value);

  /*
		I create a wrapper table around the graph that holds the title
  */

  $title_arr=array();
  $title_arr[]=$title;

  echo html_build_list_table_top ($title_arr);
  echo '<TR><TD>';
  /*
		Create an associate array to pass in. I leave most of it blank
  */

  $vals =  array(
		 'vlabel'=>'',
		 'hlabel'=>'',
		 'type'=>'',
		 'cellpadding'=>'',
		 'cellspacing'=>'0',
		 'border'=>'',
		 'width'=>'',
		 'background'=>'',
		 'vfcolor'=>'',
		 'hfcolor'=>'',
		 'vbgcolor'=>'',
		 'hbgcolor'=>'',
		 'vfstyle'=>'',
		 'hfstyle'=>'',
		 'noshowvals'=>'',
		 'scale'=>$scale,
		 'namebgcolor'=>'',
		 'valuebgcolor'=>'',
		 'namefcolor'=>'',
		 'valuefcolor'=>'',
		 'namefstyle'=>'',
		 'valuefstyle'=>'',
		 'doublefcolor'=>'');

  /*
		This is the actual call to the HTML_Graphs class
  */

  html_graph($name_string,$value_string,$bars,$vals);

  echo '
		</TD></TR></TABLE>
		<!-- end outer graph table -->';
}

// deprecated name 
function ShowResultSet($result,$title="Untitled",$linkify=false)  
{
  utils_show_result_set($result,$title,$linkify);
}

function utils_show_result_set ($result,$title="Untitled",$linkify=false)  
{
  global $group_id,$HTML;
  /*
		Very simple, plain way to show a generic result set
		Accepts a result set and title
		Makes certain items into HTML links
  */

  if  ($result)  {
    $rows  =  db_numrows($result);
    $cols  =  db_numfields($result);

    echo '
			<TABLE BORDER="0" WIDTH="100%">';

    /*  Create the title  */

    echo '
		<TR BGCOLOR="'.$HTML->COLOR_HTMLBOX_TITLE.'">
		<TD COLSPAN="'.$cols.'"><B><FONT COLOR="'. $HTML->FONTCOLOR_HTMLBOX_TITLE .'">'.$title.'</FONT></B></TD></TR>';

    /*  Create  the  headers  */
    echo '
			<tr>';
    for ($i=0; $i < $cols; $i++) 
      {
	echo '<td><B>'.db_fieldname($result,  $i).'</B></TD>';
      }
    echo '</tr>';

    /*  Create the rows  */
    for ($j = 0; $j < $rows; $j++) 
      {
	echo '<TR class="'. html_get_alt_row_color($j) .'">';
	for ($i = 0; $i < $cols; $i++) 
	  {
	    if ($linkify && $i == 0) 
	      {
		$link = '<A HREF="'.$PHP_SELF.'?';
		$linkend = '</A>';
		if ($linkify == "bug_cat") 
		  {
		    $link .= 'group_id='.$group_id.'&bug_cat_mod=y&bug_cat_id='.db_result($result, $j, 'bug_category_id').'">';
		  } else if($linkify == "bug_group") 
		    {
		      $link .= 'group_id='.$group_id.'&bug_group_mod=y&bug_group_id='.db_result($result, $j, 'bug_group_id').'">';
		    } else if($linkify == "patch_cat") 
		      {
			$link .= 'group_id='.$group_id.'&patch_cat_mod=y&patch_cat_id='.db_result($result, $j, 'patch_category_id').'">';
		      } else if($linkify == "support_cat") 
			{
			  $link .= 'group_id='.$group_id.'&support_cat_mod=y&support_cat_id='.db_result($result, $j, 'support_category_id').'">';
			} else if($linkify == "pm_project") 
			  {
			    $link .= 'group_id='.$group_id.'&project_cat_mod=y&project_cat_id='.db_result($result, $j, 'group_project_id').'">';
			  }
		else
		  {
		    $link = $linkend = '';
		  }
	      }
	    else
	      {
		$link = $linkend = '';
	      }
	    echo '<td>'.$link . db_result($result,  $j,  $i) . $linkend.'</td>';

	  }
	echo '</tr>';
      }
    echo '</table>';
  }
  else
    {
      echo db_error();
    }
}


// Clean up email address (remove spaces...) and put to lower case
function utils_cleanup_emails ($addresses) 
{
  return strtolower(preg_replace("/\s/","", $addresses));
}

// Clean up email address (remove spaces...) and add @... if it is a simple
// login name
function utils_normalize_email ($address) 
{
  global $sys_users_host;
  $address = utils_cleanup_emails($address);
  if (validate_email($address))
    return $address;
  else
    return $address."@$sys_users_host";
}


function utils_antispam_email ($address) 
{
  $fakemail = preg_replace("/\\@/",' '._("--AT--").' ', $address);
  $fakemail = preg_replace("/\\./",' '._("--DOT--").' ', $fakemail);
  return $fakemail;
}

// Clean up email address (remove spaces...) and split comma separated emails
function utils_split_emails($addresses) 
{
  $addresses = utils_cleanup_emails($addresses);
  return split(',',$addresses);
}

// Email Verification
function validate_email ($address)
{
  return (ereg('^[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+'. '@'. '[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.' . '[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+$', $address));
}

// Verification of comma separated list of email addresses
function validate_emails ($addresses) 
{
  $arr = utils_split_emails($addresses);
  while (list(, $addr) = each ($arr)) 
    {
      if (!validate_email($addr)) 
	{ return false;}
    }	    
  return true;
}

function utils_is_valid_filename ($file) 
{
  if (ereg("[]~`! ~@#\"$%^,&*();=|[{}<>?/]",$file)) 
    {
      return false;
    }
  else
    {
      if (strstr($file,'..')) 
	{
	  return false;
	}
      else
	{
	  return true;
	}
    }
}
  
// alias
function util_debug ($msg)
{
  dbg($msg);
}

// alias
function debug ($msg)
{
  dbg($msg);
}

// add debugging information
function dbg ($msg)
{
  if ($GLOBALS['sys_debug_on'])
    {
      $GLOBALS['debug'] .= "<br><br>latest func called: ".ereg_replace($_SERVER["DOCUMENT_ROOT"].$GLOBALS['sys_home'], "",$GLOBALS['sys_debug_where']);
      $GLOBALS['debug'] .= "<br>msg: $msg";
    }
}


// alias
function util_feedback ($msg, $error=0)
{
  fb($msg, $error);
}

// alias
function feedback ($msg, $error=0)
{
  fb($msg, $error);
}

// add feedback information
function fb ($msg, $error=0)
{
  // Increment feedback count
  $GLOBALS['feedback_count']++;

  // Remove the dot at the end, if existing
  if (substr($msg, -1) == ".")
    {
      $msg = substr($msg, 0, (strlen($msg)-1));
    }

  // First letter capitalized, that's all
  $msg = strtoupper(substr($msg, 0, 1)).strtolower(substr($msg, 1, strlen($msg))).' [#'.$GLOBALS['feedback_count'].']'._("; ");

  // feed  
  if (!$error)
    {
      dbg("Add feedback #".$GLOBALS['feedback_count']);
      $GLOBALS['feedback'] .= $msg;
    }
  else
    {
      dbg("Add feedback #".$GLOBALS['feedback_count']);
      $GLOBALS['ffeedback'] .= $msg;
    }
}

// alias
function util_help ($text, $explanation_array)
{
  help($text, $explanation_array);
}

// print help about a word
//   $text  is the sentence where ballons are
//   $explanation_array is the table word->explanation, must be in the 
//   array syntax.
function help ($text, $explanation_array)
{
  while (list($word,$explanation) = each($explanation_array))
    {
      $text = str_replace($word,
			     '<font class="help" title="'.$explanation.'">'.$word.'</font>', 
			     $text);
    }
  return $text;
}

?>