<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: mod.php,v 1.3 2004/01/31 00:56:19 yeupou Exp $
//
//
// Copyright 1999-2000 (c) The SourceForge Crew
//
//
//  Copyright 2000-2003 (c) Free Software Foundation
//                          Laurent Julliard, CodeX Team, Xerox
//
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//

// Need search functions.
require_directory("search");

$sql="SELECT * FROM ".ARTIFACT." WHERE bug_id='$item_id' AND group_id='$group_id'";
$fields_per_line=2;
$max_size=40;

$result=db_query($sql);

if (db_numrows($result) > 0) 
{
  
  // Prepare all the necessary fields in case the user wants to 
  // Create a new task based on this bug
  
  // assigned_to is passed along
  $assigned_to = db_result($result,0,'assigned_to');

  // Check if hours is used. If so pass it along as well
  if ( trackers_data_is_used('hours') ) 
    {
      $hours = db_result($result,0,'hours');
    } 
  else 
    {
      $hours = '';
    }
    
  // Insert a reference to the originating bug in the task description
  $task_details = db_result($result,0,'details')."\n\nSee ".ARTIFACT." #$item_id\nhttp://".
     $GLOBALS['sys_default_domain']."/bugs/?func=detailitem&item_id=$item_id&group_id=$group_id";

  trackers_header(array ('title'=>_("Modify an Item"),
			 'create_task'=>'Create task',
			 'summary' => db_result($result,0,'summary'),
			 'details' => $task_details,
			 'assigned_to' => $assigned_to,
			 'hours' => $hours,
			 'item_id' => $item_id
			 ));

  // ################################ Check if the user have a specific role

  if (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'2', 1))
    { 
      print help(_("You are both technician and manager for this tracker."),
		 array(
		       _("technician")=>_("can be assigned items, cannot change status or priority"),	       
		       _("manager")=>_("fully manage the items")
		       ));

    }
  elseif (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'1', 1))
    { 
      print help(_("You are technician for this tracker."),
		 array(
		       _("technician")=>_("you can be assigned tracker's items, but you cannot reassign items, change their status or priority")
		       ));
    }
  elseif (member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'3', 1))
    { 
      print help(_("You are manager for this tracker."),
		 array(
		       _("manager")=>_("you can fully manage the trackers items, including assigning items to technicians, reassign items over trackers and projects, changing priority and status of items")
		       ));
    }

  // ################################ Start the form

  print '
    <h2>['.ARTIFACT.' #'.$item_id.'] '.db_result($result,0,'summary').'</h2>

    <form action="'.$PHP_SELF.'" method="post" enctype="multipart/form-data" name="item_form">
    <input type="hidden" name="func" value="postmoditem">
    <input type="hidden" name="group_id" value="'.$group_id.'">
    <input type="hidden" name="item_id" value="'.$item_id.'">

    <table cellpadding="0" width="100%">
      <tr>
          <td class="preinput">'._("Submitted by:").'&nbsp;</td><td>'.utils_user_link(user_getname(db_result($result,0,'submitted_by')), user_getrealname(db_result($result,0,'submitted_by'))).'</td>
          <td colspan="6" align="center" valign="top" class="bold"><input type="submit" name="submit" value="'._("Submit Changes").'"></td>
      </tr>
      <tr>
          <td class="preinput">'._("Submitted on:").'&nbsp;</td><td>'.format_date($sys_datefmt,db_result($result,0,'date')).'</td>
          <td>&nbsp;</td>
      </tr>';
	  
  $field_per_linex2=2*$fields_per_line;
  print '<tr><td colspan="'.$fields_per_linex2.'">&nbsp</td></tr>';

  // Now display the variable part of the field list (depend on the project)
    
  $i=0;
  while ($field_name = trackers_list_all_fields()) 
    {

      
      // if the field is a special field (except summary and details) 
      // or if not used by this project  then skip it.
      if ((!trackers_data_is_special($field_name) || $field_name=='summary' || $field_name=='details') &&
	  trackers_data_is_used($field_name)) 
	{
				   
	  // display the bug field
	  // if field size is greatest than max_size chars then force it to
	  // appear alone on a new line or it won't fit in the page

	  // Look for the field value in the database only if we missing
	  // its values. If we already have a value, we are probably in
	  // step 2 of a search on item/group (dependancy, reassignation).
	  if (!$$field_name)
	    { $field_value = db_result($result,0,$field_name); }
	  else
	    { $field_value = $$field_name; }

	  list($sz,) = trackers_data_get_display_size($field_name);
	  $label = trackers_field_label_display($field_name,$group_id,false,false);
	  // original submission field must be displayed read-only
	  // assigned_to, status_id and priority too, for technicians
	  // (if super_user, do nothing)
	  if (!user_is_super_user())
	    { $mbcheck = member_check(0,$group_id,member_create_tracker_flag(ARTIFACT).'1', 1); }
	   
	  if ($field_name =='details' || 
	      $mbcheck && $field_name =='status_id' ||
	      $mbcheck && $field_name =='assigned_to' ||
	      $mbcheck && $field_name =='priority') 
	    { 
	      dbg("field_name:$field_name is read-only, mbcheck_is_not_manager:$mbcheck_is_not_manager");
	      $value = utils_make_links(trackers_field_display($field_name,$group_id,$field_value,false,false,true),$group_id);
	    }
	  else
	    {
	      $value = trackers_field_display($field_name,$group_id,$field_value,false,false);
	    }
	  $star = (trackers_data_is_empty_ok($field_name) ? '':'<font class="error"> *</font>');

	  if ($sz > $max_size) 
	    {
	      print "\n<tr>".
		'<td valign="middle">'.$label.$star.'</td>'.
		'<td valign="middle" colspan="'.(2*$fields_per_line-1).'">'.
		$value.'</td>'.		      
		"\n</tr>";
	      $i=0;
	    } 
	  else 
	    {
	      print ($i % $fields_per_line ? '':"\n<tr>");
	      print '<td valign="middle">'.$label.$star.'</td>'.
		'<td valign="middle">'.$value.'</td>';
	      $i++;
	      print ($i % $fields_per_line ? '':"\n</tr>");
	    }
	}
    }
      
  print '</table>';
  print '<p>&nbsp;</p>';

  // ################################ Comments 

  print '<h3>' ._("Follow-up Comments").'</h3>';
  print '<table>
          <tr><td class="preinput">'
    ._("Use a Canned Response:").'&nbsp;</td><td width="70%">';

  print trackers_canned_response_box ($group_id,'canned_response');

  print '&nbsp;&nbsp;&nbsp;<a class="smaller" href="'.$GLOBALS['sys_home'].ARTIFACT.'/admin/field_values.php?group_id='.$group_id.'&create_canned=1">['._("Or define a new Canned Response").']</a>';

  print '</td></tr><tr><td class="preinput">';
  print _("Comment Type:");
  print '</td><td>';
  print trackers_field_box('comment_type_id',$comment_type_id,$group_id,'',true,'None');
  print '</td></tr></table>';

  print '<p>';      
  printf (_("(Note: you can add pointers to others items by typing %s where %s is one of %s and %s the item id number.)"), 
	  "<font class=\"italic\">tracker #nnn</font>",
	  "<font class=\"italic\">tracker</font>",
	  "<font class=\"italic\">support, bugs, task, patch</font>",
	  "<font class=\"italic\">nnn</font>");

  print '<p>';      
  print trackers_field_textarea('details',$details); 
  print '<p>';

  print show_item_details($item_id,$group_id);

  print '</p>&nbsp;<p>';

  // ################################ Attached Files

  print '<h3>'._("Attached Files").'</h3>';
  
  print '<font class="preinput"> '._("Attach File:").'</font><br>
      &nbsp;&nbsp;&nbsp;<input type="file" name="input_file" size="40">
      <br>
      <font class="preinput">'._("File Description:").'</font><br>
      &nbsp;&nbsp;&nbsp;<input type="text" name="file_description" size="60" maxlength="255">
      </p><p>';
	  
  show_item_attached_files($item_id,$group_id);

  print '</p>&nbsp;<p>';

  // ################################ Mail notification

  print '<h3>'._("Mail Notification Carbon-Copy List").'</h3>';
  
  printf (_("(Note: for %s users, you can use their login name rather than their email addresses.)"), $GLOBALS['sys_name']);

  print '<p><font class="preinput">'
    ._("Add an email address that should receive carbon copies of updates of this item:").'</font><br>&nbsp;&nbsp;&nbsp;<input type="text" name="add_cc" size="40" value="'.$add_cc.'">&nbsp;&nbsp;&nbsp;
        <br>
        <font class="preinput">'
    ._("Comment:").'</font><br>&nbsp;&nbsp;&nbsp;<input type="text" name="cc_comment" size="40" maxlength="255" value="'.$cc_comment.'">';
  print '<p></p>';
  show_item_cc_list($item_id, $group_id);

  print '<p>&nbsp;</p>';

  // ################################ Dependencies

  print '<h3>'._("Dependencies").'</h3>';
  print '<font class="preinput">';
  if (!$depends_search) 
    { print _("Search an item (to fill a dependancy against):"); }
  else 
    { 
      // Print a specific message if we are already at step 2 of filling
      // a dependency.
      print _("New search, in case the previous one was not satisfactory (to fill a dependancy against):");
    }

  print '</font><br>
      &nbsp;&nbsp;&nbsp;<input type="text" name="depends_search" size="40" maxlength="255"><br>';
  
  
  function specific_depends_on_artifact ($art, $content)
    { 
      // Function too trivial to generalized in usual includes.
      if (ARTIFACT == $art) 
	{ $checked = " selected"; }
      print '<option value="'.$art.'"'.$checked.'>'.$content.'</option>'; 
      unset($checked);
    }
      
  print '<font class="preinput">'._("Of:").'</font><br>
&nbsp;&nbsp;&nbsp;<select name="depends_search_only_artifact">
<option value="all">'._("Any Trackers").'</option>';

  specific_depends_on_artifact("support", _("the Support Tracker Only"));
  specific_depends_on_artifact("bugs", _("the Bug Tracker Only"));
  specific_depends_on_artifact("task", _("the Task Tracker Only"));
  specific_depends_on_artifact("patch", _("the Patch Tracker Only"));

  print '</select> ';
  print _("of");
  print ' <select name="depends_search_only_project">
   <option value="any">'._("Any Project").'</option>
   <option value="notany" selected>'._("this Project Only").'</option>
   </select>&nbsp;';

  if (!$depends_search) 
    { 
      print '<input type="submit" name="submit" class="bold" value="'._("Search").'">'; 
    }
  else 
    { 
      // Print a specific message if we are already at step 2 of filling
      // a dependency.
      print '<input type="submit" name="submit" class="bold" value="'._("New Search").'">';
    }

  // Search results, if we are already at step 2 of filling
  if ($depends_search)
    {     
      print '</p><p><font class="preinput">';
      printf (_("Please select a dependancy to add in the result of your search of '%s' in the database:"), $depends_search);
      print '</font>';

      unset($success);

      // If we have less than 4 characters, to avoid giving lot of feedback
      // and put an exit to the report, just consider the search as a failure.
      if (strlen($depends_search) > 3)
	{
	  
	  // Build the list of trackers to take account of.	  
	  if ($depends_search_only_artifact == "all")
	    { $artifacts = array("support", "bugs", "task", "patch"); }
	  else 
	    { $artifacts = array($depends_search_only_artifact); }
	  
	  // Actually search on each asked trackers.
	  while (list($num, $tracker) = each($artifacts)) 
	    { 
	      if ($depends_search_only_project == "notany") 
		{ $search_without_group_id = 0; }
	      else
		{ $search_without_group_id = 1; }
	      
	      $result_search = search_run($depends_search, $tracker, 0);
	      $success = db_numrows($result_search) + $success;

	      // Print the result, if existing.
	      if (db_numrows($result_search) != 0) 
		{
		  while (list($res_id, $res_summary, $res_date, $res_user, $res_group)  = db_fetch_array($result_search))
		    {
		      // Avoid item depending on itself.
		      if ($res_id != $item_id || $tracker != ARTIFACT)
			{			  
			  // Right now only print id, summary and group.
			  // We may change that depending on users feedback.
			  print '<br>';
			  print '&nbsp;&nbsp;&nbsp;<input type="checkbox" name="dependent_on_'.$tracker.'[]" value="'.$res_id.'">['.$tracker.' #'.$res_id.'] '.$res_summary.', '._("group").' '.group_getname($res_group);
			}
		    }
		}
	    }
	}
      if (!$success)
	{
	  print '<br><font class="warn">';
	  print _("None found. Please note that only search words of more than three characters are valid.");
	  print '</font>';
	}
      
    }


  print '<p></p>';


  print show_item_dependency($item_id);

  print '<p></p>';

  print show_dependent_item($item_id);

  print '<p>&nbsp;</p>';

  // ################################ Reassign an item, if manager of the tracker

  if (member_check(0,$group_id, member_create_tracker_flag(ARTIFACT).'3'))
    {
      print '<h3>'._("Reassign this item").'</h3>';
        
      print '<p><font class="preinput">'
	._("Move to the:").'</font><br>&nbsp;&nbsp;&nbsp;';

      function specific_reassign_artifact ($art, $content)
	{
	  // Function too trivial to generalized in usual includes.
	  if (!$GLOBALS[reassign_change_artifact] && ARTIFACT == $art || $GLOBALS[reassign_change_artifact] == $art) 
	    { $checked = " selected"; }
	  print '<option value="'.$art.'"'.$checked.'>'.$content.'</option>'; 
	  unset($checked);
	}
      print '<select name="reassign_change_artifact">';
      specific_reassign_artifact("support", _("Support Tracker"));
      specific_reassign_artifact("bugs", _("Bugs Tracker"));
      specific_reassign_artifact("task", _("Task Tracker"));
      specific_reassign_artifact("patch", _("Patch Tracker"));
      print '</select>';

      print '<br><br>
        <font class="preinput">';

      if (!$reassign_change_project_search) 
	{  print _("Move to the project:"); }
      else 
	{ 
	  // Print a specific message if we are already at step 2 of
	  // reassignation to another project.
	  print _("New search, in case the previous one was not satisfactory (to reassign the item to another project):");
	}

      print '</font><br>&nbsp;&nbsp;&nbsp;<input type="text" name="reassign_change_project_search" size="40" maxlength="255">';
      if (!$reassign_change_project_search) 
	{ 
	  print ' <input type="submit" name="submit" class="bold" value="'._("Search").'">'; 
	}
      else 
	{ 
	  // Print a specific message if we are already at step 2 of filling
	  // a ressign.
	  print ' <input type="submit" name="submit" class="bold" value="'._("New Search").'">';
	}
      

      // Search results, if we are already at step 2 of filling
      if ($reassign_change_project_search)
	{     
	  print '</p><p><font class="preinput">';
	  printf (_("To which project this bug should be reassigned to? This is the result of your search of '%s' in the database:"), $reassign_change_project_search);
	  print '</font>';

	  // Print a null-option, someone may change his mine without having
	  // to use the back button of his browser.
	  print '<br>&nbsp;&nbsp;&nbsp;<input type="radio" name="reassign_change_project" value="0" checked> '._("Do not reassign to another project.");
	  
	  unset($success);
	  $result_search = search_run($reassign_change_project_search, "soft", 0);
	  $success = db_numrows($result_search);
	  
	  // Print the result, if existing.
	  if (db_numrows($result_search) != 0) 
	    {
	      while (list($res_group_name, $res_unix_group_name, $res_group_id)  = db_fetch_array($result_search))
		{
		  // Not reassigning to itself.
		  if ($res_unix_group_name != $group_name)
		    {			  
		      print '<br>';
		      print '&nbsp;&nbsp;&nbsp;<input type="radio" name="reassign_change_project" value="'.$res_unix_group_name.'"> ['.$res_unix_group_name.', #'.$res_group_id.'] '.$res_group_name;
		    }
		}
	    }
	  
	  if (!$success)
	    {
	      print '<br><font class="warn">';
	      print _("None found. Please note that only search words of more than three characters are valid.");
	      print '</font>';
	    }
	  
	}  
    }



  //  ################################ Submit 
  
  print '<p align="center"><input type="submit" name="submit" class="bold" value="'._("Submit Changes").'"></form><p>';
  
  
  // ################################ History  
  // May require in the future to think about only showing recent changes.

  print '<p>&nbsp;</p><p>&nbsp;</p>';
  print show_item_history($item_id,$group_id);

} 

trackers_footer(array());

?>
