<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: general.php,v 1.4 2004/02/03 15:51:09 yeupou Exp $
//
// 
// Copyright 1999-2000 (c) The SourceForge Crew
// Copyright 2000-2003 (c) Free Software Foundation
//                         Laurent Julliard, CodeX Team, Xerox
// Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gnu.org>
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//

/*

Bug Tracker
	By Tim Perdue, Sourceforge, 11/99
	Heavy rewrite by Tim Perdue, April 2000
	Very heavy rewrite by Laurent Julliard 2001, 2002, CodeX Team, Xerox
        Heavy extended by GNU Savannah team + CERN
*/

// Return the file that should be included, according to the URL
// requested. If the file start with ?, it's an index.
function trackers_include() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_include() ';
  // Keep the dirname only if it's admin
  $dir = get_module_include_dir($GLOBALS['PHP_SELF'], 0, 1);
  if ($dir != "admin") 
    { 
      unset($dir); 
    }
  else 
    { 
      $dir = $dir."/";
      $pre = "../";
    }
 
  return $pre."../include/trackers_run/".$dir.basename($GLOBALS['PHP_SELF']);
}

// Generate URL arguments from a variable wether scalar or array
function trackers_convert_to_url_arg($varname, $var)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_convert_to_url_arg($varname, $var)';

  if (is_array($var))
    {
      reset($var);
      while (list(,$v) = each($var))
	{
	  $ret .= '&'.$varname.'[]='.$v;
	}
    }
  else
    {
      $ret .= '&'.$varname.'='.$var;
    }
  return $ret;
}

function trackers_header($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_header($params)';
  global $group_id,$is_bug_page,$DOCUMENT_ROOT,$advsrch;

  //used so the search box will add the necessary element to the pop-up box
  $is_bug_page=1;

  //required params for site_project_header();
  $params['group']=$group_id;
  $params['toptab']=ARTIFACT;
	
  $project=project_get_object($group_id);

  //needs to be turned  on
  if (ARTIFACT == "bugs"  && !$project->Uses("bugs") ||
      ARTIFACT == "support" &&  !$project->Uses("support") ||
      ARTIFACT == "task" && !$project->Uses("task") ||
      ARTIFACT == "patch" && !$project->Uses("patch"))
    {
      exit_error(_("This project has turned off this tracker."));
    }
  echo site_project_header($params);

}

function trackers_header_admin($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_header_admin($params)';
  global $group_id,$is_bug_page,$DOCUMENT_ROOT;

  //used so the search box will add the necessary element to the pop-up box
  $is_bug_page=1;
    
  //required params for site_project_header();
  $params['group']=$group_id;
  $params['toptab']='a'.ARTIFACT;
    
  $project=project_get_object($group_id);
    
  // need to be turned on
  if (ARTIFACT == "bugs"  && !$project->Uses("bugs") ||
      ARTIFACT == "support" &&  !$project->Uses("support") ||
      ARTIFACT == "task" && !$project->Uses("task") ||
      ARTIFACT == "patch" && !$project->Uses("patch"))
    {
      exit_error(_("This project has turned off this tracker."));
    }
  echo site_project_header($params);
}

function trackers_footer($params)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_footer($params)';
  site_project_footer($params);
}

function trackers_init($group_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_init($group_id)';
  // Set the global arrays for faster processing at init time
  trackers_data_get_all_fields($group_id, true);
}

function trackers_report_init($group_id, $report_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_report_init($group_id, $report_id)';
  // Set the global array with report information for faster processing
  trackers_data_get_all_report_fields($group_id, $report_id, true);
}

function trackers_list_all_fields($sort_func=false,$by_field_id=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_list_all_fields($sort_func=false,$by_field_id=false)';
  global $BF_USAGE_BY_ID, $BF_USAGE_BY_NAME, $AT_START;

  // If it's the first element we fetch then apply the sort
  // function  
  if ($AT_START)
    {
      if (!$sort_func)
	{ $sort_func = cmp_place; }
      uasort($BF_USAGE_BY_ID, $sort_func);
      uasort($BF_USAGE_BY_NAME, $sort_func);
      $AT_START=false;
    }

  // return the next bug field in the list. If the global
  // bug field usage array is not set then set it the
  // first time.
  // by_field_id: true return the list of field id, false returns the
  // list of field names

  if ( list($key, $field_array) = each($BF_USAGE_BY_ID))
    {
      return($by_field_id ? $field_array['bug_field_id'] : $field_array['field_name']);
    }
  else
    {
      // rewind internal pointer for next time
      reset($BF_USAGE_BY_ID);
      reset($BF_USAGE_BY_NAME);
      $AT_START=true;
      return(false);
    }
}

function trackers_field_label_display($field_name, $group_id,$break=false,$ascii=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_field_label_display($field_name, $group_id,$break=false,$ascii=false)';
  $output = trackers_data_get_label($field_name).': ';

  if (!$ascii) 
    { $output = '<font class="preinput"><font class="help" title="'.trackers_data_get_description($field_name).'">'.$output.'</font></font>'; }
  if ($break) 
    { $output .= ($ascii?"\n":'<br>'); }
  else
    { $output .= ($ascii? ' ':'&nbsp;'); }
  return $output;
}

function trackers_field_display ($field_name, 
				 $group_id, 
				 $value='xyxy',
				 $break=false, 
				 $label=true, 
				 $ro=false, 
				 $ascii=false, 
				 $show_none=false, 
				 $text_none='None',
				 $show_any=false, 
				 $text_any='Any')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_field_display  ';			

  /*
          Display a bug field either as a read-only value or as a read-write 
          making modification possible
          - field_name : name of the bug field (column name)
          - group_id : the group id (project id)
          - value: the current value stored in this field (for select boxes type of field
                  it is the value_id actually. It can also be an array with mutliple values.
          - break: true if a break line is to be inserted between the field label
                 and the field value
          - label: if true display the field label.
          - ro: true if only the field value is to be displayed. Otherwise
                 display an HTML select box, text field or text area to modify the value
          - ascii: if true do not use any HTML decoration just plain text (if true
                 then read-only (ro) flag is forced to true as well)
          - show_none: show the None entry in the select box if true (value_id 100)
          - text_none: text associated with the none value_id to display in the select box
          - show_any: show the Any entry in the select box if true (value_id 0)
          - text_any: text associated with the any value_id  tp display in the select box
  */
  global $sys_datefmt;

  if ($label)
    {
      $output = trackers_field_label_display($field_name,$group_id,$break,$ascii);
    }

  // display depends upon display type of this field
  switch (trackers_data_get_display_type($field_name))
    {

    case 'SB':
      if ($ro)
	{

	  // if multiple selected values return a list of <br> separated values
	  $arr = ( is_array($value) ? $value : array($value));
	  for ($i=0;$i < count($arr); $i++)
	    {
	      if ($arr[$i] == 0 )
		$arr[$i] = $text_any;
	      else if ($arr[$i] == 100 )
		$arr[$i] = $text_none;
	      else 
		$arr[$i] = trackers_data_get_value($field_name,$group_id,$arr[$i]);
	    }

	  $output .= join('<br>', $arr);

	}
      else
	{
	  // If it is a user name field (assigned_to, submitted_by) then make
	  // sure to add the "None" entry in the menu 'coz it's not in the DB
	  if (trackers_data_is_username_field($field_name))
	    {
	      $show_none=true;
	      $text_none='None';
	    }
	
	  if (is_array($value))
	    $output .= trackers_multiple_field_box($field_name,'',$group_id, $value,
						   $show_none,$text_none,$show_any,
						   $text_any);
	  else
	    $output .= trackers_field_box($field_name,'',$group_id, $value,
					  $show_none,$text_none,$show_any,
					  $text_any);
	}
      break; 

    case 'DF':
      if ($ascii) 
	$output .= ( ($value == 0) ? '' : format_date($sys_datefmt,$value));
      else
	if ($ro)
	  {
	    $output .= format_date($sys_datefmt,$value);
	  }
	else
	  {
	    $output .= trackers_field_date($field_name,
					   (($value == 0) ? '' : format_date("Y-m-j",$value,'')));
	  }
      break;

    case 'TF':
      if ($ascii) 
	$output .= utils_unconvert_htmlspecialchars($value);
      else
	$output .= ($ro ? $value: trackers_field_text($field_name,$value));
      break;

    case 'TA':
      if ($ascii) 
	$output .= utils_unconvert_htmlspecialchars($value);
      else
	$output .= ($ro ? nl2br($value):trackers_field_textarea($field_name,$value));
      break;

    default:
      $output .= 'Unknown '.ARTIFACT.' Field Display Type';
    }

  return($output);
}

function trackers_field_date($field_name,$value='',$size=0,$maxlength=0,$ro=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_field_date';

  // value is formatted as Y-m-d
  list($year, $month, $day) = split("-", $value);

  if ($ro)
    { 
      $html = $value;
    }
  else
    {
      if (!$size || !$maxlength)
	{ list($size, $maxlength) = trackers_data_get_display_size($field_name); }

      // date part are missing, take the date of the day
      $today = localtime();
      if (!$day)
	{ $day = ($today[3]); }
      if (!$month)
	{ $month = ($today[4]+1); }
      if (!$year)
	{ $year = ($today[5]+1900); }      

      // FIXME: order of year/day/month must be local specific
      $html = calendar_selectbox("day", $day, $field_name.'_dayfd').calendar_selectbox("month", $month, $field_name.'_monthfd').' <input type="text" name="'.$field_name.'_yearfd" size="4" maxlenght="4" value="'.$year.'">';
    }
  return($html);

}

function trackers_multiple_field_date($field_name,$date_begin='',$date_end='',$size=0,$maxlength=0,$ro=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_multiple_field_date';

  // CAUTION!!!! The Javascript below assumes that the date always appear
  // in a field called 'bug_form'
  
  // FIXME: this is broken, should be made as trackers_field_date

  if ($ro)
    if ($date_begin || $date_end)
      $html = "Start:&nbsp;$date_begin<br>End:&nbsp;$date_end";
    else
      $html = 'Any time';
  else
    {
      if (!$size || !$maxlength)
	list($size, $maxlength) = trackers_data_get_display_size($field_name);

      $html = 'Start:<br><INPUT TYPE="text" name="'.$field_name.
	 '" size="'.$size.'" MAXLENGTH="'.$maxlength.'" VALUE="'.$date_begin.'">'.
	 '<a href="javascript:show_calendar(\'document.bug_form.'.$field_name.'\', document.bug_form.'.$field_name.'.value);">'.
	 '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/task.png" border="0" alt="'._("Click Here to Pick up a date").'"></a>'.
	 '</td></tr><tr><td>'.
	 'End:<br><INPUT TYPE="text" name="'.$field_name.'_end'.
	 '" size="'.$size.'" MAXLENGTH="'.$maxlength.'" VALUE="'.$date_end.'">'.
	 '<a href="javascript:show_calendar(\'document.bug_form.'.$field_name.'_end\', document.bug_form.'.$field_name.'_end.value);">'.
	 '<img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/task.png" border="0" alt="'._("Click Here to Pick up a date").'"></a>';
    
      $html = '<table><tr><td>'.$html.'</td></tr></table>';
    }

  return($html);

}

function trackers_field_date_operator($field_name,$value='',$ro=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_field_date_operator ';

  if ($ro) 
    $html = htmlspecialchars($value);
  else
    $html = '<SELECT name="'.$field_name.'_op">'.
      '<OPTION VALUE=">"'.(($value == '>') ? ' SELECTED':'').'>&gt;</OPTION>'.
      '<OPTION VALUE="="'.(($value == '=') ? ' SELECTED':'').'>=</OPTION>'.
      '<OPTION VALUE="<"'.(($value == '<') ? ' SELECTED':'').'>&lt;</OPTION>'.
      '</SELECT>';
  return($html);

}

function trackers_field_text($field_name,$value='',$size=0,$maxlength=0)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_field_text';

  if (!$size || !$maxlength)
    list($size, $maxlength) = trackers_data_get_display_size($field_name);

  $html = '<INPUT TYPE="text" name="'.$field_name.
     '" size="'.$size.'" MAXLENGTH="'.$maxlength.'" VALUE="'.$value.'">';
  return($html);

}

function trackers_field_textarea($field_name,$value='',$cols=0,$rows=0)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_field_textarea ';

  if (!$cols || !$rows)
    list($cols, $rows) = trackers_data_get_display_size($field_name);

  $html = '<textarea name="'.$field_name.
     '" rows="'.$rows.'" cols="'.$cols.'" wrap="soft">'.$value.'</textarea>';
  return($html);

}

function trackers_field_box($field_name,$box_name='',$group_id,$checked=false,$show_none=false,$text_none='None',$show_any=false, $text_any='Any')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_field_box ';

  /*
      Returns a select box populated with field values for this project
      if box_name is given then impose this name in the select box
      of the  HTML form otherwise use the field_name)
  */
  if (!$group_id)
    {
      return 'ERROR - no group_id';
    }
  else
    {
      $result = trackers_data_get_field_predefined_values($field_name,$group_id,$checked);

      if ($box_name == '')
	{
	  $box_name = $field_name;
	}
      return html_build_select_box ($result,$box_name,$checked,$show_none,$text_none,$show_any, $text_any);
    }
}

function trackers_multiple_field_box($field_name,$box_name='',$group_id,$checked=false,$show_none=false,$text_none='None',$show_any=false, $text_any='Any',$show_value=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_multiple_field_box )';

  /*
      Returns a multiplt select box populated with field values for this project
      if box_name is given then impose this name in the select box
      of the  HTML form otherwise use the field_name)
  */
  if (!$group_id)
    {
      return 'ERROR - no group_id';
    }
  else
    {
      $result = trackers_data_get_field_predefined_values($field_name,$group_id,$checked);

      if ($box_name == '')
	{
	  $box_name = $field_name.'[]';
	}
      return html_build_multiple_select_box($result,$box_name,$checked,6,$show_none,$text_none, $show_any,$text_any,$show_value);
    }
}

function trackers_extract_field_list($post_method=true)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_extract_field_list($post_method=true)';

  global $HTTP_GET_VARS, $HTTP_POST_VARS, $BF_USAGE_BY_NAME;
  /* 
       Returns the list of field names in the HTML Form corresponding to a
       field used by this project
  */

  // Specific: it must build the date fields if it finds _dayfd, _monthfd
  // or _yearfd, because date fields comes from 3 separated input.
  $vfl = array();
  $date = array();
  if ($post_method)
    {
      reset($HTTP_POST_VARS);
      while ( list($key, $val) = each($HTTP_POST_VARS))
	{
	  if (preg_match("/^(.*)_(day|month|year)fd$/", $key, $found))
	    {	      
	      // Must build the date field key.
	      $field_name = $found[1];
	      $field_name_part = $found[2];

	      // We also must increment $day and $month, because the select
	      // start from zero

	      // get what we already have
	      list($year, $month, $day) = split("-", $vfl[$field_name]);
	      if ($field_name_part  == 'day')
		{ $vfl[$field_name] = "$year-$month-".($val+1); }
	      elseif ($field_name_part == 'month')
		{ $vfl[$field_name] = "$year-".($val+1)."-$day"; }
	      elseif ($field_name_part == 'year')
		{ $vfl[$field_name] = "$val-$month-$day"; }
	    }
	  elseif (isset($BF_USAGE_BY_NAME[$key]))
	    {
	      $vfl[$key] = $val;
	    }
	  else
	    {
	      //dbg("Rejected key = ".$key." val = $val");
	    }
	}
    }
  else
    {
      reset($HTTP_GET_VARS);
      while ( list($key, $val) = each($HTTP_GET_VARS))
	{
	  if (preg_match("/^(.*)_(day|month|year)fd$/", $key, $found))
	    {	      
	      // Must build the date field key.
	      $field_name = $found[1];
	      $field_name_part = $found[2];

	      // get what we already have
	      list($year, $month, $day) = split("-", $vfl[$field_name]);
	      if ($field_name_part  == 'day')
		{ $vfl[$field_name] = "$year-$month-$val"; }
	      elseif ($field_name_part == 'month')
		{ $vfl[$field_name] = "$year-$val-$day"; }
	      elseif ($field_name_part == 'year')
		{ $vfl[$field_name] = "$val-$month-$day"; }
	    }
	  elseif (isset($BF_USAGE_BY_NAME[$key]))
	    {
	      $vfl[$key] = $val;
	    }
	  else
	    {
	      dbg("Rejected key = ".$key." val = $val");
	    }
	}

    }
  return($vfl);
}

function trackers_check_empty_fields($field_array)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_check_empty_fields($field_array)';

  /*
      Check whether empty values are allowed for the bug fields
      Params:
      field_array: associative array of field_name -> value
  */
  global $feedback, $ffeedback;

  $bad_fields = array();
  reset($field_array);
  while ( list($key, $val) = each($field_array))
    {
      $is_empty = (trackers_data_is_select_box($key) ? ($val==100) : ($val==''));
      // Only the field percent_complete is allowed to use the special value
      // hundred.
      // FIXME: maybe it should not use that value at all, however it would
      // require one more database migration. Something that should indeed be
      // done if at some point we feel the need for one more exception.
      if ( $is_empty && !trackers_data_is_empty_ok($key) && $key != "percent_complete")
	{
	  
	  $bad_fields[] = trackers_data_get_label($key);
	}
    }

  if (count($bad_fields) > 0)
    {
      $ffeedback = sprintf(_("Missing fields: %s. Empty values for the above listed field(s) are not allowed. Click on the Back arrow of your browser and try again"), join(', ',$bad_fields));

      return false;
    }
  else
    {
      return true;
    }

}

function trackers_canned_response_box ($group_id,$name='canned_response')
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_canned_response_box ';
  if (!$group_id)
    {
      return 'ERROR - No group_id';
    }
  else
    {
      $result=trackers_data_get_canned_responses($group_id);
      return html_build_select_box ($result,$name);
    }
}

function trackers_build_notification_matrix($user_id)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_build_notification_matrix($user_id)';
  // Build the notif matrix indexed with roles and events labels (not id)
  $res_notif = trackers_data_get_notification_with_labels($user_id);
  while ($arr = db_fetch_array($res_notif))
    {
      $arr_notif[$arr['role_label']][$arr['event_label']] = $arr['notify'];
    }
  return $arr_notif;
}


function trackers_check_notification($user_id, $role, $changes=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_check_notification($user_id, $role, $changes=false)';

  $send = false;
  $arr_notif = trackers_build_notification_matrix($user_id);
  if (!$arr_notif)
    { return true; }

  //echo "==== DBG Checking Notif. for $user_id (role=$role)<br>";
  $user_name = user_getname($user_id);

  //----------------------------------------------------------
  // If it's a new bug only (changes is false) check the NEW_ITEM event and
  // ignore all other events
  if ($changes==false)
    {
      if ($arr_notif[$role]['NEW_ITEM'])
	{
	  //echo "DBG NEW_ITEM notified<br>";
	  return true;
	}
      else
	{
	  //echo "DBG No notification<br>";
	  return false;
	}
    }

  //----------------------------------------------------------
  //Check: I_MADE_IT  (I am the author of the change )
  // Check this one first because if the user said no she doesn't want to be 
  // aware of any of her change in this role and we can return immediately.
  if (($user_id == user_getid()) && !$arr_notif[$role]['I_MADE_IT'])
    {
      //echo "DBG Dont want to receive my own changes<br>";
      return false;
    }
    
  //----------------------------------------------------------
  // Check :  NEW_COMMENT  A new followup comment is added 
  if ($arr_notif[$role]['NEW_COMMENT'] && isset($changes['details']))
    {
      //echo "DBG NEW_COMMENT notified<br>";
      return true;
    }

  //----------------------------------------------------------
  //Check: NEW_FILE  (A new file attachment is added)
  if ($arr_notif[$role]['NEW_FILE'] && isset($changes['attach']))
    {
      //echo "DBG NEW_FILE notified<br>";
      return true;
    }
  
  //----------------------------------------------------------
  //Check: CLOSED  (The bug is closed)
  // Rk: this one has precedence over PSS_CHANGE. So notify even if PSS_CHANGE
  // says no.
  if ($arr_notif[$role]['CLOSED'] && ($changes['status_id']['add'] == 'Closed'))
    {
      //echo "DBG CLOSED bug notified<br>";
      return true;
    }

  //----------------------------------------------------------
  //Check: PSS_CHANGE  (Priority,Status,Severity changes)
  if ($arr_notif[$role]['PSS_CHANGE'] && 
      (isset($changes['priority']) || isset($changes['status_id']) || isset($changes['severity'])) )
    {
      //echo "DBG PSS_CHANGE notified<br>";
      return true;
    }


  //----------------------------------------------------------
  // Check :  ROLE_CHANGE (I'm added to or removed from this role)
  // Rk: This event is meanningless for Commenters. It also is for submitter but may be
  // one day the submitter will be changeable by the project admin so test it.
  // Rk #2: check this one at the end because it is the most CPU intensive and this
  // event seldomly happens
  if ($arr_notif['SUBMITTER']['ROLE_CHANGE'] &&
      (($changes['submitted_by']['add'] == $user_name) || ($changes['submitted_by']['del'] == $user_name)) &&
      ($role == 'SUBMITTER') )
    {
      //echo "DBG ROLE_CHANGE for submitter notified<br>";
      return true;
    }

  if ($arr_notif['ASSIGNEE']['ROLE_CHANGE'] &&
      (($changes['assigned_to']['add'] == $user_name) || ($changes['assigned_to']['del'] == $user_name)) &&
      ($role == 'ASSIGNEE') )
    {
      //echo "DBG ROLE_CHANGE for role assignee notified<br>";
      return true;
    }

  $arr_cc_changes = array();
  if (isset($changes['CC']['add']))
    $arr_cc_changes = split(',',$changes['CC']['add']);
  $arr_cc_changes[] = $changes['CC']['del'];
  $is_user_in_cc_changes = in_array($user_name,$arr_cc_changes);    
  $are_anyother_user_in_cc_changes =
     (!$is_user_in_cc_changes || count($arr_cc_changes)>1);    

  if ($arr_notif['CC']['ROLE_CHANGE'] && ($role == 'CC'))
    {
      if ($is_user_in_cc_changes)
	{
	  //echo "DBG ROLE_CHANGE for cc notified<br>";
	  return true;
	}
    }
    
  //----------------------------------------------------------
  //Check: CC_CHANGE  (CC_CHANGE is added or removed)
  // check this right after because  role cahange for cc can contradict
  // thee cc_change notification. If the role change on cc says no notification
  // then it has precedence over a cc_change
  if ($arr_notif[$role]['CC_CHANGE'] && isset($changes['CC']))
    {
      // it's enough to test role against 'CC' because if we are at that point
      // it means that the role_change for CC was false or that role is not CC
      // So if role is 'CC' and we are here it means that the user asked to not be
      // notified on role_change as CC, unless other users are listed in the cc changes
      if (($role != 'CC') || (($role == 'CC') && $are_anyother_user_in_cc_changes))
	{
	  //echo "DBG CC_CHANGE notified<br>";
	  return true; 
	}
    }


  //----------------------------------------------------------
  //Check: CHANGE_OTHER  (Any changes not mentioned above)
  // *** THIS ONE MUST ALWAYS BE TESTED LAST
    
  // Delete all tested fields from the $changes array. If any remains then it
  // means a notification must be sent
  unset($changes['details']);
  unset($changes['attach']);
  unset($changes['priority']);
  unset($changes['severity']);
  unset($changes['status_id']);
  unset($changes['CC']);
  unset($changes['assigned_to']);
  unset($changes['submitted_by']);
  if ($arr_notif[$role]['ANY_OTHER_CHANGE'] && count($changes))
    {
      //echo "DBG ANY_OTHER_CHANGE notified<br>";
      return true;
    }

  // Sorry, no notification...
  //echo "DBG No notification!!<br>";
  return false;
}

function trackers_build_notification_list($item_id, $group_id, $changes)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_build_notification_list($item_id, $group_id, $changes)';

  $sql="SELECT assigned_to, submitted_by from ".ARTIFACT." WHERE bug_id='$item_id'";
  $res_as=db_query($sql);

  // Rk: we store email addresses in a hash to make sure they are only
  // stored once. Normally if an email is repeated several times sendmail
  // would take care of it but I prefer taking care of it now.
  // Same for user ids.
  // We also use the user_ids hash to check if a user has already been selected for 
  // notification. If so it is not necessary to check it again in another role.
  $addresses = array();
  $user_ids = array();

  // check submitter notification preferences
  $user_id = db_result($res_as,0,'submitted_by');
  if ($user_id != 100)
    {
      if (trackers_check_notification($user_id, 'SUBMITTER', $changes))
	{
	  $user_ids[$user_id] = true;
	}
    }

  // check assignee  notification preferences
  $user_id = db_result($res_as,0,'assigned_to');
  if ($user_id != 100)
    {
      if (!$user_ids[$user_id] && trackers_check_notification($user_id, 'ASSIGNEE', $changes))
	{
	  $user_ids[$user_id] = true;
	}
    }

  // check old assignee  notification preferences if assignee was just changed
  $user_name = $changes['assigned_to']['del'];
  if ($user_name)
    {
      $res_oa = user_get_result_set_from_unix($user_name);
      $user_id = db_result($res_oa,0,'user_id');
      if ($user_id != 100 && !$user_ids[$user_id] && trackers_check_notification($user_id, 'ASSIGNEE', $changes))
	{
	  $user_ids[$user_id] = true;
	}
    }
    
  // check all CC 
  // a) check all the people in the current CC list
  // b) check the CC that has just been removed if any and see if she
  // wants to be notified as well
  // if the CC indentifier is an email address then notify in any case
  // because this user has no personal setting
  $res_cc = trackers_data_get_cc_list($item_id);
  $arr_cc = array();
  if ($res_cc && (db_numrows($res_cc) > 0))
    {
      while ($row = db_fetch_array($res_cc))
	{
	  $arr_cc[] = $row['email'];
	}
    }
  // Only one CC can be deleted at once so just append it to the list....
  $arr_cc[] = $changes['CC']['del'];

  while (list(,$cc) = each($arr_cc))
    {
      if (validate_email($cc))
	{
	  $addresses[utils_normalize_email($cc)] = true;
	}
      else
	{
	  $res = user_get_result_set_from_unix($cc);
	  $user_id = db_result($res,0,'user_id');
	  if (!$user_ids[$user_id] && trackers_check_notification($user_id, 'CC', $changes))
	    {
	      $user_ids[$user_id] = true;
	    }
	}
    } // while


  // check all commenters
  $res_com = trackers_data_get_commenters($item_id);
  if (db_numrows($res_com) > 0)
    {
      while ($row = db_fetch_array($res_com))
	{
	  $user_id = $row['mod_by'];
	  if (!$user_ids[$user_id] && trackers_check_notification($user_id, 'COMMENTER', $changes))
	    {
	      $user_ids[$user_id] = true;
	    }
	}
    }

  // build the final list of email addresses
  reset($user_ids);
  while (list($user_id,) = each($user_ids))
    {
      if ($user_id)
	{ // Dirty hack: for a reason need to be cleared out,
	  // a user_id = 0 arrived here.
	  $addresses[user_getemail($user_id)] = true;
	}
    }

  // return an array with all the email addresses the notification must be sent to
  return (array_keys($addresses));

}

function trackers_mail_followup($item_id,$more_addresses=false,$changes=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_mail_followup($item_id,$more_addresses=false,$changes=false)';
  global $sys_datefmt,$feedback,$ffeedback;
  /*
      Send a message to the person who opened this bug and the person it is assigned to - 
      modified by jstidd on 1/30/01 to eliminate default user assigned to
  */
  $sql="SELECT * from ".ARTIFACT." WHERE bug_id='$item_id'";

  $result=db_query($sql);
  $bug_href = "http://".$GLOBALS['sys_default_domain'].$GLOBALS['sys_home'].ARTIFACT."/?func=detailitem&item_id=$item_id";

  if ($result && db_numrows($result) > 0)
    {
			
      $group_id = db_result($result,0,'group_id');
 
      $body = "This mail is an automated notification from the ".ARTIFACT." tracker\n of the project: ".group_getname($group_id).".";

      
      if ($changes)
	{
	  $body .= "\n\n/**************************************************************************/\n";
	  $body .= "[".ARTIFACT." #".$item_id."] Latest Modifications:\n\n".
	     format_item_changes($changes)."\n\n";
	}

      $body .= "\n\n\n\n\n/**************************************************************************/\n";
      $body .= "[".ARTIFACT." #".$item_id."] Full Item Snapshot:\n\n";
 
      $body .= "URL: <".$bug_href.">\n";
      $body .= "Project: ".group_getname($group_id)."\n";
      $body .= "Submitted by: ".user_getrealname(db_result($result,0,'submitted_by'))."\n";      
      $body .= "On: ".format_date($sys_datefmt,db_result($result,0,'date'))."\n\n";
      
      // All other regular fields now		 
      $i=0;
      while ($field_name = trackers_list_all_fields())
	{
	  
	  // if the field is a special field or if not used by his project 
	  // then skip it. Otherwise print it in ASCII format.
	  if (!trackers_data_is_special($field_name) &&
	      trackers_data_is_used($field_name))
	    {
	      
	      $body .= trackers_field_display($field_name,
					      $group_id,
					      db_result($result,0,$field_name),
					      false,
					      true,
					      true,
					      true);			      
	      
	      $i++;
	      $body .= "\n";
	    }
	}
      $body .= "\n";
						   
      // Now display other special fields
      // Summary first. It is a special field because it is both
      // displayed in the
      // title of the bug form and here as a text field

      $body .= "\n".trackers_field_display('summary', $group_id,
					   db_result($result,0,'summary'),false,true,true,true).
	 "\n\n".trackers_field_display('details', $group_id,
				       db_result($result,0,'details'),false,true,true,true);

      // Then output the history of bug details from newest to oldest
      $body .= "\n\n".format_item_details($item_id, $group_id, true);

      // Then output the CC list
      $body .= "\n\n".format_item_cc_list($item_id, $group_id, true);

      // Then output the history of bug details from newest to oldest
      $body .= "\n\n".format_item_attached_files($item_id, $group_id, true);

      // Finally output the message trailer
      $body .= "\n\n\n\n\n\nFor detailed info, follow this link:";
      $body .= "\n<".$bug_href.">";


      // See who is going to receive the notification.
      // Plus append any other email 
      // given at the end of the list.
      $arr_addresses = trackers_build_notification_list($item_id,$group_id,$changes);
      $to = join(',',$arr_addresses);
      $from = user_getrealname().' <noreply@'.$GLOBALS['sys_default_domain'].'>';
      $subject = utils_unconvert_htmlspecialchars(db_result($result,0,'summary'));

      if ($more_addresses)
	{
	  $to .= ($to ? ',':'').$more_addresses;
	}	

      sendmail_mail($from, $to, $subject, $body, group_getunixname($group_id), ARTIFACT, $item_id);

      fb(_("Item update sent.")); 

    }
  else
    {
      fb(_("Could not send item update."), 0);
    }
}


function trackers_attach_file($item_id,
			      $group_id,
			      $input_file,
			      $input_file_name,
			      $input_file_type,
			      $input_file_size,
			      $file_description)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_attach_file($item_id,';			 


  $user_id = (user_isloggedin() ? user_getid(): 100);

  $data = fopen($input_file, 'r');
  if (!$data) 
    {
      fb(_("File not attached: unable to open it (fopen failure)."), 0);
      return false;
    }
  
  $data = addslashes(fread($data, filesize($input_file)));
  if ((strlen($data) < 20) || (strlen($data) > 512000))
    {
      fb(_("File not attached: must be > 20 chars and < 512000 chars in length."), 0);
      return false;
    }

  $sql = 'INSERT into '.ARTIFACT.'_file (bug_id,submitted_by,date,description, file,filename,filesize,filetype) '.
     "VALUES ($item_id,$user_id,'".time()."','".htmlspecialchars($file_description).
     "','$data','$input_file_name','$input_file_size','$input_file_type')";
    
  $res = db_query($sql);

  if (!$res)
    {
      fb(_("Error while attaching file:").' '.db_error($res), 0);
      return false;
    }
  else
    {
      $file_id = db_insertid($res);
      fb(sprintf(_("file #%s attached"), $file_id));
      $changes['attach']['description'] = $file_description;
      $changes['attach']['name'] = $input_file_name;
      $changes['attach']['size'] = $input_file_size;
      $changes['attach']['href'] = 'http://'.$GLOBALS['sys_default_domain'].$GLOBALS['sys_home'].ARTIFACT."/download.php?item_id=$item_id&amp;item_file_id=$file_id";
      trackers_data_add_history("Attached File",
				"-",
				"Added ".$input_file_name.", #".$file_id,
				$item_id,
				0,0,1);
      return true;
    }
}

function trackers_exist_cc($item_id,$cc)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_exist_cc($item_id,$cc)';
  $sql = "SELECT bug_cc_id FROM ".ARTIFACT."_cc WHERE bug_id='$item_id' AND email='$cc'";
  $res = db_query($sql);
  return (db_numrows($res) >= 1);
}

function trackers_insert_cc($item_id,$cc,$added_by,$comment,$date)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_insert_cc($item_id,$cc,$added_by,$comment,$date)';
  $sql = "INSERT INTO ".ARTIFACT."_cc (bug_id,email,added_by,comment,date) ".
     "VALUES ('$item_id','$cc','$added_by','$comment','$date')";
  $res = db_query($sql);

  trackers_data_add_history("Carbon-Copy",
			    "-",
			    "Added ".utils_antispam_email($cc),
			    $item_id,
			    0,0,1);
  return ($res);

}

function trackers_add_cc($item_id,$group_id,$email,$comment)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_add_cc($item_id,$group_id,$email,$comment)';
  global $feedback,$ffeedback;

  $user_id = (user_isloggedin() ? user_getid(): 100);

  $arr_email = utils_split_emails($email);
  $date = time();
  $ok = true;
  $changed = false;
  while (list(,$cc) = each($arr_email))
    {
      // Add this cc only if not there already
      if (!trackers_exist_cc($item_id,$cc))
	{
	  $changed = true;
	  $res = trackers_insert_cc($item_id,$cc,$user_id,$comment,$date);
	  if (!$res)
	    { $ok = false; }
	}
    }

  if (!$ok)
    {
      fb(_("CC addition failed."), 0);
    }
  else
    {
      fb(_("CC added."));
    }
  return $ok;
}

function trackers_delete_cc($group_id=false,$item_id=false,$item_cc_id=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_delete_cc($group_id=false,$item_id=false,$item_cc_id=false)';
  global $feedback,$ffeedback;

  // If both bug_id and bug_cc_id are given make sure the cc belongs 
  // to this bug (it's a bit paranoid but...)
  if ($item_id)
    {
      $res1 = db_query("SELECT bug_id,email from ".ARTIFACT."_cc WHERE bug_cc_id='$item_cc_id'");
      if ((db_numrows($res1) <= 0) || (db_result($res1,0,'bug_id') != $item_id) )
	{
	  " This $item_cc_id doesn't belong to this item, nothing will be done.";
	  return false;
	}
    }

  // Now delete the CC address
  $res2 = db_query("DELETE FROM ".ARTIFACT."_cc WHERE bug_cc_id='$item_cc_id'");
  if (!$res2)
    {
      fb(_("Failed to remove CC.").db_error($res2), 0);
      return false;
    }
  else
    {
      fb(_("CC Removed."));
      trackers_data_add_history("Carbon-Copy",
				"Removed ".utils_antispam_email(db_result($res1, 0, 'email')),
				"-",
				$item_id,
				0,0,1);
      return true;
    }
}


function trackers_delete_dependancy ($group_id, $item_id, $item_depends_on, $item_depends_on_artifact)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_delete_dependancy ($group_id, $item_id, $item_depends_on, $item_depends_on_artifact)';
  global $feedback,$ffeedback;
  
  // Can be done only by at least technicians
  // Note that is it possible to fake the system by providing a false group_id.
  // But well, consequences would be small an it will be easy to identify
  // the criminal.
  
  if (member_check(0,$group_id, member_create_tracker_flag(ARTIFACT).'1'))
    {
      $result = db_query("DELETE FROM ".ARTIFACT."_dependencies WHERE item_id='$item_id' AND is_dependent_on_item_id='$item_depends_on' AND is_dependent_on_item_id_artifact='$item_depends_on_artifact'");
    }

  if (!$result)
    {
      fb(_("Failed to delete dependancy.").db_error($result), 0);
      return false;
    }
  else
    {
      fb(_("Dependency Removed."));
      trackers_data_add_history("Dependencies",
				"Removed dependancy to ".$item_depends_on_artifact." #".$item_depends_on,
				"-",
				$item_id,
				0,0,1);
      trackers_data_add_history("Dependencies",
				"Removed dependancy from ".ARTIFACT." #".$item_id,
				"-",
				$item_depends_on,
				0,0,1);
      return true;
    }
}



/* 
   The ANY value is 0. The simple fact that
   ANY (0) is one of the value means it is Any even if there are
   other non zero values in the  array
*/
function trackers_isvarany($var)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_isvarany($var)';
  if (is_array($var))
    {
      reset($var);
      while (list(,$v) = each($var))
	{
	  if ($v == 0)
	    { return true; }
	}
      return false;
    }
  else
    {
      return ($var == 0);
    }

}


// Check is a sort criteria is already in the list of comma
// separated criterias. If so invert the sort order, if not then
// simply add it
function trackers_add_sort_criteria($criteria_list, $order, $msort)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_add_sort_criteria($criteria_list, $order, $msort)';
  //echo "<br>DBG \$criteria_list=$criteria_list,\$order=$order";

  if ($criteria_list)
    {
      $arr = explode(',',$criteria_list);
      $i = 0;
      while (list(,$attr) = each($arr))
	{
	  preg_match("/\s*([^<>]*)([<>]*)/", $attr,$match);
	  list(,$mattr,$mdir) = $match;
	  //echo "<br>DBG \$mattr=$mattr,\$mdir=$mdir";
	  if ($mattr == $order)
	    {
	      if ( ($mdir == '>') || (!isset($mdir)) )
		{
		  $arr[$i] = $order.'<';
		}  else
		  {
		    $arr[$i] = $order.'>';
		  }
	      $found = true;
	    }
	  $i++;
	}
    }

  if (!$found)
    {
      if (!$msort)
	{ unset($arr); }
      if ( ($order == 'severity') || ($order == 'hours') || (trackers_data_is_date_field($order)) )
	{
	  // severity, effort and dates sorted in descending order by default
	  $arr[] = $order.'<';
	}
      else
	{
	  $arr[] = $order.'>';
	}
    }
    
  //echo "<br>DBG \$arr[]=".join(',',$arr);

  return(join(',', $arr));	

}

// Transform criteria list to SQL query (+ means ascending
// - is descending)
function trackers_criteria_list_to_query($criteria_list)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_criteria_list_to_query($criteria_list)';

  $criteria_list = str_replace('>',' ASC',$criteria_list);
  $criteria_list = str_replace('<',' DESC',$criteria_list);
  return $criteria_list;
}

// Transform criteria list to readable text statement
// $url must not contain the morder parameter
function trackers_criteria_list_to_text($criteria_list, $url)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_criteria_list_to_text($criteria_list, $url)';

  if ($criteria_list)
    {

      $arr = explode(',',$criteria_list);

      while (list(,$crit) = each($arr))
	{

	  $morder .= ($morder ? ",".$crit : $crit);
	  $attr = str_replace('>','',$crit);
	  $attr = str_replace('<','',$attr);

	  $arr_text[] = '<a href="'.$url.'&amp;morder='.$morder.'#results">'.
	     trackers_data_get_label($attr).'</a><img src="'.$GLOBALS['sys_home'].'images/'.SV_THEME.'.theme/'.
	     ((substr($crit, -1) == '<') ? 'down' : 'up').
	     '.png" border="0">';
	}
    }

  return join(' > ',$arr_text);
}

function trackers_build_match_expression($field, &$to_match)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_build_match_expression($field, &$to_match)';

  // First get the field type
  $res = db_query("SHOW COLUMNS FROM ".ARTIFACT." LIKE '$field'");
  $type = db_result($res,0,'Type');

  //echo "<br>DBG '$field' field type = $type";

  if (preg_match('/text|varchar|blob/i', $type))
    {

      // If it is sourrounded by /.../ the assume a regexp
      // else transform into a series of LIKE %word%
      if (preg_match('/\/(.*)\//', $to_match, $matches))
	$expr = "$field RLIKE '".$matches[1]."' ";
      else
	{
	  $words = preg_split('/\s+/', $to_match);
	  reset($words);
	  while ( list($i,$w) = each($words))
	    {
	      //echo "<br>DBG $i, $w, $words[$i]";
	      $words[$i] = "$field LIKE '%$w%'";
	    }
	  $expr = join(' AND ', $words);
	}

    } 
  else if (preg_match('/int/i', $type))
    {

      // If it is sourrounded by /.../ the assume a regexp
      // else assume an equality
      if (preg_match('/\/(.*)\//', $to_match, $matches))
	{
	  $expr = "$field RLIKE '".$matches[1]."' ";
	}
      else
	{
	  $int_reg = '[+\-]*[0-9]+';
	  if (preg_match("/\s*(<|>|>=|<=)\s*($int_reg)/", $to_match, $matches))
	    {
	      // It's < or >,  = and a number then use as is
	      $matches[2] = (string)((int)$matches[2]);
	      $expr = "$field ".$matches[1]." '".$matches[2]."' ";
	      $to_match = $matches[1].' '.$matches[2];

	    } 
	  else if (preg_match("/\s*($int_reg)\s*-\s*($int_reg)/", $to_match, $matches))
	    {
	      // it's a range number1-number2
	      $matches[1] = (string)((int)$matches[1]);
	      $matches[2] = (string)((int)$matches[2]);
	      $expr = "$field >= '".$matches[1]."' AND $field <= '". $matches[2]."' ";
	      $to_match = $matches[1].'-'.$matches[2];

	    }
	  else if (preg_match("/\s*($int_reg)/", $to_match, $matches))
	    {
	      // It's a number so use  equality
	      $matches[1] = (string)((int)$matches[1]);
	      $expr = "$field = '".$matches[1]."'";
	      $to_match = $matches[1];

	    }
	  else
	    {
	      // Invalid syntax - no condition
	      $expr = '1';
	      $to_match = '';
	    }
	}
		     
    } 
  else if (preg_match('/float/i', $type))
    {

      // If it is sourrounded by /.../ the assume a regexp
      // else assume an equality
      if (preg_match('/\/(.*)\//', $to_match, $matches))
	{
	  $expr = "$field RLIKE '".$matches[1]."' ";
	}
      else
	{
	  $flt_reg = '[+\-0-9.eE]+';

	  if (preg_match("/\s*(<|>|>=|<=)\s*($flt_reg)/", $to_match, $matches))
	    {
	      // It's < or >,  = and a number then use as is
	      $matches[2] = (string)((float)$matches[2]);
	      $expr = "$field ".$matches[1]." '".$matches[2]."' ";
	      $to_match = $matches[1].' '.$matches[2];

	    }
	  else if (preg_match("/\s*($flt_reg)\s*-\s*($flt_reg)/", $to_match, $matches) )
	    {
	      // it's a range number1-number2
	      $matches[1] = (string)((float)$matches[1]);
	      $matches[2] = (string)((float)$matches[2]);
	      $expr = "$field >= '".$matches[1]."' AND $field <= '". $matches[2]."' ";
	      $to_match = $matches[1].'-'.$matches[2];

	    }
	  else if (preg_match("/\s*($flt_reg)/", $to_match, $matches))
	    {

	      // It's a number so use  equality
	      $matches[1] = (string)((float)$matches[1]);
	      $expr = "$field = '".$matches[1]."'";
	      $to_match = $matches[1];
	    }
	  else
	    {
	      // Invalid syntax - no condition
	      $expr = '1';
	      $to_match = '';
	    }
	}
	
    }
  else
    {
      // All the rest (???) use =
      $expr = "$field = '$to_match'";
    }

  //echo "<br>DBG expr to match for '$field' = $expr";
  return ' ('.$expr.') ';

}

// function moved to data.
function trackers_delete_file($group_id=false,$item_id=false,$item_file_id=false)
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':trackers_delete_file($group_id=false,$item_id=false,$item_file_id=false)';
  
  return trackers_data_delete_file($group_id, $item_id, $item_file_id);
}

?>
