<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: general.php,v 1.3 2004/01/31 00:56:18 yeupou Exp $
//
//
// Copyright 1999-2000 (c) The SourceForge Crew
//
//
//  Copyright 2000-2003 (c) Free Software Foundation
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//
//
//


function news_show_latest ($group_id,$limit=10,$show_summaries="true",$start_from="no") 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':news_show_latest ($group_id,$limit=10,$show_summaries="true",$start_from="no") '; 
  global $sys_datefmt;
  /*
		Show a simple list of the latest news items with a link to the forum
  */
  if (!isset($group_id))
    {
      $group_id = $GLOBALS['sys_group_id'];
    }
	  
  // We want the total number of news
  $news_total=news_total_number($group_id);

  // We fetch news item for that group
  if ($group_id != $GLOBALS['sys_group_id']) 
    {
      $wclause="news_bytes.group_id='$group_id' AND news_bytes.is_approved <> 4 AND news_bytes.is_approved <> 5";
    } 
  else 
    {
      $wclause='news_bytes.is_approved=1';
    }
	
  $sql="SELECT groups.group_name,groups.unix_group_name,user.user_name,news_bytes.forum_id,news_bytes.summary,news_bytes.date,news_bytes.details ".
     "FROM user,news_bytes,groups ".
     "WHERE $wclause ".
     "AND user.user_id=news_bytes.submitted_by ".
     "AND news_bytes.group_id=groups.group_id ".
     "ORDER BY date DESC";
  
  $sql .= " LIMIT ";

  if ($start_from != 0 && $start_from != "no" && $start_from != "nolinks") 
    {
      $sql .= "$start_from,$news_total";
    } 
  else 
    {
      $sql .= "$limit";
    }
  	
  $result=db_query($sql);
  $rows=db_numrows($result);

  if (!$result || $rows < 1) 
    {
      $return .= '<tr><td><h3>'._("No news items found").'</h3></td></tr>';
    } 
  else 
    {
      for ($i=0; $i<$rows; $i++) 
	{
	  // We want the number of message in this forum
	  $tres_count = db_query("SELECT group_forum_id FROM forum WHERE group_forum_id='". db_result($result,$i,'forum_id') ."'");
	  $trow_count = db_numrows($tres_count);
	  if ($show_summaries != "false") 
	    {
	      // Get the first paragraph of the story
	      $arr=explode("\n",db_result($result,$i,'details'));
	      
	      // If the first paragraph is short, and so
	      // are following paragraphs, add the next paragraph on
	      if ((strlen($arr[0]) < 200) && (strlen($arr[1].$arr[2]) < 300) && (strlen($arr[2]) > 5)) 
		{
		  $summ_txt='<br>'. utils_make_links( $arr[0].'<br>'.$arr[1].'<br>'.$arr[2], $group_id ).'<br><br>';
		} 
	      else 
		{
		  $summ_txt='<br>'. utils_make_links( $arr[0], $group_id ).'<br><br>';
		}
	      $proj_name = db_result($result,$i,'group_name');
	    } 
	  else 
	    {
	      $proj_name='';
	      $summ_txt='';
	    }
      if ($trow_count < 2) 
	{
	  $reply = _("reply");
	} 
      else 
	{
	  $reply = _("replies");
	}
      
      $return .= 
	'<tr><td class="'.utils_get_alt_row_color($i).'">'
	.'<a href="'.$GLOBALS['sys_home'].'forum/forum.php?forum_id='. db_result($result,$i,'forum_id') .'"><b>'
	.db_result($result,$i,'summary') . '</b></a><br>&nbsp;&nbsp;&nbsp;&nbsp;<i>'._("posted by").' <a href="'
	.$GLOBALS['sys_home'].'users/'. db_result($result,$i,'user_name') .'">'. db_result($result,$i,'user_name') 
	.'</a>, '. format_date($sys_datefmt,db_result($result,$i,'date')) .' - '.$trow_count.' '
	.$reply.'</i>'. $summ_txt
	.'</td></tr>';
	  
	}
    }
  
  if ($start_from != "nolinks") 
    {

      // No link is a trick to skip archives + submit news links
      
      if ($group_id != $GLOBALS['sys_group_id']) 
	{
	  // You can only submit news from a project now.
	  // You used to be able to submit general news.
	  $return .= '<tr><td class="'.utils_get_alt_row_color($i).'">'
	     .'<a href="'.$GLOBALS['sys_home'].'news/submit.php?group_id='
	     .$group_id.'"><font size="-1">['._("Submit News").']</font></a>'
	     .'</td></tr>';
	}
    
      $return .= '<tr><td class="'.utils_get_alt_row_color($i).'">'
	 .'<a href="'.$GLOBALS['sys_home'].'news/?group_id='.$group_id.'"><font size="-1">['
	 .$news_total.' '._("News in Archives").']</font></a>'
	 .'</td></tr>';
    }

  return $return;
}


function news_total_number($group_id) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':news_total_number($group_id) ';
  // We want the total number of news for a group
  if ($group_id != $GLOBALS['sys_group_id']) 
    { 
      $wclause="news_bytes.group_id='$group_id' AND news_bytes.is_approved <> 4 AND news_bytes.is_approved <> 5";
    } 
  else 
    {
      $wclause='news_bytes.is_approved=1';
    }
  $sql="SELECT count(*) FROM user,news_bytes,groups ".
     "WHERE $wclause ".
     "AND user.user_id=news_bytes.submitted_by ".
     "AND news_bytes.group_id=groups.group_id ";
  return db_result(db_query($sql),0,0);
}


function get_news_name($id) 
{
	$GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':get_news_name($id) ';
  /*
		Takes an ID and returns the corresponding forum name
  */
  $sql="SELECT summary FROM news_bytes WHERE id='$id'";
  $result=db_query($sql);
  if (!$result || db_numrows($result) < 1) 
    {
      return _("Not Found");
    } 
  else 
    {
      return db_result($result, 0, 'summary');
    }
}

?>
