<?php
// This file is part of the Savane project
// <http://gna.org/projects/savane/>
//
// $Id: register.php,v 1.33 2004/02/05 12:02:17 yeupou Exp $
//
//
//  Copyright 1999-2000 (c) The SourceForge Crew
//  Copyright 2000-2003 (c) Free Software Foundation
//
//  Copyright 2003-2004 (c) Mathieu Roy <yeupou--at--gna.org> 
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.



require "../include/pre.php";    
require "../include/account.php";

// ###### function register_valid()
// ###### checks for valid register from form post

function register_valid() 
{
  $GLOBALS[sys_debug_where] = __FILE__.':'.__LINE__.':register_valid() ';
  global $HTTP_POST_VARS, $G_USER;
  if (db_numrows(db_query("SELECT user_id FROM user WHERE "
			  . "user_name LIKE '".addslashes($HTTP_POST_VARS[form_loginname])."'")) > 0) 
    {
      $GLOBALS['register_error'] = _("That username already exists.");
      return 0;
    }  
  if (db_numrows(db_query("SELECT group_list_id FROM mail_group_list WHERE "
			  . "list_name LIKE '".addslashes($HTTP_POST_VARS[form_loginname])."'")) > 0) 
    {
      $GLOBALS['register_error'] = _("That username is blocked to avoid conflict with mailing-list addresses.");
      return 0;
    }
  if (db_numrows(db_query("SELECT user_id FROM user WHERE "
			  . "email LIKE '".addslashes($HTTP_POST_VARS[form_email])."'")) > 0) 
    {
      $GLOBALS['register_error'] = _("An account associated with that email address has already been created.");
      return 0;
    }

  if (!$HTTP_POST_VARS['form_loginname']) 
    {
      $GLOBALS['register_error'] = _("You must supply a username.");
      return 0;
    }
  if (!$HTTP_POST_VARS['form_pw']) 
    {
      $GLOBALS['register_error'] = _("You must supply a password.");
      return 0;
    }
  if (!$HTTP_POST_VARS['form_email']) 
    {
      $GLOBALS['register_error'] = _("You must supply a valid email address.");
      return 0;
    }
  if (!$HTTP_POST_VARS['form_realname']) 
    {
      $GLOBALS['register_error'] = _("You must supply a non-empty real name.");
      return 0;
    }

  // Remove quotes from the realname, we do not want to allow that but
  // it is not a blocker issue.
  $GLOBALS['form_realname'] = strtr($HTTP_POST_VARS['form_realname'], "\'\"", "   ");



  if ($GLOBALS['sys_use_pamauth'] != "yes" && $HTTP_POST_VARS['form_usepam'] !=1) 
    {
      // Only do password sanity checks if user does not want
      // to authenticate via PAM
      if (!$HTTP_POST_VARS['form_pw']) 
	{
	  $GLOBALS['register_error'] = _("You must supply a password.");
	  return 0;
	}
      if ($HTTP_POST_VARS['form_pw'] != $HTTP_POST_VARS['form_pw2']) 
	{
	  $GLOBALS['register_error'] = _("Passwords do not match.");
	  return 0;
	}
      if (!account_pwvalid($HTTP_POST_VARS['form_pw'])) 
	{
	  return 0;
	}
    }
  if (!account_namevalid($HTTP_POST_VARS['form_loginname'])) 
    {
      return 0;
    }

  if ($GLOBALS['sys_use_krb5'] == "yes")
    {
      $krb5ret = krb5_login($HTTP_POST_VARS['form_loginname'], $HTTP_POST_VARS['form_pw']);
      if($krb5ret == -1) 
	{ // KRB5_NOTOK
	  $GLOBALS['register_error'] = _("phpkrb5 module failure");
	  return 0;
	}
      elseif($krb5ret == 1) 
	{ // KRB5_BAD_PASSWORD
	  $GLOBALS['register_error'] = sprintf(_("User is a kerberos principal but password do not match. Please use your kerberos password for the first login and then change your %s password. This is necessary to prevent someone from stealing your account name."),$GLOBALS['sys_name']);
	  
	  return 0;
	}
      elseif ($krb5ret == "2") 
	{ 
	  // KRB5_BAD_USER 
	  
	  /*

FIXME : this is broken and seems to be due to the kerberos module.
        we did not changed anything about that and we get 2 as return
        for any name.

	  if($HTTP_POST_VARS['form_loginname']."@".$GLOBALS['sys_lists_domain']) 
	    {
	      $GLOBALS['register_error'] = sprintf(_("User %s is a known mail alias and cannot be used. If you own this alias (%s@%s) please create a another user (for instance xx%s) and ask %s@%s to rename it to %s."),
						   $HTTP_POST_VARS['form_loginname'],
						   $HTTP_POST_VARS['form_loginname'],
						   
						   $GLOBALS['sys_lists_domain'],
						   $HTTP_POST_VARS['form_loginname'],
						   $GLOBALS['sys_admin_list'],
						   $GLOBALS['sys_lists_domain'],
						   $HTTP_POST_VARS['form_loginname']);
	      return 0;
	    }
	  */
	} 
    }

  // if we got this far, it must be good

  if ($GLOBALS['sys_use_pamauth'] == "yes" && $HTTP_POST_VARS['form_usepam']==1) 
    {
      // if user chose PAM based authentication, set his encrypted
      // password to the specified string
      $passwd='PAM';
      $unix_pwd='PAM';
    }
  else 
    {
      $passwd=md5($HTTP_POST_VARS['form_pw']);
      $unix_pwd=account_genunixpw($HTTP_POST_VARS['form_pw']);
    }

  $confirm_hash = substr(md5($session_hash . $passwd . time()),0,16);

  $result=db_query("INSERT INTO user (user_name,user_pw,unix_pw,realname,email,add_date,"
		   . "status,confirm_hash,mail_siteupdates) "
		   . "VALUES ('"
		   . addslashes(strtolower($HTTP_POST_VARS[form_loginname]))."','"
		   . addslashes($passwd)."','"
		   . addslashes($unix_pwd)."','"
		   . addslashes($GLOBALS[form_realname])."','"
		   . addslashes($GLOBALS[form_email])."',"
		   . time().","
		   . "'P','" // status
		   . $confirm_hash
		   . "',"
		   . ($GLOBALS['form_mail_site']?"1":"0") . ")");

  if (!$result) 
    {
      exit_error('error',db_error());
    }
  else 
    {

      $GLOBALS['newuserid'] = db_insertid($result);

      // send mail
      $message = sprintf(_("Thank you for registering on the %s web site."),$GLOBALS['sys_name'])
	 ._(" In order to complete your registration, visit the following url:\n\n")
	 . $GLOBALS['sys_https_url']
	 . "/account/verify.php?confirm_hash=$confirm_hash\n\n"
	 ._("Enjoy the site").".\n\n"
	 . sprintf(_("--the %s team.")."\n",$GLOBALS['sys_name']);
		
      if ($krb5ret == KRB5_OK) 
	{
	  $message .= sprintf(_("P.S. Your kerberos password is now stored in encrypted form\nin the %s database."),$GLOBALS['sys_name']);
	  $message .= sprintf(_("For better security we advise you\nto change your %s password as soon as possible.\n"),$GLOBALS['sys_name']);
	}


      sendmail_mail($GLOBALS['sys_replyto']."@".$GLOBALS['sys_lists_domain'],
		    $GLOBALS['form_email'],
		    $GLOBALS['sys_name']." "._("Account Registration"),
		    $message);

      return 1;
    }
}


// ###### first check for valid login, if so, congratulate

if ($Register && register_valid()) 
{

  $HTML->header(array('title'=>_("Register Confirmation")));
  
  echo '<h3>'.$GLOBALS['sys_name'].' : '._("New Account Registration Confirmation").'</h3>'
    .sprintf(_("Congratulations. You have registered on %s "),$GLOBALS['sys_name'])
    ._("Your new username is:").' <b>'.user_getname($newuserid).'</b>.';
  
  echo '<p>'._("You are now being sent a confirmation email to verify your email address.") 
    ._(" Visiting the link sent to you in this email will activate your account").'</p>';
  
	
} 
else 
{ // not valid registration, or first time to page

  $HTML->header(array('title'=>_("Register")));

  echo "<h3>".$GLOBALS['sys_name']._(" New Account Registration")."</h3>";
	 
  if ($register_error) 
    {
      print "<p><font class=\"warn\">$register_error</font></p>";
    } 
  echo '<form action="register.php" method="post">';
  echo '<div class="inputfield"><h5>'._("Login Name").':</h5>';
  echo "<input type=\"text\" name=\"form_loginname\" value=\"$form_loginname\">";
  echo ' ( '.sprintf(_("If you have a %s account use that account name - dont use account name all numerical please"),$GLOBALS['sys_lists_domain']).' )</div>';

  echo '<div class="inputfield"><h5>'._("Password").':</h5>';
  echo "<input type=\"password\" name=\"form_pw\" value=\"$form_pw\"></div>";

  echo '<div class="inputfield"><h5>'._("Password (repeat)").':</h5>';
  echo "<input type=\"password\" name=\"form_pw2\" value=\"$form_pw2\"></div>";

  echo '<div class="inputfield"><h5>'._("Full/Real Name").':</h5>';
  echo '<input size="30" type="text" name="form_realname" value="'.$form_realname.'"></div>';

  echo '<div class="inputfield"><h5>'._("Email Address").':</h5>';
  echo '<input size="30" type="text" name="form_email" value="'.$form_email.'">';
  echo " ( "._("This email address will be verified before account activation.").')</div>';


  // CERN_SPECIFIC: speech related to AFS
  // Extension for PAM authentication
  if ($sys_use_pamauth=="yes") 
    {
      print "<p>Instead of providing a new Savannah password you
      may choose to authenticate via an <b>AFS</b> account you own
      at this site (this requires your Savannah login name to be the
      same as the AFS account name):";

      print '<p>&nbsp;&nbsp;&nbsp;<INPUT type="checkbox" 
      name="form_usepam" value="1" > use AFS based authentication';
    }
  // CERN_SPECIFIC: speech related to AFS


  echo '<p><input type="submit" name="Register" value="'._("Register").'"></p>';
  echo '</form>';

}

$HTML->footer(array());
?>
