#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_passwd.pl,v 1.3 2004/01/31 00:56:17 yeupou Exp $
#
#
#
# Copyright (C) Loic Dachary <loic@gnu.org>, 2001
#               Mathieu Roy <yeupou@gnu.org, 2003
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

#use strict;
use warnings;

use Getopt::Long;
use Digest::MD5 qw(md5_hex);
use Savannah;

my($verbose) = 0;
my($user);
my($password);
my($getopt);
my($help);
my($set);
my($unset);

eval {
    $getopt = GetOptions("verbose+" => \$verbose,
			 "set!" => \$set,
			 "unset!" => \$unset,
			 "user=s" => \$user,
			 "password=s" => \$password,
			 "help" => \$help);
};

if($help || !$getopt || !@ARGV) {
    print STDERR <<EOF;
usage: $0 [--user=<user> --password=<password>] [--help] [--verbose] 
          {--set|--unset} username [cryptpw]

	--set			set user passwd to aaa only if SSH user
	--unset			reset user to prohibit login
	--user=<user>		MySQL user name
	--password=<password>	MySQL password for user
	--verbose		increase verbosity level
	--help			print this help

Author: loic\@gnu.org
EOF
 exit(1);
}

my($user_name, $pw) = @ARGV;

$sys_dbuser = $user if $user;
$sys_dbpasswd = $password if $password;


my($unix_pw, $user_pw, $email);

$unix_pw = GetUserSettings($user_name, "unix_pw");
$user_pw = GetUserSettings($user_name, "user_pw");
$email = GetUserSettings($user_name, "email");


if($set) {
    if(!$pw) {
	print STDERR "provide username AND crypted password\n";
	exit(1);
    }
    if($unix_pw eq '' && $user_pw eq 'SSH') {
	my $success_a = SetUserSettings($user_name, 'unix_pw', $pw);
	my $success_b = SetUserSettings($user_name, 'user_pw', '');
	print "# password for $user_name <$email> changed \n" if $success_a && $success_b;
    } else {
	print STDERR "$user_name is not a pure SSH user (unix_pw eq $unix_pw && user_pw eq $user_pw)\n";
	exit(1);
    }
} elsif($unset) {
    if($user_pw eq '') {
	my $success_a = SetUserSettings($user_name, 'unix_pw', '');
	my $success_b = SetUserSettings($user_name, 'user_pw', 'SSH');
	print "# $user_name locked\n" if $success_a && $success_b;
    } else {
	print STDERR "$user_name does not have empty user_pw\n";
	exit(1);
    }
} else {
    print STDERR "specify --set or --unset\n";
    exit(1);
}

# END
