#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_mailman.pl,v 1.5 2004/02/05 16:59:11 yeupou Exp $
#
#
#
# Copyright (C) Mathieu Roy <yeupou@gnu.org>, 2004
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
#
# FIXME: check the drawback explanation below.


use strict;
use Getopt::Long;
use Savannah;
use POSIX qw(strftime);

my $script = "sv_mailman";
my $logfile = "/var/log/sv_database2system.log";
my $lockfile = "/var/run/sv_database2system.lock";

# Import
our $sys_mail_domain;

# Preconfigure
my $getopt;
my $help;
my $debug;

eval {
    $getopt = GetOptions("debug" => \$debug,
			 "help" => \$help);
};

if($help || !$getopt) {
    print STDERR <<EOF;
Usage: $0 [--user=<user> --password=<password>] [--help] [--verbose]

Create with mailman shell command a list for each mailing list found in
the database with status set to 1. 
It will change the status of the created list to 5.

      --help                   Show this help and exit


Author: yeupou\@gnu.org
EOF
 exit(1);
}

sub Escape {
    my $data = $_[0];
    $data =~ s/\'/\\\'/g;
    return $data;
}


# Log: Starting logging
open (LOG, ">>$logfile");
print LOG strftime "[$script] %c - starting\n", localtime;


# Locks: There are several sv_db2sys scripts but they should not run
#        concurrently.  So we add a lock
if (-e $lockfile) {
    print LOG "[$script] There's a lock ($lockfile), exiting\n";
    print LOG "[$script] ------------------------------------------------------\n";
    die "There's a lock ($lockfile), exiting";
}
`touch $lockfile`;


foreach my $line (GetDB("mail_group_list", 
			"status='1' OR status='0'",
			"group_list_id,list_name,is_public,password,list_admin,description")) {
    chomp($line);
    my ($id, $name, $is_public, $password, $admin, $description) = split(",", $line);
    $admin = GetUserName($admin)."\@".$sys_mail_domain;

    system("/usr/sbin/newlist",
	   "-q",
	   $name,
	   $admin,
	   $password);
    print LOG strftime "[$script] %c - List $name <$admin> newlist.\n", localtime;
    

    open(TMPCFG, "> /tmp/mmcfg");
    # Always set description
    print TMPCFG "description = '".Escape($description)."'\n";
    # mailman is not useful to fight spam, in fact being forced to use
    # it's interface instead of having a spamassassin doing the job
    # can be seen as a pain.
    print TMPCFG "require_explicit_destination = 0\n";
    # Do not advertise, hide archives, require approval if private list
    print TMPCFG "archive_private = 1\n" unless $is_public;
    print TMPCFG "advertised = 0\n" unless $is_public;
    print TMPCFG "subscribe_policy = 3\n" unless $is_public;
    # Always give access to the member list only to list admins
    print TMPCFG "private_roster = 2\n";
    # Set the message limit size reasonnably big
    ## Set in mm_cfg.py
    ## print TMPCFG "max_message_size = 10240\n";
    close(TMPCFG);

    system("/usr/sbin/config_list",
	   "--inputfile",
	   "/tmp/mmcfg",
	   $name);
    print LOG strftime "[$script] %c - List $name <$admin> config_list.\n", localtime;
    
    # Drawback1: I run here an SQL command to reset the status and to get
    # the admin login for each list. I could be resources consuming, however
    # I think we cannot expect this to be too heavy, not so many list should
    # be created everyday.
    # This scalability issue should be kept in mind, however.
    # Drawback2: currently this script only create list, does not
    # update them. This should be fixed in one way or another.


    SetDBSettings("mail_group_list",
		  "list_name='$name'",
		  "status='5'");
    print LOG strftime "[$script] %c - List $name <$admin> created.\n", localtime;
    
}


# Final exit
print LOG strftime "[$script] %c - work finished\n", localtime;
print LOG "[$script] ------------------------------------------------------\n";
unlink($lockfile, "/tmp/mmcfg");

# END

