#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_cvssh2.pl,v 1.3 2004/01/31 00:56:17 yeupou Exp $
#
#
# Copyright 2004 (c) Loic Dachary <loic@gnu.org>
#                    Mathieu Roy <yeupou@gnu.org>
#
#
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

# cvssh - Login shell for people who should only have CVS access

use strict;

$ENV{PATH}="/bin:/usr/bin";
$ENV{CVSEDITOR}="/bin/false";

if($#ARGV == 1 && $ARGV[0] eq "-c") {
    if(@ARGV[1] eq 'cvs server') {
        exec('/usr/bin/cvs', 'server');
    } elsif(@ARGV[1] =~ m:^scp .*-t /upload/:) {
        my(@args) = split(' ', @ARGV[1]);
        shift(@args);             
        exec('/usr/bin/scp', @args);
    } elsif(@ARGV[1] =~ m:^/usr/lib/ssh/sftp-server: ||
            @ARGV[1] =~ m:^/usr/lib/sftp-server: ||
            @ARGV[1] =~ m:^/usr/libexec/sftp-server:) {
        exec('/usr/local/savannah/bin/savannah-sftp');
    } elsif(@ARGV[1] =~ m:^rsync --server --sender:) {
        my($rsync, $server, $sender, $opts, $dot, $dir) = split(' ', @ARGV[1]);
        if($dir =~ m:^/cvs/: ||
           $dir =~ m:^/home/cvs/: ||
           $dir =~ m:^/cvsroot/: ||
           $dir =~ m:^/upload/:) {
            exec('/usr/bin/rsync', '--server', '--sender', $opts, '.', $dir);
        }                                 
    } elsif(@ARGV[1] =~ m:^rsync --server:) {
        my($rsync, @rest) = split(' ', @ARGV[1]);
        my($dir) = $rest[$#rest];
        print STDERR "dir = $dir\n";
        if($dir =~ m:^/upload/: ||
           $dir =~ m:^/audio-video/:) {
            exec('/usr/bin/rsync', @rest);
        }
    }
}

unless (-e "/etc/cvssh-errormsg.conf") {
    print STDERR "You tried to execute: @ARGV\n";
    print STDERR "Sorry, you are only allowed to execute : \n";
    print STDERR "   - CVS_RSH=ssh cvs commands\n";
    print STDERR "   - rsync from /cvsroot or /upload.\n";
    print STDERR "   - rsync to /upload.\n";
    print STDERR "   - sftp -1 to / (which is actually /upload).\n";
    print STDERR "   - scp to /upload.\n";
} else {
    open(ERRORMSG, "< /etc/cvssh-errormsg.conf");
    while (<ERRORMSG>) {
	print STDERR $_;
    }
    close(ERRORMSG);
}
exit(1);
