#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_migrate.pl,v 1.3 2004/01/31 00:56:17 yeupou Exp $
#
#
#
# Copyright (C) Loic Dachary <loic@gnu.org>, 2001
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#

use strict;
package main;

use Getopt::Long;

my($verbose) = 0;
my($getopt);
my($help);
my($user);
my($password);
my($add);
my($bind);
my($mail);

eval {
    $getopt = GetOptions("verbose+" => \$verbose,
			 "user=s" => \$user,
			 "password=s" => \$password,
			 "add!" => \$add,
			 "bind!" => \$bind,
			 "mail!" => \$mail,
			 "help" => \$help);
};

if($help || !$getopt) {
    print STDERR <<EOF;
usage: $0 [--user=<user> --password=<password>] [--help] [--verbose]
          --bind | --add

	--user=<user>		MySQL user name
	--password=<password>	MySQL password for user
	--verbose		increase verbosity level
	--help			print this help
        --add                   add missing users and projects
        --bind                  bind user to projects

Author: loic\@gnu.org
EOF
 exit(1);
}

my(%projects) = map { $_ => 1 } @ARGV;

#
# Slurp savannah user list
#
my(%user_savannah);
my(%mail_savannah);
my(%user_password);

open(LIST, "mysql $user $password -Ne \"SELECT user_name,user_id,email FROM user WHERE user.unix_status = 'A' || user.unix_status = 'N'\" sourceforge |") or die "mysql $user $password failed";

while(<LIST>) {
    chop;
    my($name, $id, $mail) = split("\t", $_);
    $user_savannah{$name} = $id;
    $mail_savannah{$name} = $mail;
}

close(LIST);

#
# Slurp project 2 user lists
#
my(%savannah_project2user);

open(LIST, "mysql $user $password -Ne \"SELECT user.user_name, groups.unix_group_name FROM user,user_group,groups WHERE user.user_id=user_group.user_id AND user_group.group_id=groups.group_id AND (user.unix_status = 'A' || user.unix_status = 'N') AND user.user_name != 'admin' AND groups.status = 'A'\" sourceforge|") or die "mysql $user $password failed";

while(<LIST>) {
    chop;
    my($user, $project) = split("\t", $_);
    $savannah_project2user{$project}{$user} = 1;
}

close(LIST);

#
# Slurp savannah project list
# 
my(%savannah_projects);
open(LIST, "mysql $user $password -Ne \"SELECT unix_group_name, group_id FROM groups WHERE groups.status = 'A'\" sourceforge |") or die "mysql $user $password failed";

while(<LIST>) {
    chop;
    my($project, $id) = split("\t", $_);
    $savannah_projects{$project} = $id;
}

close(LIST);


#
# Slurp /etc/passwd
#
my(%user_password);
my(@entry);
while(@entry = getpwent()) {
    next if($entry[0] eq 'anoncvs' || $entry[0] eq 'webcvs' || $entry[0] eq 'nobody');
    $user_password{$entry[0]} = [ @entry ];
}

if($add) {
#
# Slurp /etc/group
# And create groups entry for each project
#
    my($hash) = "__d344" . time() . "4a4a322430de978a";
    my($hashnum) = "03";
    my(%newuser);
    my(%project2users);

    while(@entry = getgrent()) {
	next if(!exists($projects{$entry[0]}));

	my($group) = $entry[0];
	my(@users) = grep { $_ !~ /^(anoncvs|webcvs)$/ } split(' ', $entry[3]);
	@users = map {
	    if(!exists($user_password{$_})) {
		print STDERR "group $group: user $_ does not exist\n";
		();
	    } else {
		$_;
	    }
	} @users;

	my($time) = time();
	if(exists($savannah_projects{$entry[0]})) {
	    print STDERR "# $entry[0] is already in savannah\n";
	} else {
	    print "INSERT INTO groups (group_name, homepage, html_cvs, is_public, status, unix_group_name, license, register_time, rand_hash, use_mail, use_survey, use_patch, use_forum, use_pm, use_cvs, use_news, use_support, type, use_docman) VALUES ('$group', 'www.gnu.org/software/$group/', '/software/$group/', 1, 'A', '$group', 'gpl', $time, '$hash$hashnum', 0, 0, 1, 0, 1, 1, 1, 1, 1, 0);\n";
	    $hashnum++;
	}

	my($user);
	foreach $user (@users) {
	    $newuser{$user} = 1 if(!exists($user_savannah{$user}));
	}
	$project2users{$group} = \@users;
    }

#
# Slurp pserver passwd file
#
    my(%pserver);
    my($pserver_passwd) = "/subversions/cvs/common/CVSROOT/passwd";
    open(FILE, "<$pserver_passwd") or die "cannot open $pserver_passwd for reading: $!";
    while(<FILE>) {
	/(.*?):(.*)/;
	$pserver{$1} = $2;
    }
    close(FILE);

#
# Create users missing from savannah
#
    my($user);
    foreach $user (keys(%newuser)) {
	#
	# Find out how user access CVS
	#
	my($unix_pw, $user_pw);
	system("krb5test $user fakepass");
	my($ret) = $? / 256;
	if($ret == 1) {
	    # kerberos user
	    $unix_pw = $user_pw = '';
	} elsif($ret == 2) {
	    # non kerberos user
	    if(exists($pserver{$user})) {
		# pserver user
		$unix_pw = $pserver{$user};
		$user_pw = '';
	    } else {
		# not pserver user
		my($file) = "/home/$user/.ssh/authorized_keys";
		my($dir) = "/home/$user/.lsh";
		if(-f $file || -d $dir) {
		    # public ssh/lsh key user
		    $unix_pw = '';
		    $user_pw = 'SSH';
		} else {
		    # no way to access subversions !
		    print STDERR "$user has not way to access subversions, ignored\n";
		    next;
		}
	    }
	} else {
	    die "unexpected return for krb5test $user fakepass : $ret";
	}	  
	#
	# Extract email address and full name
	#
	my($comment) = $user_password{$user}->[6];
	my($realname, $email);
	if($comment =~ /^(.*?)[,\s]*<\s*(.*?)\s*>\s*$/) {
	    $realname = $1;
	    $email = $2;
	} else {
	    print STDERR "$user: comment $comment cannot be parsed, ignore\n";
	    next;
	}
	my($time) = time();
	print "INSERT INTO user (user_name, email, user_pw, realname, status, unix_pw, unix_status, add_date, mail_siteupdates, mail_va, people_view_skills, people_resume, timezone) VALUES ('$user', '$email', '$user_pw', '$realname', 'A', '$unix_pw', 'A', '$time', 0, 0, 0, 0, 'GMT');\n";
    }
} elsif($bind) {

    while(@entry = getgrent()) {
	next if(!exists($projects{$entry[0]}));

	my($group) = $entry[0];
	my(@users) = grep { $_ !~ /^(anoncvs|webcvs)$/ } split(' ', $entry[3]);
	@users = map {
	    if(!exists($user_password{$_})) {
		print STDERR "group $group: user $_ does not exist\n";
		();
	    } else {
		$_;
	    }
	} @users;

	print "# binding $group\n";
	my($user);
	foreach $user (@users) {
	    next if(exists($savannah_project2user{$group}{$user}));
	    print "INSERT INTO user_group (user_id, group_id, admin_flags, bug_flags, forum_flags, project_flags, patch_flags, support_flags, doc_flags) VALUES ($user_savannah{$user}, $savannah_projects{$group}, '', 2, 2, 2, 2, 2, 0); # $group -> $user\n";
	}
    }
} elsif($mail) {
    my($project);
    foreach $project (@ARGV) {
	my($mails) = join(', ', map { $mail_savannah{$_} } keys(%{$savannah_project2user{$project}}));
	print <<EOF;
From: loic\@gnu.org
To: $mails
cc: savannah-hackers\@gnu.org
fcc: gnu
Subject: $project integrated to http://savannah.gnu.org/projects/$project/
X-Mailer: VM 6.72 under Emacs 20.7.1
Reply-To: savannah-hackers\@gnu.org
--text follows this line--

  Hi,

  $project was integrated in the SourceForge.net clone dedicated to GNU
projects that can be found at http://savannah.gnu.org/. The URL of
the $project project on Savannah is http://savannah.gnu.org/projects/$project/
It provides you with the following facilities:

  . Web interface to handle contributors CVS write access. You don't
    need to ask someone, it is automated. Only the $project project
    administrators on Savannah can give CVS write access to new
    contributor or deny access to an existing one. This is basically a
    one click operation.  If you want to become a project
    administrator ask an existing administrator to grant you the right
    or, if there are no project administrator, ask savannah-hackers\@gnu.org
    to become one.

  . Editing http://www.gnu.org/software/$project/ pages using CVS 
    instead of login onto gnudist.gnu.org. As soon as you commit
    information in this CVS tree, it will show on 
    http://www.gnu.org/software/$project/.

  . The $project CVS tree now has a separate CVS history instead of an
    history merged with all other projects hosted on
    subversions.gnu.org.

  For more information on how to access the CVS trees, click on the
CVS menu at http://savannah.gnu.org/projects/$project/.

  No action is required from you, the Savannah setup does not require
that you change your habits. However, it would be nice of you to do
the following:

  - login at least once on https://savannah.gnu.org/account/login.php
  - read the CVS instructions for the $project project
  - checkout the $project CVS tree according to these instructions

  When all contributors will be using the new CVS tree, we will be
able to remove the backward compatibility installation for $project.

  When you login Savannah, the transaction is secure (SSL).  In case
you wonder what all this is about you can check the cvs-hackers and
webmasters mailing lists archive, they contain a lot of discussions
regarding this planned integration. 

  If you have a Kerberos account on gnu.org, use the same login and
password on Savannah and change the password immediately afterwards:
it will not change your Kerberos password, just the Savannah
password. 

  If you only have a pserver account, use the same login and
password on Savannah.  

  If you have both (Kerberos and pserver), use the Kerberos account
login and password. Note that after login for the first time your
pserver password will be set to the same password you use to login on
Savannah. Please change the Savannah password immediately after your
first login: it will not change your Kerberos password, just the
Savannah password.

  If you have none and access CVS using SSH public keys, ask to
cvs-hackers\@gnu.org to give you a password. This last case requires
human interaction to prevent someone from stealing your account name.

  Please report problems or questions to
https://savannah.gnu.org/support/?func=addsupport&group_id=11 or by
email to savannah-hackers\@gnu.org if you don't have (or don't want to
use) a web browser.

  Cheers,

-- 
Loic   Dachary         http://www.dachary.org/  loic\@dachary.org
24 av Secretan         http://www.senga.org/      loic\@senga.org
75019    Paris         Tel: 33 1 42 45 09 16        loic\@gnu.org
EOF
    }
} else {
    print STDERR "must specify either --bind or --add\n";
    exit(1);
}
