#!/bin/sh
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_cvssh.sh,v 1.14 2004/01/31 00:56:17 yeupou Exp $ 
#
#
# Copyright 1999 (c) Gordon Matzigkeit <gord@fig.org>
#
#
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#



# cvssh - Login shell for people who should only have CVS access
# Gordon Matzigkeit <gord@fig.org>, 1999-12-02


PATH=/usr/local/bin:/bin:/usr/bin
export CVSEDITOR=/bin/false

valid=no
status=1
if test $# -eq 2 && test "X$1" = X-c; then
 case "X$2" in
 'Xcvs server')
  # Actually run it.                                                     
  valid=yes
  $2
  ;;

 'Xscp '*'-t /upload/'*)
  # Actually run it.
  valid=yes
  $2
  ;;

 'X'*'/sftp-server'*)
  # Actually run it.
  valid=yes
  # Works in a jail
  /usr/local/savannah/bin/savannah-sftp
  # This line below works, but is not chrooted.
  #/usr/lib/sftp-server
  ;;

 'Xrsync --server --sender '*)
  dir=`echo "$2" | sed -e 's/^.*[       ]//'`
  case "$dir" in
  *..* | *CVSROOT*) ;;
  /cvs/* | /home/cvs/* | /cvsroot/* | /upload/* )
   # Actually run the command.
   valid=yes
   $2
   ;;
  esac
  ;;  

 'Xrsync --server '*)
  dir=`echo "$2" | sed -e 's/^.*[       ]//'`
  case "$dir" in
  *..* | *CVSROOT*) ;;
  /upload/* | /audio-video/* )
   # Actually run the command.
   valid=yes
   $2
   ;;
  esac
  ;;  
 esac
 status=$?
fi

if test $valid = no; then
 echo "You tried to execute: \`$0${1+ $@}'." 1>&2
 echo "Sorry, you are only allowed to execute : " 1>&2
 echo "   - CVS_RSH=ssh cvs commands" 1>&2
 echo "   - rsync from /cvsroot or /upload." 1>&2
 echo "   - rsync to /upload." 1>&2
 echo "   - sftp -1 to / (which is actually /upload)." 1>&2
 echo "   - scp to /upload." 1>&2
fi

# This sleep is necessary to allow krshd to close the connection properly.
sleep 2
exit $status
